/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.tileentities;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import thebetweenlands.inventory.container.ContainerAnimator;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.recipes.misc.AnimatorRecipe;
import thebetweenlands.tileentities.TileEntityBasicInventory;

public class TileEntityAnimator
extends TileEntityBasicInventory {
    private int prevStackSize = 0;
    public ItemStack itemToAnimate = null;
    public int fuelBurnProgress;
    public int lifeCrystalLife;
    public int fuelConsumed = 0;
    public int requiredFuelCount = 32;
    public int requiredLifeCount = 32;
    public boolean itemAnimated = false;
    private ItemStack prevItem;
    private ItemStack prevToAnimateItem;

    public TileEntityAnimator() {
        super(3, "animator");
    }

    public void func_145845_h() {
        AnimatorRecipe recipe;
        if (this.itemToAnimate != null && (recipe = AnimatorRecipe.getRecipe(this.itemToAnimate)) != null) {
            this.requiredFuelCount = recipe.requiredFuel;
            this.requiredLifeCount = recipe.requiredLife;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isCrystalInslot()) {
            this.lifeCrystalLife = 128 - this.getCrystalPower();
        }
        if (!(this.isSlotInUse(0) && this.isSlotInUse(1) && this.isSlotInUse(2))) {
            this.fuelBurnProgress = 0;
            this.fuelConsumed = 0;
        }
        if (this.isSlotInUse(0) && this.isCrystalInslot() && this.isSulfurInslot() && this.fuelConsumed < this.requiredFuelCount && this.isValidFocalItem()) {
            this.itemToAnimate = this.inventory[0];
            if (this.lifeCrystalLife >= this.requiredLifeCount) {
                ++this.fuelBurnProgress;
                if (this.fuelBurnProgress >= 42) {
                    this.fuelBurnProgress = 0;
                    this.func_70298_a(2, 1);
                    ++this.fuelConsumed;
                }
                this.itemAnimated = false;
            }
        }
        if (!(!this.isSlotInUse(2) || this.itemAnimated || this.isSlotInUse(0) && this.isSlotInUse(1))) {
            this.fuelBurnProgress = 0;
            this.fuelConsumed = 0;
        }
        if (this.fuelConsumed >= this.requiredFuelCount && this.isSlotInUse(0) && this.isSlotInUse(1) && !this.itemAnimated) {
            recipe = AnimatorRecipe.getRecipe(this.inventory[0]);
            ItemStack result = recipe.onAnimated(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (result == null) {
                result = recipe.getResult();
            }
            if (result != null) {
                this.func_70299_a(0, result.func_77946_l());
            }
            this.inventory[1].func_77964_b(this.inventory[1].func_77960_j() + recipe.requiredLife);
            this.itemAnimated = true;
        }
        if (this.prevStackSize != (this.isSlotInUse(0) ? this.inventory[0].field_77994_a : 0)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.prevItem != (this.isSlotInUse(0) ? this.inventory[0] : null)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.prevItem = this.isSlotInUse(0) ? this.inventory[0] : null;
        this.prevStackSize = this.isSlotInUse(0) ? this.inventory[0].field_77994_a : 0;
        this.func_145836_u();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean isCrystalInslot() {
        return this.isSlotInUse(1) && this.inventory[1].func_77973_b() == BLItemRegistry.lifeCrystal && this.inventory[1].func_77960_j() < this.inventory[1].func_77958_k();
    }

    public int getCrystalPower() {
        if (this.isCrystalInslot()) {
            return this.inventory[1].func_77960_j();
        }
        return 0;
    }

    public boolean isSulfurInslot() {
        return this.isSlotInUse(2) && this.inventory[2].func_77973_b() == BLItemRegistry.itemsGeneric && this.inventory[2].func_77960_j() == ItemGeneric.EnumItemGeneric.SULFUR.id;
    }

    public boolean isSlotInUse(int slot) {
        return this.inventory[slot] != null;
    }

    public boolean isValidFocalItem() {
        return this.inventory[0] != null && AnimatorRecipe.getRecipe(this.inventory[0]) != null;
    }

    public void sendGUIData(ContainerAnimator animator, ICrafting craft) {
        craft.func_71112_a((Container)animator, 0, this.fuelBurnProgress);
        craft.func_71112_a((Container)animator, 1, this.lifeCrystalLife);
        craft.func_71112_a((Container)animator, 2, this.itemAnimated ? 1 : 0);
        craft.func_71112_a((Container)animator, 3, this.fuelConsumed);
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 0: {
                this.fuelBurnProgress = value;
                break;
            }
            case 1: {
                this.lifeCrystalLife = value;
                break;
            }
            case 2: {
                if (value == 1) {
                    this.itemAnimated = true;
                    break;
                }
                this.itemAnimated = false;
                break;
            }
            case 3: {
                this.fuelConsumed = value;
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("life", this.lifeCrystalLife);
        nbt.func_74768_a("progress", this.fuelBurnProgress);
        nbt.func_74768_a("itemsConsumed", this.fuelConsumed);
        nbt.func_74757_a("lifeDepleted", this.itemAnimated);
        NBTTagCompound toAnimateCompound = new NBTTagCompound();
        if (this.itemToAnimate != null) {
            this.itemToAnimate.func_77955_b(toAnimateCompound);
        }
        nbt.func_74782_a("toAnimate", (NBTBase)toAnimateCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lifeCrystalLife = nbt.func_74762_e("life");
        this.fuelBurnProgress = nbt.func_74762_e("progress");
        this.fuelConsumed = nbt.func_74762_e("itemsConsumed");
        this.itemAnimated = nbt.func_74767_n("lifeDepleted");
        NBTTagCompound toAnimateStackCompound = nbt.func_74775_l("toAnimate");
        this.itemToAnimate = toAnimateStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)toAnimateStackCompound) : null;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("life", this.lifeCrystalLife);
        nbt.func_74768_a("progress", this.fuelBurnProgress);
        nbt.func_74757_a("lifeDepleted", this.itemAnimated);
        NBTTagCompound outputItemCompound = new NBTTagCompound();
        if (this.isSlotInUse(0)) {
            this.inventory[0].func_77955_b(outputItemCompound);
        }
        nbt.func_74782_a("outputItem", (NBTBase)outputItemCompound);
        NBTTagCompound toAnimateCompound = new NBTTagCompound();
        if (this.itemToAnimate != null) {
            this.itemToAnimate.func_77955_b(toAnimateCompound);
        }
        nbt.func_74782_a("toAnimate", (NBTBase)toAnimateCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.lifeCrystalLife = packet.func_148857_g().func_74762_e("life");
        this.fuelBurnProgress = packet.func_148857_g().func_74762_e("progress");
        this.itemAnimated = packet.func_148857_g().func_74767_n("lifeDepleted");
        NBTTagCompound itemStackCompound = packet.func_148857_g().func_74775_l("outputItem");
        this.inventory[0] = itemStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)itemStackCompound) : null;
        NBTTagCompound toAnimateStackCompound = packet.func_148857_g().func_74775_l("toAnimate");
        this.itemToAnimate = toAnimateStackCompound.func_74765_d("id") != 0 ? ItemStack.func_77949_a((NBTTagCompound)toAnimateStackCompound) : null;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 1 && stack != null && stack.func_77973_b().equals(BLItemRegistry.lifeCrystal)) {
            return true;
        }
        if (slot == 2 && stack != null && stack.func_77973_b().equals(BLItemRegistry.itemsGeneric) && stack.func_77960_j() == ItemGeneric.EnumItemGeneric.SULFUR.id) {
            return true;
        }
        return slot == 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{0};
        }
        if (side == 1) {
            return new int[]{0};
        }
        return new int[]{1, 2};
    }
}

