/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.recipes.purifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import thebetweenlands.recipes.purifier.PurifierRecipeAspectVial;
import thebetweenlands.recipes.purifier.PurifierRecipeCorrodible;
import thebetweenlands.recipes.purifier.PurifierRecipeStandard;

public abstract class PurifierRecipe {
    private static final List<PurifierRecipe> RECIPES = new ArrayList<PurifierRecipe>();
    private static final PurifierRecipeCorrodible CORRODIBLE_ITEMS_RECIPE = new PurifierRecipeCorrodible();
    private static final PurifierRecipeAspectVial ASPECT_VIAL_ITEMS_RECIPE = new PurifierRecipeAspectVial();

    public abstract ItemStack getOutput(ItemStack var1);

    public abstract ItemStack getInput(ItemStack var1);

    public abstract boolean matches(ItemStack var1);

    public abstract boolean matchesOutput(ItemStack var1);

    public static void addRecipe(ItemStack output, ItemStack input) {
        RECIPES.add(new PurifierRecipeStandard(output, input));
    }

    public static ItemStack getRecipeOutput(ItemStack input) {
        for (PurifierRecipe recipe : RECIPES) {
            if (!recipe.matches(input)) continue;
            return recipe.getOutput(input);
        }
        return null;
    }

    public static ItemStack getRecipeInput(ItemStack output) {
        for (PurifierRecipe recipe : RECIPES) {
            if (!recipe.matchesOutput(output)) continue;
            return recipe.getInput(output);
        }
        return null;
    }

    public static List<PurifierRecipe> getRecipeList() {
        return Collections.unmodifiableList(RECIPES);
    }

    public static boolean areStacksTheSame(ItemStack a, ItemStack b) {
        return PurifierRecipe.areStacksTheSame(a, b, false);
    }

    public static boolean areStacksTheSame(ItemStack a, ItemStack b, boolean matchStackSize) {
        if (a == null || b == null) {
            return false;
        }
        if (!(a.func_77973_b() != b.func_77973_b() || a.func_77960_j() != b.func_77960_j() || matchStackSize && a.field_77994_a != b.field_77994_a)) {
            if (a.func_77942_o() && b.func_77942_o()) {
                return a.func_77978_p().equals((Object)b.func_77978_p());
            }
            return a.func_77942_o() == b.func_77942_o();
        }
        return false;
    }

    static {
        RECIPES.add(CORRODIBLE_ITEMS_RECIPE);
        RECIPES.add(ASPECT_VIAL_ITEMS_RECIPE);
    }
}

