/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.recipes.misc;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thebetweenlands.utils.DyeOreDictHelper;

public class RecipeDyeColorNBT
implements IRecipe {
    private final int recipeWidth;
    private final int recipeHeight;
    private final Object[] recipeItems;
    private final ItemStack recipeOutput;
    private ItemStack result;

    public RecipeDyeColorNBT(ItemStack recipeOutput, Object[] recipeObjects) {
        this.recipeOutput = recipeOutput;
        String craftingRows = "";
        int i = 0;
        int recipeWidth = 0;
        int recipeHeight = 0;
        if (recipeObjects[i] instanceof String[]) {
            String[] craftingLines;
            for (String row : craftingLines = (String[])recipeObjects[i++]) {
                ++recipeHeight;
                recipeWidth = row.length();
                craftingRows = craftingRows + row;
            }
        } else {
            while (recipeObjects[i] instanceof String) {
                String row = (String)recipeObjects[i++];
                ++recipeHeight;
                recipeWidth = row.length();
                craftingRows = craftingRows + row;
            }
        }
        this.recipeWidth = recipeWidth;
        this.recipeHeight = recipeHeight;
        HashMap charMap = Maps.newHashMap();
        while (i < recipeObjects.length) {
            Character recipeSymbol = (Character)recipeObjects[i];
            Object recipeItem = null;
            Object ingredient = recipeObjects[i + 1];
            if (ingredient instanceof Item) {
                recipeItem = new ItemStack((Item)ingredient);
            } else if (ingredient instanceof Block) {
                recipeItem = new ItemStack((Block)ingredient, 1, Short.MAX_VALUE);
            } else if (ingredient instanceof ItemStack) {
                recipeItem = ((ItemStack)ingredient).func_77946_l();
            } else if (ingredient instanceof String) {
                recipeItem = OreDictionary.getOres((String)((String)ingredient));
            }
            charMap.put(recipeSymbol, recipeItem);
            i += 2;
        }
        this.recipeItems = new Object[recipeWidth * recipeHeight];
        for (i = 0; i < recipeWidth * recipeHeight; ++i) {
            char recipeSymbol = craftingRows.charAt(i);
            this.recipeItems[i] = charMap.containsKey(Character.valueOf(recipeSymbol)) ? charMap.get(Character.valueOf(recipeSymbol)) : null;
        }
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public boolean func_77569_a(InventoryCrafting inventoryCrafting, World world) {
        this.result = this.recipeOutput.func_77946_l();
        this.result.func_77983_a("color", (NBTBase)new NBTTagInt(11));
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatch(inventoryCrafting, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inventoryCrafting, i, j, false)) continue;
                return true;
            }
        }
        this.result = null;
        return false;
    }

    private boolean checkMatch(InventoryCrafting inventoryCrafting, int offsetX, int offsetY, boolean mirrored) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stackInCraftingTable;
                int ax = x - offsetX;
                int ay = y - offsetY;
                Object target = null;
                if (ax >= 0 && ay >= 0 && ax < this.recipeWidth && ay < this.recipeHeight) {
                    target = mirrored ? this.recipeItems[this.recipeWidth - ax - 1 + ay * this.recipeWidth] : this.recipeItems[ax + ay * this.recipeWidth];
                }
                if ((stackInCraftingTable = inventoryCrafting.func_70463_b(x, y)) == null && target == null) continue;
                if (stackInCraftingTable == null || target == null) {
                    return false;
                }
                if (target instanceof ItemStack) {
                    if (OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)stackInCraftingTable, (boolean)false)) continue;
                    return false;
                }
                if (!(target instanceof List)) continue;
                Iterator iter = ((List)target).iterator();
                boolean matched = false;
                while (iter.hasNext() && !matched) {
                    ItemStack ingredient = (ItemStack)iter.next();
                    matched = OreDictionary.itemMatches((ItemStack)ingredient, (ItemStack)stackInCraftingTable, (boolean)false);
                    if (!matched || !DyeOreDictHelper.isDye(stackInCraftingTable)) continue;
                    this.result.func_77983_a("color", (NBTBase)new NBTTagInt(DyeOreDictHelper.getDyeMetadata(stackInCraftingTable)));
                }
                if (matched) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_77570_a() {
        return this.recipeWidth * this.recipeHeight;
    }
}

