/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.recipes.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class PestleAndMortarRecipe {
    private static final List<PestleAndMortarRecipe> recipes = new ArrayList<PestleAndMortarRecipe>();
    private final ItemStack output;
    private final ItemStack input;

    public static void addRecipe(ItemStack output, ItemStack input) {
        recipes.add(new PestleAndMortarRecipe(output, input));
    }

    public static ItemStack getOutput(ItemStack input) {
        for (PestleAndMortarRecipe recipe : recipes) {
            if (!recipe.matches(input)) continue;
            return recipe.getOutput();
        }
        return null;
    }

    public static ItemStack getInput(ItemStack output) {
        for (PestleAndMortarRecipe recipe : recipes) {
            if (!recipe.matchesOutput(output)) continue;
            return recipe.getInputs();
        }
        return null;
    }

    public static List<PestleAndMortarRecipe> getRecipeList() {
        return Collections.unmodifiableList(recipes);
    }

    private PestleAndMortarRecipe(ItemStack output, ItemStack input) {
        this.output = ItemStack.func_77944_b((ItemStack)output);
        this.input = ItemStack.func_77944_b((ItemStack)input);
        if (!(input instanceof ItemStack)) {
            throw new IllegalArgumentException("Input must be an ItemStack");
        }
        input = ItemStack.func_77944_b((ItemStack)input);
    }

    public ItemStack getInputs() {
        return ItemStack.func_77944_b((ItemStack)this.input);
    }

    public ItemStack getOutput() {
        return ItemStack.func_77944_b((ItemStack)this.output);
    }

    public boolean matches(ItemStack stacks) {
        if (stacks != null && this.areStacksTheSame(this.getInputs(), stacks)) {
            stacks = null;
            return true;
        }
        return false;
    }

    public boolean matchesOutput(ItemStack stacks) {
        if (stacks != null && this.areStacksTheSame(this.getOutput(), stacks)) {
            stacks = null;
            return true;
        }
        return false;
    }

    private boolean areStacksTheSame(ItemStack stack, ItemStack target) {
        return PestleAndMortarRecipe.areStacksTheSame(stack, target, false);
    }

    public static boolean areStacksTheSame(ItemStack stack1, ItemStack stack2, boolean matchSize) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!(stack1.func_77973_b() != stack2.func_77973_b() || stack1.func_77960_j() != stack2.func_77960_j() || matchSize && stack1.field_77994_a != stack2.field_77994_a)) {
            if (stack1.func_77942_o() && stack2.func_77942_o()) {
                return stack1.func_77978_p().equals((Object)stack2.func_77978_p());
            }
            return stack1.func_77942_o() == stack2.func_77942_o();
        }
        return false;
    }
}

