/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.recipes.misc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thebetweenlands.tileentities.TileEntityAnimator;

public class AnimatorRecipe {
    public final ItemStack input;
    public final int requiredFuel;
    public final int requiredLife;
    private ItemStack result = null;
    private Class<? extends Entity> spawnEntity = null;
    private String renderEntity = null;
    private Entity renderEntityInstance = null;
    private boolean closeOnFinish = false;
    private static final List<AnimatorRecipe> RECIPES = new ArrayList<AnimatorRecipe>();

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife) {
        this.input = input;
        this.requiredFuel = requiredFuel;
        this.requiredLife = requiredLife;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, ItemStack result) {
        this(input, requiredFuel, requiredLife);
        this.result = result;
    }

    public AnimatorRecipe(ItemStack input, int requiredFuel, int requiredLife, Class<? extends Entity> result) {
        this(input, requiredFuel, requiredLife);
        this.spawnEntity = result;
        this.closeOnFinish = true;
    }

    public AnimatorRecipe setRenderEntity(String entity) {
        this.renderEntity = entity;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getRenderEntity() {
        if (this.renderEntity != null && this.renderEntity.length() > 0) {
            if (this.renderEntityInstance == null) {
                Entity entity;
                this.renderEntityInstance = entity = EntityList.func_75620_a((String)this.renderEntity, (World)null);
            }
            return this.renderEntityInstance;
        }
        return null;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public Class<? extends Entity> getSpawnEntityClass() {
        return this.spawnEntity;
    }

    public ItemStack onAnimated(World world, int x, int y, int z) {
        return null;
    }

    public boolean onRetrieved(TileEntityAnimator tile, World world, int x, int y, int z) {
        Class<? extends Entity> spawnEntity = this.getSpawnEntityClass();
        if (spawnEntity != null) {
            Entity entity = null;
            try {
                entity = spawnEntity.getConstructor(World.class).newInstance(world);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
            entity.func_70012_b((double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 0.0f, 0.0f);
            world.func_72838_d(entity);
            tile.func_70299_a(0, null);
            return false;
        }
        return true;
    }

    public boolean getCloseOnFinish() {
        return this.closeOnFinish;
    }

    public AnimatorRecipe setCloseOnFinish(boolean close) {
        this.closeOnFinish = close;
        return this;
    }

    public static void addRecipe(AnimatorRecipe recipe) {
        RECIPES.add(recipe);
    }

    public static List<AnimatorRecipe> getRecipes() {
        return RECIPES;
    }

    public static AnimatorRecipe getRecipe(ItemStack input) {
        for (AnimatorRecipe recipe : AnimatorRecipe.getRecipes()) {
            if (input == null || !input.func_77969_a(recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static AnimatorRecipe getRecipeFromOutput(ItemStack output) {
        for (AnimatorRecipe recipe : AnimatorRecipe.getRecipes()) {
            if (recipe.result == null || !output.func_77969_a(recipe.result)) continue;
            return recipe;
        }
        return null;
    }
}

