/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.network.message;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.network.message.base.AbstractMessage;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public class MessageSyncEnvironmentEvent
extends AbstractMessage<MessageSyncEnvironmentEvent> {
    private EnvironmentEvent event;
    private String eventName;
    private boolean active;

    public MessageSyncEnvironmentEvent() {
    }

    public MessageSyncEnvironmentEvent(EnvironmentEvent eevent) {
        this.event = eevent;
        this.eventName = eevent.getEventName();
        this.active = eevent.isActive();
    }

    public void fromBytes(ByteBuf buffer) {
        int strLen = buffer.readInt();
        byte[] strBytes = new byte[strLen];
        buffer.readBytes(strBytes);
        try {
            WorldProviderBetweenlands provider;
            EnvironmentEventRegistry eeRegistry;
            EnvironmentEvent eevent;
            String eventName;
            this.eventName = eventName = new String(strBytes, "UTF-8");
            this.active = buffer.readBoolean();
            World world = TheBetweenlands.proxy.getClientWorld();
            if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands && (eevent = (eeRegistry = (provider = (WorldProviderBetweenlands)world.field_73011_w).getWorldData().getEnvironmentEventRegistry()).forName(this.eventName)) != null) {
                eevent.loadEventPacket(buffer);
            }
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Failed to sync environment event");
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buffer) {
        byte[] strBytes = this.eventName.getBytes(Charset.forName("UTF-8"));
        buffer.writeInt(strBytes.length);
        buffer.writeBytes(strBytes);
        buffer.writeBoolean(this.active);
        this.event.sendEventPacket(buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessageClientSide(MessageSyncEnvironmentEvent message, EntityPlayer player) {
        WorldProviderBetweenlands provider;
        EnvironmentEventRegistry eeRegistry;
        EnvironmentEvent eevent;
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof WorldProviderBetweenlands && (eevent = (eeRegistry = (provider = (WorldProviderBetweenlands)world.field_73011_w).getWorldData().getEnvironmentEventRegistry()).forName(message.eventName)) != null) {
            eevent.setActive(message.active, false);
            if (world.field_72995_K) {
                eevent.setLoaded();
            }
        }
    }

    @Override
    public void onMessageServerSide(MessageSyncEnvironmentEvent message, EntityPlayer player) {
    }
}

