/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.network.handlers;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.audio.EntityIdleSound;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.packet.client.PacketPlayIdleSound;
import thebetweenlands.network.packet.server.PacketAttackTarget;
import thebetweenlands.network.packet.server.PacketDruidAltarProgress;
import thebetweenlands.network.packet.server.PacketDruidTeleportParticle;
import thebetweenlands.network.packet.server.PacketRevengeTarget;
import thebetweenlands.network.packet.server.PacketSnailHatchParticle;
import thebetweenlands.network.packet.server.PacketTickspeed;
import thebetweenlands.network.packet.server.PacketWeedWoodBushRustle;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.tileentities.TileEntityDruidAltar;

public class ClientPacketHandler {
    private static final ResourceLocation soundLocation = new ResourceLocation("thebetweenlands:druidChant");
    private static final HashMap<String, PositionedSoundDC> tileSoundMap = Maps.newHashMap();

    @SubscribePacket
    public static void handlePacketPlayIdleSound(PacketPlayIdleSound packet) {
        Entity source;
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world != null && world.field_72995_K && (source = packet.getEntity((World)world)) != null && Minecraft.func_71410_x().func_147118_V() != null && source.func_70089_S()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityIdleSound(source, new ResourceLocation(packet.name), packet.volume, packet.pitch));
        }
    }

    @SubscribePacket
    public static void handleDruidTeleportParticles(PacketDruidTeleportParticle packet) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world != null && world.field_72995_K) {
            for (int a = 0; a < 360; a += 4) {
                double ang = (double)a * Math.PI / 180.0;
                BLParticle.SMOKE.spawn((World)world, packet.x - (double)MathHelper.func_76126_a((float)((float)ang)) * 0.25, packet.y, packet.z + (double)MathHelper.func_76134_b((float)((float)ang)) * 0.25, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.1, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.1, 0.0f, new Object[0]);
                BLParticle.SMOKE.spawn((World)world, packet.x - (double)MathHelper.func_76126_a((float)((float)ang)) * 0.25, packet.y + 0.5, packet.z + (double)MathHelper.func_76134_b((float)((float)ang)) * 0.25, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.1, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.1, 0.0f, new Object[0]);
                BLParticle.SMOKE.spawn((World)world, packet.x - (double)MathHelper.func_76126_a((float)((float)ang)) * 0.25, packet.y + 1.0, packet.z + (double)MathHelper.func_76134_b((float)((float)ang)) * 0.25, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.1, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.1, 0.0f, new Object[0]);
            }
        }
    }

    @SubscribePacket
    public static void handleDruidAltar(PacketDruidAltarProgress packet) {
        TileEntity te;
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world != null && world.field_72995_K && (te = world.func_147438_o(packet.x, packet.y, packet.z)) instanceof TileEntityDruidAltar) {
            TileEntityDruidAltar teda = (TileEntityDruidAltar)te;
            if (packet.progress < 0) {
                PositionedSoundDC sound;
                SoundHandler mcSoundHandler = Minecraft.func_71410_x().func_147118_V();
                if (packet.progress == -1) {
                    PositionedSoundDC sound2 = tileSoundMap.get(teda.field_145851_c + "|" + teda.field_145848_d + "|" + teda.field_145849_e);
                    if (sound2 == null) {
                        sound2 = new PositionedSoundDC(soundLocation).setPos(packet.x, packet.y, packet.z);
                        tileSoundMap.put(packet.x + "|" + packet.y + "|" + packet.z, sound2);
                    } else if (mcSoundHandler.func_147692_c((ISound)sound2)) {
                        mcSoundHandler.func_147683_b((ISound)sound2);
                    }
                    mcSoundHandler.func_147682_a((ISound)sound2);
                    for (int x = -8; x < 8; ++x) {
                        for (int y = -8; y < 8; ++y) {
                            for (int z = -8; z < 8; ++z) {
                                Block block = world.func_147439_a(teda.field_145851_c + x, teda.field_145848_d + y, teda.field_145849_e + z);
                                if (block != BLBlockRegistry.druidStone1 && block != BLBlockRegistry.druidStone2 && block != BLBlockRegistry.druidStone3 && block != BLBlockRegistry.druidStone4 && block != BLBlockRegistry.druidStone5) continue;
                                BLParticle.ALTAR_CRAFTING.spawn((World)world, te.field_145851_c + x, te.field_145848_d + y, te.field_145849_e + z, 0.0, 0.0, 0.0, 1.0f, new Object[]{teda});
                            }
                        }
                    }
                } else if (packet.progress == -2 && (sound = tileSoundMap.get(packet.x + "|" + packet.y + "|" + packet.z)) != null && mcSoundHandler.func_147692_c((ISound)sound)) {
                    mcSoundHandler.func_147683_b((ISound)sound);
                }
            }
        }
    }

    public static void handleSnailHatchParticle(PacketSnailHatchParticle packet) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        EffectRenderer eff = Minecraft.func_71410_x().field_71452_i;
        if (world != null && world.field_72995_K) {
            for (int count = 0; count <= 50; ++count) {
                eff.func_78873_a((EntityFX)new EntityBreakingFX((World)world, packet.x + (world.field_73012_v.nextDouble() - 0.5) * (double)0.35f, packet.y + world.field_73012_v.nextDouble() * (double)0.175f, packet.z + (world.field_73012_v.nextDouble() - 0.5) * (double)0.35f, Items.field_151123_aH));
            }
        }
    }

    @SubscribePacket
    public static void handleTickspeed(PacketTickspeed packet) {
        ClientProxy.debugTimer.setTicksPerSecond(packet.getTicksPerSecond());
    }

    @SubscribePacket
    public static void handleSetAttackTarget(PacketRevengeTarget packet) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        Entity entity = world.func_73045_a(packet.getAId());
        if (entity instanceof EntityLivingBase) {
            Entity target;
            EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
            Entity entity2 = target = packet.getBId() == -1 ? null : world.func_73045_a(packet.getBId());
            if (target == null) {
                entityLivingBase.func_70604_c(null);
            } else if (target instanceof EntityLivingBase) {
                entityLivingBase.func_70604_c((EntityLivingBase)target);
            }
        }
    }

    @SubscribePacket
    public static void handleSetAttackTarget(PacketAttackTarget packet) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        Entity entity = world.func_73045_a(packet.getAId());
        if (entity instanceof EntityLiving) {
            Entity target;
            EntityLiving entityLiving = (EntityLiving)entity;
            Entity entity2 = target = packet.getBId() == -1 ? null : world.func_73045_a(packet.getBId());
            if (target == null) {
                entityLiving.func_70624_b(null);
            } else if (target instanceof EntityLivingBase) {
                entityLiving.func_70624_b((EntityLivingBase)target);
            }
        }
    }

    @SubscribePacket
    public static void handleWeedWoodBushRustle(PacketWeedWoodBushRustle packet) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        int leafCount = (int)(47.0f * packet.getStrength()) + 1;
        float x = (float)packet.getX() + 0.5f;
        float y = (float)packet.getY() + 0.5f;
        float z = (float)packet.getZ() + 0.5f;
        while (leafCount-- > 0) {
            BLParticle.RUSTLE_LEAF.spawn((World)world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class PositionedSoundDC
    extends PositionedSound {
        protected PositionedSoundDC(ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        public PositionedSoundDC setPos(float x, float y, float z) {
            this.field_147660_d = x;
            this.field_147661_e = y;
            this.field_147658_f = z;
            return this;
        }
    }
}

