/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.network.base.impl;

import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thebetweenlands.network.base.IPacket;
import thebetweenlands.network.base.IPacketProxy;
import thebetweenlands.network.base.ListenerEntry;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.base.impl.ClientPacketProxy;

public class CommonPacketProxy
implements IPacketProxy {
    protected Map<Class<? extends IPacket>, List<ListenerEntry>> commonListeners = Collections.synchronizedMap(new HashMap());

    @Override
    public Map<Class<? extends IPacket>, List<ListenerEntry>> getListeners() {
        return this.commonListeners;
    }

    @Override
    public final void registerPacketHandler(String className, Side side) throws Exception {
        if (this instanceof ClientPacketProxy || side == Side.SERVER && !(this instanceof ClientPacketProxy)) {
            Class<?> clazz = Class.forName(className);
            this.registerPacketHandler(clazz);
        }
    }

    protected final void registerPacketHandler(Class clazz) throws Exception {
        List<ListenerEntry> foundEntries = CommonPacketProxy.getListenerEntries(clazz);
        if (foundEntries.size() > 0) {
            for (ListenerEntry foundEntry : foundEntries) {
                Class pktType = foundEntry.getParamType();
                List<ListenerEntry> listenerEntries = this.getListeners().get(pktType);
                if (listenerEntries == null) {
                    listenerEntries = new ArrayList<ListenerEntry>();
                    this.getListeners().put(pktType, listenerEntries);
                }
                listenerEntries.add(foundEntry);
            }
        }
    }

    private static final List<ListenerEntry> getListenerEntries(Class clazz) throws Exception {
        ArrayList<ListenerEntry> listenerEntries = new ArrayList<ListenerEntry>();
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?> messageType;
            SubscribePacket annotation = method.getAnnotation(SubscribePacket.class);
            if (annotation == null) continue;
            int methodModifiers = method.getModifiers();
            if ((methodModifiers & 8) == 0 || (methodModifiers & 0x400) != 0 || (methodModifiers & 2) != 0 || (methodModifiers & 4) != 0) {
                throw new Exception("Invalid method modifiers for method! Class: " + clazz.getName() + " Method: " + method.getName());
            }
            boolean validParams = false;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1 && IPacket.class.isAssignableFrom(messageType = params[0])) {
                listenerEntries.add(new ListenerEntry(method, clazz, messageType));
                validParams = true;
            }
            if (validParams) continue;
            throw new Exception("Invalid packet listener parameters! Class: " + clazz.getName() + " Method: " + method.getName());
        }
        return listenerEntries;
    }
}

