/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets.text;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.manual.widgets.ManualWidgetsBase;
import thebetweenlands.manual.widgets.text.FormatTags;
import thebetweenlands.manual.widgets.text.TextContainer;

@SideOnly(value=Side.CLIENT)
public class TextWidget
extends ManualWidgetsBase {
    private TextContainer textContainer;
    private String text;
    private float scale = 1.0f;
    private int width;
    private int height;
    private int pageNumber = 0;

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, StatCollector.func_74838_a((String)unlocalizedText), Minecraft.func_71410_x().field_71466_p);
        this.text = StatCollector.func_74838_a((String)unlocalizedText);
        if (!StatCollector.func_94522_b((String)unlocalizedText) || this.text.equals("")) {
            TheBetweenlands.unlocalizedNames.add(unlocalizedText);
        }
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText, int pageNumber) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, StatCollector.func_74838_a((String)unlocalizedText), Minecraft.func_71410_x().field_71466_p);
        this.text = StatCollector.func_74838_a((String)unlocalizedText);
        if (!StatCollector.func_94522_b((String)unlocalizedText) || this.text.equals("")) {
            TheBetweenlands.unlocalizedNames.add(unlocalizedText);
        }
        this.init();
        this.pageNumber = pageNumber;
    }

    public TextWidget(int xStart, int yStart, String unlocalizedText, int pageNumber, int width, int height) {
        super(xStart, yStart);
        this.width = width;
        this.height = height;
        this.textContainer = new TextContainer(width, height, StatCollector.func_74838_a((String)unlocalizedText), Minecraft.func_71410_x().field_71466_p);
        this.text = StatCollector.func_74838_a((String)unlocalizedText);
        if (!StatCollector.func_94522_b((String)unlocalizedText) || this.text.equals("")) {
            TheBetweenlands.unlocalizedNames.add(unlocalizedText);
        }
        this.init();
        this.pageNumber = pageNumber;
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String unlocalizedText, float scale) {
        super(xStart, yStart);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, StatCollector.func_74838_a((String)unlocalizedText), Minecraft.func_71410_x().field_71466_p);
        this.text = StatCollector.func_74838_a((String)unlocalizedText);
        if (!StatCollector.func_94522_b((String)unlocalizedText) || this.text.equals("")) {
            TheBetweenlands.unlocalizedNames.add(unlocalizedText);
        }
        this.scale = scale;
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public TextWidget(int xStart, int yStart, String text, boolean isLocalized) {
        super(xStart, yStart);
        this.text = isLocalized ? text : StatCollector.func_74838_a((String)text);
        this.width = 130 - xStart;
        this.height = 144;
        this.textContainer = new TextContainer(this.width, this.height, text, Minecraft.func_71410_x().field_71466_p);
        if (!(isLocalized || StatCollector.func_94522_b((String)text) && !text.equals(""))) {
            TheBetweenlands.unlocalizedNames.add(text);
        }
        this.init();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setPageToRight() {
        super.setPageToRight();
        this.textContainer = new TextContainer(this.width, this.height, this.text, Minecraft.func_71410_x().field_71466_p);
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public void init() {
        this.textContainer.setCurrentScale(this.scale).setCurrentColor(0x808080);
        this.textContainer.registerTag(new FormatTags.TagNewLine());
        this.textContainer.registerTag(new FormatTags.TagNewPage());
        this.textContainer.registerTag(new FormatTags.TagScale(1.0f));
        this.textContainer.registerTag(new FormatTags.TagColor(0x808080));
        this.textContainer.registerTag(new FormatTags.TagTooltip("N/A"));
        this.textContainer.registerTag(new FormatTags.TagSimple("bold", EnumChatFormatting.BOLD));
        this.textContainer.registerTag(new FormatTags.TagSimple("obfuscated", EnumChatFormatting.OBFUSCATED));
        this.textContainer.registerTag(new FormatTags.TagSimple("italic", EnumChatFormatting.ITALIC));
        this.textContainer.registerTag(new FormatTags.TagSimple("strikethrough", EnumChatFormatting.STRIKETHROUGH));
        this.textContainer.registerTag(new FormatTags.TagSimple("underline", EnumChatFormatting.UNDERLINE));
        this.textContainer.registerTag(new FormatTags.TagPagelink());
        this.textContainer.registerTag(new FormatTags.TagRainbow());
        this.textContainer.registerTag(new FormatTags.TagFont());
        try {
            this.textContainer.parse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        TextContainer.TextPage page = this.textContainer.getPages().get(this.pageNumber);
        page.render(this.xStart, this.yStart);
        page.renderTooltips(this.xStart, this.yStart, this.mouseX, this.mouseY);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void resize() {
        super.resize();
        this.textContainer = new TextContainer(this.width, this.height, this.text, Minecraft.func_71410_x().field_71466_p);
        this.init();
    }

    public TextWidget setWidth(int width) {
        this.width = width;
        return this;
    }
}

