/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class TextContainer {
    private final double pageWidth;
    private final double pageHeight;
    private final String unparsedText;
    private final Map<String, Tag> textTagComponents = new HashMap<String, Tag>();
    private final List<TextPage> pages = new ArrayList<TextPage>();
    private final FontRenderer defaultFont;
    private final List<EnumChatFormatting> textFormatList = new ArrayList<EnumChatFormatting>();
    private final List<TextArea> textAreas = new ArrayList<TextArea>();
    private float currentScale = 1.0f;
    private int currentColor = 0;
    private int newLine = 0;
    private int newPage = 0;
    private FontRenderer currentFont;

    public TextContainer(double pageWidth, double pageHeight, String text, FontRenderer defaultFont) {
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.unparsedText = text;
        this.defaultFont = defaultFont;
        this.currentFont = defaultFont;
    }

    public double getWidth() {
        return this.pageWidth;
    }

    public double getHeight() {
        return this.pageHeight;
    }

    public List<TextPage> getPages() {
        return this.pages;
    }

    public FontRenderer getDefaultFont() {
        return this.defaultFont;
    }

    public void registerTag(Tag tag) {
        this.textTagComponents.put(tag.type, tag);
    }

    public void newLine() {
        ++this.newLine;
    }

    public void newPage() {
        ++this.newPage;
    }

    public void parse() {
        StringBuilder strippedTextBuilder = new StringBuilder();
        StringBuilder tagTextBuilder = null;
        ArrayList<ParsedTag> tagList = new ArrayList<ParsedTag>();
        char[] textCharArray = (this.unparsedText + " P").toCharArray();
        char prevChar = '\u0000';
        char prevChar2 = '\u0000';
        boolean inTag = false;
        int strippedTextIndex = 0;
        int escapeChar = 92;
        for (int i = 0; i < textCharArray.length; ++i) {
            char currentChar = textCharArray[i];
            char nextChar = i < textCharArray.length - 1 ? textCharArray[i + 1] : (char)'\u0000';
            char nextChar2 = i < textCharArray.length - 2 ? textCharArray[i + 2] : (char)'\u0000';
            boolean addChar = true;
            boolean escapable = this.isEscapable(currentChar);
            boolean escaped = prevChar == '\\' && prevChar2 != prevChar;
            prevChar2 = prevChar;
            prevChar = currentChar;
            if (currentChar == '\\' && nextChar == '\\' && this.isEscapable(nextChar2)) {
                addChar = false;
            }
            if (escapable && !escaped) {
                if (currentChar == '<') {
                    if (inTag) {
                        throw new RuntimeException("Already in tag");
                    }
                    inTag = true;
                    addChar = false;
                    tagTextBuilder = new StringBuilder();
                } else if (currentChar == '>') {
                    if (!inTag) {
                        throw new RuntimeException("Not in tag");
                    }
                    inTag = false;
                    addChar = false;
                    String tagText = tagTextBuilder.toString();
                    boolean close = false;
                    if (tagText.startsWith("/")) {
                        close = true;
                        tagText = tagText.substring(1, tagText.length());
                    }
                    tagList.add(new ParsedTag(tagText, close, strippedTextIndex));
                }
            } else if (escapable && escaped && strippedTextIndex > 0) {
                strippedTextBuilder.delete(strippedTextIndex - 1, strippedTextIndex);
                --strippedTextIndex;
            }
            if (!addChar) continue;
            if (!inTag) {
                strippedTextBuilder.append(currentChar);
                ++strippedTextIndex;
                continue;
            }
            tagTextBuilder.append(currentChar);
        }
        if (inTag) {
            throw new RuntimeException("Unclosed tag");
        }
        String strippedText = strippedTextBuilder.toString();
        ArrayList[] tagsArray = new ArrayList[strippedText.length() + 1];
        for (ParsedTag tag : tagList) {
            if (tagsArray[tag.index] == null) {
                tagsArray[tag.index] = new ArrayList();
            }
            tagsArray[tag.index].add(tag);
        }
        char[] strippedTextCharArray = strippedText.toCharArray();
        ArrayList<ParsedSegment> parsedSegments = new ArrayList<ParsedSegment>();
        StringBuilder segmentTextBuilder = new StringBuilder();
        boolean wasSpacing = false;
        ArrayList prevTags = new ArrayList();
        for (int i = 0; i < strippedTextCharArray.length; ++i) {
            ParsedSegment seg;
            String prevSegmentText;
            char currentChar = strippedTextCharArray[i];
            ArrayList tags = tagsArray[i];
            boolean hasTags = tags != null && !tags.isEmpty();
            boolean isSpacing = this.isSpacing(currentChar);
            if (!hasTags) {
                if (isSpacing) {
                    if (!wasSpacing) {
                        prevSegmentText = segmentTextBuilder.toString();
                        segmentTextBuilder = new StringBuilder();
                        seg = new ParsedSegment(prevSegmentText, true);
                        seg.tags.addAll(prevTags);
                        prevTags.clear();
                        parsedSegments.add(seg);
                    }
                } else if (wasSpacing) {
                    String prevSpacingText = segmentTextBuilder.toString();
                    segmentTextBuilder = new StringBuilder();
                    seg = new ParsedSegment(prevSpacingText, false);
                    seg.tags.addAll(prevTags);
                    prevTags.clear();
                    parsedSegments.add(seg);
                }
            } else {
                prevSegmentText = segmentTextBuilder.toString();
                segmentTextBuilder = new StringBuilder();
                seg = new ParsedSegment(prevSegmentText, !wasSpacing);
                seg.tags.addAll(prevTags);
                prevTags.clear();
                prevTags.addAll(tags);
                parsedSegments.add(seg);
            }
            wasSpacing = isSpacing;
            if (i != strippedTextCharArray.length - 2) {
                segmentTextBuilder.append(currentChar);
            }
            if (i != strippedTextCharArray.length - 2) continue;
            parsedSegments.add(new ParsedSegment(segmentTextBuilder.toString(), !isSpacing));
        }
        ArrayList<WrapSegment> wrapSegments = new ArrayList<WrapSegment>();
        ArrayList<ParsedSegment> segmentGroup = new ArrayList<ParsedSegment>();
        boolean significant = false;
        for (ParsedSegment seg : parsedSegments) {
            if (wrapSegments.isEmpty() && segmentGroup.isEmpty()) {
                significant = seg.significant;
            }
            if (significant == seg.significant) {
                segmentGroup.add(seg);
                continue;
            }
            WrapSegment wrapSegment = new WrapSegment(significant);
            wrapSegment.segments.addAll(segmentGroup);
            wrapSegments.add(wrapSegment);
            segmentGroup.clear();
            segmentGroup.add(seg);
            significant = seg.significant;
        }
        if (!segmentGroup.isEmpty()) {
            WrapSegment wrapSegment = new WrapSegment(significant);
            wrapSegment.segments.addAll(segmentGroup);
            wrapSegments.add(wrapSegment);
            segmentGroup.clear();
        }
        this.pages.clear();
        this.pages.addAll(this.build(wrapSegments));
    }

    private List<TextPage> build(List<WrapSegment> wrapSegments) {
        String currentTagType = null;
        ParsedSegment currentSegment = null;
        try {
            HashMap<String, Stack<RangedTag>> textTagComponentStacks = new HashMap<String, Stack<RangedTag>>();
            for (Map.Entry<String, Tag> e : this.textTagComponents.entrySet()) {
                Tag tag = e.getValue();
                if (!(tag instanceof RangedTag)) continue;
                this.getTagStack(tag.type, textTagComponentStacks).push((RangedTag)tag);
            }
            ArrayList textSegments = new ArrayList();
            ArrayList<TextPage> pages = new ArrayList<TextPage>();
            TextPage currentPage = new TextPage(this.pageWidth, this.pageHeight);
            pages.add(currentPage);
            double cursorX = 0.0;
            double cursorY = 0.0;
            double lineHeight = 0.0;
            WrapSegment prevWrapSegment = null;
            ArrayList prevWrapTextSegments = new ArrayList();
            boolean newLine = false;
            for (int w = 0; w < wrapSegments.size() - 1; ++w) {
                WrapSegment wrapSegment = wrapSegments.get(w);
                double wrapSegmentWidth = 0.0;
                double wrapSegmentHeight = 0.0;
                ArrayList<TextSegment> wrapTextSegments = new ArrayList<TextSegment>();
                Iterator<ParsedSegment> iterator = wrapSegment.segments.iterator();
                while (iterator.hasNext()) {
                    boolean nextPage;
                    boolean nextLine;
                    Object newTag;
                    ParsedSegment segment;
                    currentSegment = segment = iterator.next();
                    List<ParsedTag> tags = segment.tags;
                    ArrayList textAreas = new ArrayList();
                    ArrayList<Object> usedTags = new ArrayList<Object>();
                    if (!tags.isEmpty()) {
                        for (ParsedTag tag : tags) {
                            String tagText = tag.text;
                            String tagType = null;
                            String tagArguments = null;
                            if (tagText.contains(":")) {
                                String[] tagData = tagText.split(":");
                                tagType = tagData[0];
                                tagArguments = tagData[1];
                            } else {
                                tagType = tagText;
                            }
                            currentTagType = tagType;
                            usedTags.add(tagType);
                            Tag textTag = this.textTagComponents.get(tagType);
                            if (textTag == null) {
                                throw new RuntimeException("Unknown tag: " + (String)tagType);
                            }
                            Stack<RangedTag> tagStack = this.getTagStack(tagType, textTagComponentStacks);
                            if (tag.close) {
                                tagStack.pop().pop(this, tagStack.peek());
                                continue;
                            }
                            if (!((Tag)newTag).push(this, (newTag = textTag.create()) instanceof RangedTag ? tagStack.peek() : null, tagArguments, null, 0) || !(newTag instanceof RangedTag)) continue;
                            tagStack.push((RangedTag)newTag);
                        }
                    }
                    String prefixed = "";
                    if (this.textFormatList.size() > 0) {
                        this.sortFormatList(this.textFormatList);
                        StringBuilder formatStringBuilder = new StringBuilder();
                        for (EnumChatFormatting format : this.textFormatList) {
                            formatStringBuilder.append(format.toString());
                        }
                        prefixed = formatStringBuilder.toString();
                    }
                    String word = prefixed + segment.text;
                    double strWidth = (float)this.currentFont.func_78256_a(word) * this.currentScale;
                    double strHeight = (float)this.currentFont.field_78288_b * this.currentScale;
                    boolean bl = nextLine = cursorX + strWidth > this.pageWidth;
                    if (segment.significant) {
                        newLine = false;
                    }
                    if (nextLine || this.newLine > 0) {
                        cursorX = 0.0;
                        cursorY += lineHeight * (double)(this.newLine + (nextLine ? 1 : 0));
                        lineHeight = 0.0;
                        newLine = true;
                        if (prevWrapSegment != null && nextLine && this.newLine == 0) {
                            newTag = prevWrapTextSegments.iterator();
                            while (newTag.hasNext()) {
                                TextSegment wrapTextSegment = (TextSegment)newTag.next();
                                wrapTextSegment.page.textSegments.remove(wrapTextSegment);
                            }
                        }
                    }
                    if (segment.text.length() > 0 && strHeight > lineHeight) {
                        lineHeight = strHeight;
                    }
                    boolean bl2 = nextPage = cursorY + strHeight > this.pageHeight;
                    if (nextPage || this.newPage > 0) {
                        currentPage.textAreas.addAll(this.textAreas);
                        this.textAreas.clear();
                        for (int i = 0; i < this.newPage + (nextPage ? 1 : 0); ++i) {
                            currentPage = new TextPage(this.pageWidth, this.pageHeight);
                            pages.add(currentPage);
                        }
                        this.newPage = 0;
                        lineHeight = 0.0;
                        newLine = false;
                        cursorX = 0.0;
                        cursorY = 0.0;
                    }
                    TextArea area = new TextArea(currentPage, cursorX, cursorY, strWidth, strHeight);
                    if (!tags.isEmpty()) {
                        for (ParsedTag tag : tags) {
                            Tag newTag2;
                            String tagText = tag.text;
                            String tagType = null;
                            String tagArguments = null;
                            if (tagText.contains(":")) {
                                String[] tagData = tagText.split(":");
                                tagType = tagData[0];
                                tagArguments = tagData[1];
                            } else {
                                tagType = tagText;
                            }
                            currentTagType = tagType;
                            Tag textTag = this.textTagComponents.get(tagType);
                            if (textTag == null) {
                                throw new RuntimeException("Unknown tag: " + tagType);
                            }
                            Stack<RangedTag> tagStack = this.getTagStack(tagType, textTagComponentStacks);
                            if (tag.close || !newTag2.push(this, (newTag2 = textTag.create()) instanceof RangedTag ? tagStack.peek() : null, tagArguments, area, 1) || !(newTag2 instanceof RangedTag)) continue;
                            tagStack.push((RangedTag)newTag2);
                        }
                    }
                    for (Stack activeTagStack : textTagComponentStacks.values()) {
                        if (activeTagStack.size() <= 1) continue;
                        for (int c = 1; c < activeTagStack.size(); ++c) {
                            RangedTag tag = (RangedTag)activeTagStack.get(c);
                            if (usedTags.contains(tag.type)) continue;
                            tag.expand(this, area);
                        }
                    }
                    if (!newLine || segment.significant || this.newLine > 0) {
                        TextSegment textSegment = new TextSegment(area.page, word, cursorX, cursorY, strWidth, strHeight, this.currentColor, this.currentScale, this.currentFont);
                        if (word.length() > 0) {
                            currentPage.textSegments.add(textSegment);
                            currentPage.textAreas.addAll(this.textAreas);
                        }
                        if (!segment.significant) {
                            wrapTextSegments.add(textSegment);
                        }
                        this.textAreas.clear();
                        cursorX += strWidth;
                    } else if (newLine && !segment.significant || this.newLine == 0) {
                        for (TextSegment wrapTextSegment : wrapTextSegments) {
                            wrapTextSegment.page.textSegments.remove(wrapTextSegment);
                        }
                    }
                    if (segment.significant) {
                        newLine = false;
                    }
                    this.newLine = 0;
                }
                prevWrapSegment = wrapSegment;
                prevWrapTextSegments.clear();
                prevWrapTextSegments.addAll(wrapTextSegments);
            }
            return pages;
        }
        catch (Exception ex) {
            if (ex instanceof EmptyStackException) {
                throw new RuntimeException("Stack underflow. Stack type: " + currentTagType + " Word: " + currentSegment.text, ex);
            }
            throw ex;
        }
    }

    public TextContainer setCurrentFont(FontRenderer font) {
        this.currentFont = font == null ? this.defaultFont : font;
        return this;
    }

    public TextContainer setCurrentScale(float scale) {
        this.currentScale = scale;
        return this;
    }

    public TextContainer addFormatting(EnumChatFormatting format) {
        this.textFormatList.add(format);
        return this;
    }

    public TextContainer removeFormatting(EnumChatFormatting format) {
        this.textFormatList.remove(format);
        return this;
    }

    public TextContainer setCurrentColor(int color) {
        this.currentColor = color;
        return this;
    }

    public TextContainer addTextArea(TextArea area) {
        this.textAreas.add(area);
        return this;
    }

    public TextContainer removeTextArea(TextArea area) {
        for (TextPage page : this.pages) {
            Iterator taIT = page.textAreas.iterator();
            while (taIT.hasNext()) {
                TextArea ta = (TextArea)taIT.next();
                if (!ta.equals(area)) continue;
                taIT.remove();
            }
        }
        return this;
    }

    private Stack<RangedTag> getTagStack(String component, Map<String, Stack<RangedTag>> stackMap) {
        Stack<RangedTag> stack = stackMap.get(component);
        if (stack == null) {
            stack = new Stack();
            stackMap.put(component, stack);
        }
        return stack;
    }

    private void sortFormatList(List<EnumChatFormatting> list) {
        Comparator<EnumChatFormatting> formatComparator = new Comparator<EnumChatFormatting>(){

            @Override
            public int compare(EnumChatFormatting f1, EnumChatFormatting f2) {
                if (f1.func_96302_c() && f2.func_96302_c()) {
                    return 0;
                }
                if (f1.func_96302_c()) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(list, formatComparator);
    }

    private boolean isSpacing(char c) {
        return c == ' ';
    }

    private boolean isEscapable(char c) {
        return c == '<' || c == '>';
    }

    private class WrapSegment {
        final boolean significant;
        final List<ParsedSegment> segments = new ArrayList<ParsedSegment>();

        private WrapSegment(boolean significant) {
            this.significant = significant;
        }
    }

    private class ParsedSegment {
        final String text;
        final boolean significant;
        final List<ParsedTag> tags = new ArrayList<ParsedTag>();

        private ParsedSegment(String text, boolean significant) {
            this.text = text;
            this.significant = significant;
        }
    }

    private class ParsedTag {
        final String text;
        final boolean close;
        final int index;

        private ParsedTag(String text, boolean close, int index) {
            this.text = text;
            this.close = close;
            this.index = index;
        }
    }

    public static class TooltipArea
    extends TextArea {
        public final String text;

        public TooltipArea(TextArea area, String text) {
            super(area);
            this.text = text;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof TooltipArea) {
                TooltipArea area = (TooltipArea)object;
                return super.equals(area) && area.text.equals(this.text);
            }
            return false;
        }
    }

    public static class TextPage {
        private final List<TextSegment> textSegments = new ArrayList<TextSegment>();
        private final List<TextArea> textAreas = new ArrayList<TextArea>();
        public final double width;
        public final double height;

        private TextPage(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public double getTextWidth() {
            double furthest = 0.0;
            for (TextSegment segment : this.textSegments) {
                if (!(segment.x + segment.width > furthest)) continue;
                furthest = segment.x + segment.width;
            }
            return furthest;
        }

        public double getTextHeight() {
            double furthest = 0.0;
            for (TextSegment segment : this.textSegments) {
                if (!(segment.y + segment.height > furthest)) continue;
                furthest = segment.y + segment.height;
            }
            return furthest;
        }

        public List<TextSegment> getSegments() {
            return this.textSegments;
        }

        public List<TextArea> getTextAreas() {
            return this.textAreas;
        }

        public <T extends TextArea> List<T> getTextAreas(Class<T> type) {
            ArrayList<TextArea> lst = new ArrayList<TextArea>();
            for (TextArea area : this.textAreas) {
                if (!type.isAssignableFrom(area.getClass())) continue;
                lst.add(area);
            }
            return lst;
        }

        public void render(double x, double y) {
            for (TextSegment segment : this.textSegments) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(segment.x + x), (double)(segment.y + y), (double)0.0);
                GL11.glScalef((float)segment.scale, (float)segment.scale, (float)1.0f);
                segment.font.func_78276_b(segment.text, 0, 0, segment.color);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }

        public void renderBounds(double x, double y) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)0.0);
            GL11.glScaled((double)(this.width / 10.0), (double)(this.height / 10.0), (double)1.0);
            Gui.func_73734_a((int)0, (int)0, (int)10, (int)10, (int)0x20FF0000);
            GL11.glPopMatrix();
            for (TextSegment segment : this.textSegments) {
                GL11.glPushMatrix();
                GL11.glPushMatrix();
                GL11.glTranslated((double)(segment.x + x), (double)(segment.y + y), (double)0.0);
                GL11.glScaled((double)(segment.width / 10.0), (double)(segment.height / 10.0), (double)1.0);
                Gui.func_73734_a((int)0, (int)0, (int)10, (int)10, (int)620757247);
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            for (TextArea ta : this.getTextAreas()) {
                if (!(ta instanceof TooltipArea)) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(ta.x + x), (double)(ta.y + y), (double)0.0);
                GL11.glScaled((double)(ta.width / 10.0), (double)(ta.height / 10.0), (double)1.0);
                Gui.func_73734_a((int)0, (int)0, (int)10, (int)10, (int)0x6000FF00);
                GL11.glPopMatrix();
            }
        }

        public void renderTooltips(double x, double y, double mouseX, double mouseY) {
            ArrayList<String> tooltipLines = new ArrayList<String>();
            for (TextArea ta : this.getTextAreas()) {
                if (!(ta instanceof TooltipArea) || !ta.isInside(x, y, mouseX, mouseY)) continue;
                tooltipLines.add(((TooltipArea)ta).text);
            }
            if (tooltipLines.size() > 0) {
                ManualWidgetsBase.renderTooltip((int)mouseX, (int)mouseY, tooltipLines, 0xFFFFFF, -267386864);
            }
        }
    }

    public static abstract class RangedTag
    extends Tag {
        public RangedTag(String type) {
            super(type);
        }

        void expand(TextContainer container, TextArea area) {
        }

        void pop(TextContainer container, RangedTag previous) {
        }
    }

    public static abstract class Tag {
        public final String type;

        public Tag(String type) {
            this.type = type;
        }

        boolean push(TextContainer container, Tag previous, String arguments, TextArea area, int pass) {
            return false;
        }

        abstract Tag create();
    }

    public static class TextSegment
    extends TextArea {
        public final String text;
        public final int color;
        public final float scale;
        public final FontRenderer font;

        public TextSegment(TextPage page, String text, double x, double y, double width, double height, int color, float scale, FontRenderer font) {
            super(page, x, y, width, height);
            this.text = text;
            this.color = color;
            this.scale = scale;
            this.font = font;
        }

        private TextSegment(TextPage page, String text, double x, double y, double width, double height, int color, float scale, FontRenderer font, List<Object> properties) {
            super(page, x, y, width, height, properties);
            this.text = text;
            this.color = color;
            this.scale = scale;
            this.font = font;
        }
    }

    public static class TextArea {
        public final TextPage page;
        public double x;
        public double y;
        public double width;
        public double height;
        private List<Object> properties = new ArrayList<Object>();

        protected TextArea(TextPage page, double x, double y, double width, double height) {
            this.page = page;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        protected TextArea(TextArea area) {
            this(area.page, area.x, area.y, area.width, area.height, area.properties);
        }

        private TextArea(TextPage page, double x, double y, double width, double height, List<Object> properties) {
            this(page, x, y, width, height);
            this.properties = properties;
        }

        public boolean isInside(double offsetX, double offsetY, double testX, double testY) {
            return testX >= this.x + offsetX && testX < this.x + offsetX + this.width && testY >= this.y + offsetY && testY < this.y + offsetY + this.height;
        }

        public TextArea setBounds(TextArea area) {
            this.x = area.x;
            this.y = area.y;
            this.width = area.width;
            this.height = area.height;
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof TextArea) {
                TextArea area = (TextArea)object;
                return area.page.equals(this.page) && area.x == this.x && area.y == this.y && area.width == this.width && area.height == this.height;
            }
            return false;
        }

        public void addProperty(Object obj) {
            this.properties.add(obj);
        }

        public boolean removeProperty(Object obj) {
            return this.properties.remove(obj);
        }

        public List<Object> getProperties() {
            return this.properties;
        }

        public <T> List<T> getProperties(Class<T> type) {
            ArrayList<Object> lst = new ArrayList<Object>();
            for (Object obj : this.properties) {
                if (!type.isAssignableFrom(obj.getClass())) continue;
                lst.add(obj);
            }
            return lst;
        }
    }
}

