/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class SmeltingRecipeWidget
extends ManualWidgetsBase {
    public static int height = 54;
    public static int width = 82;
    private static ResourceLocation furnaceGrid = new ResourceLocation("thebetweenlands:textures/gui/manual/furnaceGrid.png");
    ArrayList<ItemStack> outputs = new ArrayList();
    int progress = 0;
    int currentRecipe = 0;

    public SmeltingRecipeWidget(ItemStack output, int xStart, int yStart) {
        super(xStart, yStart);
        if (this.getSmeltingIngredient(output) != null) {
            this.outputs.add(output);
        }
    }

    public SmeltingRecipeWidget(ArrayList<ItemStack> outputs, int xStart, int yStart) {
        super(xStart, yStart);
        for (ItemStack output : outputs) {
            if (this.getSmeltingIngredient(output) == null) continue;
            this.outputs.add(output);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        if (this.outputs.size() > 0) {
            int newX = this.xStart + 1;
            int newY = this.yStart + 1;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.manual.field_146297_k.field_71446_o.func_110577_a(furnaceGrid);
            this.manual.func_73729_b(this.xStart, this.yStart, 0, 0, width, height);
            this.manual.field_146297_k.field_71446_o.func_110577_a(icons);
            this.manual.func_73729_b(this.xStart + 25, this.yStart + 17, 0, 0, this.progress, 16);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.renderItem(newX, newY, this.getSmeltingIngredient(this.outputs.get(this.currentRecipe)), false, true, this.manual.manualType);
            this.renderItem(newX + 60, newY + 16, this.outputs.get(this.currentRecipe), false, false, this.manual.manualType);
            this.renderItem(newX, newY + 36, new ItemStack(BLItemRegistry.itemsGeneric, 1, ItemGeneric.EnumItemGeneric.SULFUR.id), true, true, this.manual.manualType);
            ArrayList<String> specialToolTips = new ArrayList<String>();
            specialToolTips.add(burnTimeString.replace(".time.", "800"));
            this.addSpecialItemTooltip(newX, newY + 36, new ItemStack(BLItemRegistry.itemsGeneric, 1, ItemGeneric.EnumItemGeneric.SULFUR.id), specialToolTips);
            if (this.mouseX >= this.xStart + 25 && this.mouseX <= this.xStart + 47 && this.mouseY >= this.yStart + 17 && this.mouseY <= this.yStart + 33) {
                ArrayList<String> processTooltip = new ArrayList<String>();
                processTooltip.add(StatCollector.func_74838_a((String)"manual.widget.smelting.recipe"));
                processTooltip.add(processTimeSecondsString.replace(".seconds.", "10"));
                SmeltingRecipeWidget.renderTooltip(this.mouseX, this.mouseY, processTooltip, 0xFFFFFF, -267386864);
            }
        } else {
            this.isEmpty = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 20 == 0) {
            if (this.progress <= 22) {
                ++this.progress;
                this.drawForeGround();
            } else {
                this.progress = 0;
                this.currentRecipe = this.currentRecipe + 1 < this.outputs.size() ? ++this.currentRecipe : 0;
            }
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + width && y >= this.yStart && y <= this.yStart + height) {
            this.currentRecipe = this.currentRecipe + 1 < this.outputs.size() ? ++this.currentRecipe : 0;
            this.drawForeGround();
            this.progress = 0;
        }
    }

    public ItemStack getSmeltingIngredient(ItemStack output) {
        Map.Entry entry;
        Iterator iterator = FurnaceRecipes.func_77602_a().func_77599_b().entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.matches((ItemStack)(entry = iterator.next()).getValue(), output));
        return (ItemStack)entry.getKey();
    }

    private boolean matches(ItemStack itemStack1, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == itemStack1.func_77973_b() && (itemstack2.func_77960_j() == Short.MAX_VALUE || itemstack2.func_77960_j() == itemStack1.func_77960_j());
    }
}

