/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.GuiManualBase;
import thebetweenlands.manual.GuideBookEntryRegistry;
import thebetweenlands.manual.HLEntryRegistry;
import thebetweenlands.manual.ManualCategory;
import thebetweenlands.manual.Page;

@SideOnly(value=Side.CLIENT)
public class ManualWidgetsBase {
    public static ResourceLocation icons = new ResourceLocation("thebetweenlands:textures/gui/manual/icons.png");
    public static String processTimeString = StatCollector.func_74838_a((String)"manual.widget.process.time");
    public static String processTimeMinutesString = StatCollector.func_74838_a((String)"manual.widget.process.time.minutes");
    public static String processTimeSecondsString = StatCollector.func_74838_a((String)"manual.widget.process.time.seconds");
    public static String burnTimeString = StatCollector.func_74838_a((String)"manual.widget.burn.time");
    public ArrayList<PageLink> pageLinks = new ArrayList();
    public GuiManualBase manual;
    public int unchangedXStart;
    public int unchangedYStart;
    public int xStart;
    public int yStart;
    public boolean isPageRight = false;
    public boolean isEmpty = false;
    protected int mouseX;
    protected int mouseY;

    @SideOnly(value=Side.CLIENT)
    public ManualWidgetsBase(int xStart, int yStart) {
        this.unchangedXStart = xStart;
        this.unchangedYStart = yStart;
    }

    @SideOnly(value=Side.CLIENT)
    public static int renderTooltip(int x, int y, List<String> tooltipData, int color, int color2) {
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        if (!tooltipData.isEmpty()) {
            int var7;
            int var6;
            int var5 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var6 = 0; var6 < tooltipData.size(); ++var6) {
                var7 = fontRenderer.func_78256_a(tooltipData.get(var6));
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (tooltipData.size() > 1) {
                var9 += 2 + (tooltipData.size() - 1) * 10;
            }
            float z = 300.0f;
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 - 4, z, var6 + var5 + 3, var7 - 3, color2, color2);
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 + var9 + 3, z, var6 + var5 + 3, var7 + var9 + 4, color2, color2);
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 + var9 + 3, color2, color2);
            ManualWidgetsBase.drawGradientRect(var6 - 4, var7 - 3, z, var6 - 3, var7 + var9 + 3, color2, color2);
            ManualWidgetsBase.drawGradientRect(var6 + var5 + 3, var7 - 3, z, var6 + var5 + 4, var7 + var9 + 3, color2, color2);
            int var12 = (color & 0xFFFFFF) >> 1 | color & 0xFF000000;
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 - 3 + 1, z, var6 - 3 + 1, var7 + var9 + 3 - 1, color, var12);
            ManualWidgetsBase.drawGradientRect(var6 + var5 + 2, var7 - 3 + 1, z, var6 + var5 + 3, var7 + var9 + 3 - 1, color, var12);
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 - 3 + 1, color, color);
            ManualWidgetsBase.drawGradientRect(var6 - 3, var7 + var9 + 2, z, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            GL11.glDisable((int)2929);
            for (int var13 = 0; var13 < tooltipData.size(); ++var13) {
                String var14 = tooltipData.get(var13);
                fontRenderer.func_78261_a(var14, var6, var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            GL11.glEnable((int)2929);
            return var7 + 12;
        }
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(int x, int y, float z, int par3, int par4, int par5, int par6) {
        float var7 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(par5 & 0xFF) / 255.0f;
        float var11 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(par6 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        Tessellator var15 = Tessellator.field_78398_a;
        var15.func_78382_b();
        var15.func_78369_a(var8, var9, var10, var7);
        var15.func_78377_a((double)par3, (double)y, (double)z);
        var15.func_78377_a((double)x, (double)y, (double)z);
        var15.func_78369_a(var12, var13, var14, var11);
        var15.func_78377_a((double)x, (double)par4, (double)z);
        var15.func_78377_a((double)par3, (double)par4, (double)z);
        var15.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @SideOnly(value=Side.CLIENT)
    public void init(GuiManualBase manual) {
        this.manual = manual;
        this.resize();
    }

    @SideOnly(value=Side.CLIENT)
    public void setPageToRight() {
        this.isPageRight = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackGround();
        this.pageLinks.clear();
        this.drawForeGround();
    }

    @SideOnly(value=Side.CLIENT)
    public void resize() {
        this.xStart = (this.isPageRight ? this.manual.xStartRightPage : this.manual.xStart) + this.unchangedXStart;
        this.yStart = this.manual.yStart + this.unchangedYStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackGround() {
    }

    @SideOnly(value=Side.CLIENT)
    public void changeXStart(int xStart) {
        this.unchangedXStart = xStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void changeYStart(int yStart) {
        this.unchangedYStart = yStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
    }

    @SideOnly(value=Side.CLIENT)
    public void keyTyped(char c, int key) {
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (this.manual.untilUpdate % 5 == 0) {
            this.resize();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(int x, int y, int mouseButton) {
        if (mouseButton == 0) {
            for (PageLink link : this.pageLinks) {
                if (x < link.x || y < link.y || x > link.x + link.width || y > link.y + link.height) continue;
                this.manual.changeCategory(link.category, link.pageNumber + link.category.getIndexPages());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(int xPos, int yPos, ItemStack stack, boolean hasSpecialTooltip, boolean addPageLink, Item book) {
        RenderItem render = new RenderItem();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        render.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, xPos, yPos);
        render.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, xPos, yPos);
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        boolean shouldShowTooltip = false;
        if (addPageLink) {
            int lengthBefore = this.pageLinks.size();
            PageLink link = new PageLink(xPos, yPos, 16, 16, stack, book);
            if (link.category != null) {
                this.pageLinks.add(link);
            }
            boolean bl = shouldShowTooltip = this.pageLinks.size() > lengthBefore;
        }
        if (!hasSpecialTooltip && this.mouseX >= xPos && this.mouseY >= yPos && this.mouseX <= xPos + 16 && this.mouseY <= yPos + 16 && stack != null) {
            List tooltipData = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            if (addPageLink && shouldShowTooltip) {
                tooltipData.add("Open guide book entry");
            }
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = EnumChatFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ManualWidgetsBase.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
        GL11.glDisable((int)2896);
    }

    @SideOnly(value=Side.CLIENT)
    public void addSpecialItemTooltip(int xPos, int yPos, ItemStack stack, ArrayList<String> toolTips) {
        if (this.mouseX >= xPos && this.mouseY >= yPos && this.mouseX <= xPos + 16 && this.mouseY <= yPos + 16 && stack != null) {
            List tooltipData = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            for (String tip : toolTips) {
                tooltipData.add(tip);
            }
            Iterator<String> iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = iterator.next();
                if (!first) {
                    s_ = EnumChatFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ManualWidgetsBase.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
    }

    public static class PageLink {
        public int x;
        public int y;
        public int width;
        public int height;
        public int pageNumber;
        public ManualCategory category;

        public PageLink(int x, int y, int width, int height, ItemStack item, Item book) {
            block7: {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                if (item == null) break block7;
                if (book == BLItemRegistry.manualHL) {
                    for (ManualCategory category : HLEntryRegistry.CATEGORIES) {
                        block1: for (Page page : category.getVisiblePages()) {
                            if (page.pageItems.size() <= 0) continue;
                            for (ItemStack stack : page.pageItems) {
                                if (stack == null || stack.func_77973_b() != item.func_77973_b() || stack.func_77960_j() != item.func_77960_j() && stack.func_77960_j() != item.func_77960_j() - 1) continue;
                                this.pageNumber = page.pageNumber;
                                this.category = category;
                                continue block1;
                            }
                        }
                    }
                } else {
                    block3: for (Page page : GuideBookEntryRegistry.itemsCategory.getVisiblePages()) {
                        if (page.pageItems.size() <= 0) continue;
                        for (ItemStack stack : page.pageItems) {
                            if (stack == null || stack.func_77973_b() != item.func_77973_b() || stack.func_77960_j() != item.func_77960_j()) continue;
                            this.pageNumber = page.pageNumber;
                            this.category = GuideBookEntryRegistry.itemsCategory;
                            continue block3;
                        }
                    }
                }
            }
        }

        public PageLink(int x, int y, int width, int height, IAspectType aspectType) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            if (aspectType != null) {
                for (Page page : HLEntryRegistry.aspectCategory.getVisiblePages()) {
                    if (page.pageAspects.size() <= 0 || !page.pageAspects.contains(aspectType)) continue;
                    this.pageNumber = page.pageNumber;
                    this.category = HLEntryRegistry.aspectCategory;
                    break;
                }
            }
        }

        public String toString() {
            return "page number: " + this.pageNumber + ", category name: " + this.category.getName() + ", xStart: " + this.x + ", yStart: " + this.y + ", width: " + this.width + ", height: " + this.height;
        }
    }
}

