/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class ItemWidget
extends ManualWidgetsBase {
    public int width;
    public int height;
    public ArrayList<ItemStack> stacks = new ArrayList();
    public float scale = 1.0f;
    private int currentDisplayItem = 0;

    public ItemWidget(int xStart, int yStart, ItemStack stack, float scale) {
        super(xStart, yStart);
        this.stacks.add(stack);
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    public ItemWidget(int xStart, int yStart, IManualEntryItem entry, float scale) {
        super(xStart, yStart);
        for (int i = 0; i <= entry.metas(); ++i) {
            this.stacks.add(new ItemStack(entry.getItem(), 1, i));
        }
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    public ItemWidget(int xStart, int yStart, ArrayList<ItemStack> stacks, float scale) {
        super(xStart, yStart);
        this.stacks = stacks;
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    public ItemWidget(int xStart, int yStart, float scale, ArrayList<IManualEntryItem> items) {
        super(xStart, yStart);
        for (IManualEntryItem entry : items) {
            for (int i = 0; i <= entry.metas(); ++i) {
                this.stacks.add(new ItemStack(entry.getItem(), 1, i));
            }
        }
        this.scale = scale;
        this.width = (int)(16.0f * scale);
        this.height = (int)(16.0f * scale);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        RenderItem render = new RenderItem();
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        render.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.stacks.get(this.currentDisplayItem), (int)((float)this.xStart / this.scale), (int)((float)this.yStart / this.scale));
        render.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), this.stacks.get(this.currentDisplayItem), (int)((float)this.xStart / this.scale), (int)((float)this.yStart / this.scale));
        RenderHelper.func_74518_a();
        GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        if (this.mouseX >= this.xStart && (float)this.mouseX <= (float)this.xStart + 16.0f * this.scale && this.mouseY >= this.yStart && (float)this.mouseY <= (float)this.yStart + 16.0f * this.scale && this.stacks.get(this.currentDisplayItem) != null) {
            List tooltipData = this.stacks.get(this.currentDisplayItem).func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = EnumChatFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ItemWidget.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + this.width && y >= this.yStart && y <= this.yStart + this.height) {
            this.currentDisplayItem = this.currentDisplayItem + 1 < this.stacks.size() ? ++this.currentDisplayItem : 0;
            this.drawForeGround();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual != null && this.manual.untilUpdate % 200 == 0) {
            this.currentDisplayItem = this.currentDisplayItem + 1 < this.stacks.size() ? ++this.currentDisplayItem : 0;
            this.drawForeGround();
        }
    }
}

