/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.lwjgl.opengl.GL11;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class CraftingRecipeWidget
extends ManualWidgetsBase {
    public static int height = 54;
    public static int width = 116;
    private static ResourceLocation craftingGrid = new ResourceLocation("thebetweenlands:textures/gui/manual/craftingGrid.png");
    ArrayList<ItemStack> outputs = new ArrayList();
    private int currentRecipe = 0;

    public CraftingRecipeWidget(ItemStack output, int xStart, int yStart) {
        super(xStart, yStart);
        if (this.getRecipe(output) != null) {
            this.outputs.add(output);
        }
    }

    public CraftingRecipeWidget(ArrayList<ItemStack> outputs, int xStart, int yStart) {
        super(xStart, yStart);
        for (ItemStack output : outputs) {
            if (this.getRecipe(output) == null) continue;
            this.outputs.add(output);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        int newX = this.xStart + 1;
        int newY = this.yStart + 1;
        if (this.outputs.size() > 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.manual.field_146297_k.field_71446_o.func_110577_a(craftingGrid);
            this.manual.func_73729_b(this.xStart, this.yStart, 0, 0, width, height);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            IRecipe recipe = this.getRecipe(this.outputs.get(this.currentRecipe));
            String recipeType = "";
            if (recipe != null) {
                block21: {
                    ShapelessRecipes shapeless;
                    ShapedRecipes shaped;
                    if (recipe instanceof ShapedRecipes) {
                        shaped = (ShapedRecipes)recipe;
                        recipeType = StatCollector.func_74838_a((String)"manual.widget.crafting.shaped.recipe");
                        for (int y = 0; y < shaped.field_77577_c; ++y) {
                            for (int x = 0; x < shaped.field_77576_b; ++x) {
                                this.renderItem(newX + 18 * x, newY + 18 * y, shaped.field_77574_d[y * shaped.field_77576_b + x], false, true, this.manual.manualType);
                            }
                        }
                    } else if (recipe instanceof ShapedOreRecipe) {
                        shaped = (ShapedOreRecipe)recipe;
                        recipeType = StatCollector.func_74838_a((String)"manual.widget.crafting.shaped.recipe");
                        int width = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)4);
                        int height = (Integer)ReflectionHelper.getPrivateValue(ShapedOreRecipe.class, (Object)shaped, (int)5);
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                Object input = shaped.getInput()[y * width + x];
                                if (input == null) continue;
                                this.renderItem(newX + 18 * x, newY + 18 * y, input instanceof ItemStack ? (ItemStack)input : (ItemStack)((ArrayList)input).get(0), false, true, this.manual.manualType);
                            }
                        }
                    } else if (recipe instanceof ShapelessRecipes) {
                        shapeless = (ShapelessRecipes)recipe;
                        recipeType = StatCollector.func_74838_a((String)"manual.widget.crafting.shapeless.recipe");
                        for (int y = 0; y < 3; ++y) {
                            for (int x = 0; x < 3; ++x) {
                                int index = y * 3 + x;
                                if (index < shapeless.field_77579_b.size()) {
                                    this.renderItem(newX + 18 * x, newY + 18 * y, (ItemStack)shapeless.field_77579_b.get(index), false, true, this.manual.manualType);
                                    continue;
                                }
                                break block21;
                            }
                        }
                    } else if (recipe instanceof ShapelessOreRecipe) {
                        shapeless = (ShapelessOreRecipe)recipe;
                        recipeType = StatCollector.func_74838_a((String)"manual.widget.crafting.shapeless.recipe");
                        for (int y = 0; y < 3; ++y) {
                            for (int x = 0; x < 3; ++x) {
                                int index = y * 3 + x;
                                if (index < shapeless.func_77570_a()) {
                                    Object input = shapeless.getInput().get(index);
                                    if (input == null) continue;
                                    this.renderItem(newX + 18 * x, newY + 18 * y, input instanceof ItemStack ? (ItemStack)input : (ItemStack)((ArrayList)input).get(0), false, true, this.manual.manualType);
                                    continue;
                                }
                                break block21;
                            }
                        }
                    }
                }
                this.renderItem(newX + 94, newY + 18, recipe.func_77571_b(), false, false, this.manual.manualType);
            }
            if (this.mouseX >= this.xStart + 61 && this.mouseX <= this.xStart + 61 + 22 && this.mouseY >= this.yStart + 19 && this.mouseY <= this.yStart + 19 + 15) {
                ArrayList<String> processTooltip = new ArrayList<String>();
                processTooltip.add(recipeType);
                CraftingRecipeWidget.renderTooltip(this.mouseX, this.mouseY, processTooltip, 0xFFFFFF, -267386864);
            }
        } else {
            this.isEmpty = true;
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + width && y >= this.yStart && y <= this.yStart + height) {
            this.currentRecipe = this.currentRecipe + 1 < this.outputs.size() ? ++this.currentRecipe : 0;
            this.drawForeGround();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 200 == 0) {
            this.currentRecipe = this.currentRecipe + 1 < this.outputs.size() ? ++this.currentRecipe : 0;
            this.drawForeGround();
        }
    }

    public IRecipe getRecipe(ItemStack output) {
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(obj instanceof IRecipe) || !this.matches(((IRecipe)obj).func_77571_b(), output)) continue;
            return (IRecipe)obj;
        }
        return null;
    }

    private boolean matches(ItemStack itemStack1, ItemStack itemstack2) {
        return itemStack1 != null && itemstack2 != null && itemstack2.func_77973_b() == itemStack1.func_77973_b() && itemstack2.func_77960_j() == itemStack1.func_77960_j();
    }
}

