/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.manual.widgets.ManualWidgetsBase;
import thebetweenlands.recipes.misc.CompostRecipe;

public class CompostRecipeWidget
extends ManualWidgetsBase {
    public static int width = 62;
    public static int height = 38;
    protected int currentRecipe;

    public CompostRecipeWidget(int xStart, int yStart) {
        super(xStart, yStart);
        Random random = new Random();
        this.currentRecipe = random.nextInt(CompostRecipe.compostRecipes.size());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
        ArrayList<String> processTooltip;
        CompostRecipe recipe = CompostRecipe.compostRecipes.get(this.currentRecipe);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.manual.field_146297_k.field_71446_o.func_110577_a(icons);
        this.manual.func_73729_b(this.xStart + 18, this.yStart + 4, 0, 17, 16, 16);
        this.manual.func_73729_b(this.xStart + 38, this.yStart + 22, 0, 0, 22, 16);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.renderItem(this.xStart, this.yStart, new ItemStack(recipe.compostItem, 1, recipe.itemDamage), false, true, this.manual.manualType);
        this.renderItem(this.xStart + 18, this.yStart + 22, new ItemStack(Item.func_150898_a((Block)BLBlockRegistry.compostBin)), false, false, this.manual.manualType);
        this.renderItem(this.xStart + 62, this.yStart + 22, ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.COMPOST), false, false, this.manual.manualType);
        if (this.mouseX >= this.xStart + 18 && this.mouseX <= this.xStart + 34 && this.mouseY >= this.yStart + 4 && this.mouseY <= this.yStart + 20) {
            processTooltip = new ArrayList<String>();
            processTooltip.add(StatCollector.func_74838_a((String)"manual.widget.compost.recipe"));
            int minutes = recipe.compostTime / 20 / 60;
            int seconds = recipe.compostTime / 20 % 60;
            processTooltip.add(seconds > 0 ? processTimeString.replace(".minutes.", "" + minutes).replace(".seconds.", "" + seconds) : processTimeMinutesString.replace(".minutes.", "" + minutes));
            processTooltip.add(StatCollector.func_74838_a((String)"manual.widget.compost.amount").replace(".amount.", "" + recipe.compostAmount));
            CompostRecipeWidget.renderTooltip(this.mouseX, this.mouseY, processTooltip, 0xFFFFFF, -267386864);
        }
        if (this.mouseX >= this.xStart + 38 && this.mouseX <= this.xStart + 60 && this.mouseY >= this.yStart + 22 && this.mouseY <= this.yStart + 38) {
            processTooltip = new ArrayList();
            processTooltip.add(StatCollector.func_74838_a((String)"manual.widget.compost.amount.per"));
            CompostRecipeWidget.renderTooltip(this.mouseX, this.mouseY, processTooltip, 0xFFFFFF, -267386864);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + width && y >= this.yStart && y <= this.yStart + height) {
            this.currentRecipe = this.currentRecipe + 1 < CompostRecipe.compostRecipes.size() ? ++this.currentRecipe : 0;
            this.drawForeGround();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 20 == 0) {
            this.currentRecipe = this.currentRecipe + 1 < CompostRecipe.compostRecipes.size() ? ++this.currentRecipe : 0;
            this.drawForeGround();
        }
    }
}

