/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class AspectWidget
extends ManualWidgetsBase {
    public IAspectType aspect;
    public float scale = 1.0f;

    public AspectWidget(int xStart, int yStart, IAspectType aspect, float scale) {
        super(xStart, yStart);
        this.aspect = aspect;
        this.scale = scale;
    }

    @Override
    public void drawForeGround() {
        super.drawForeGround();
        AspectWidget.renderIcon(this.xStart, this.yStart, (int)(16.0f * this.scale), (int)(16.0f * this.scale), this.aspect.getIconIndex());
        if (this.mouseX >= this.xStart && (float)this.mouseX <= (float)this.xStart + 16.0f * this.scale && this.mouseY >= this.yStart && (float)this.mouseY <= (float)this.yStart + 16.0f * this.scale) {
            ArrayList<String> tooltipData = new ArrayList<String>();
            tooltipData.add(this.aspect.getName());
            tooltipData.add(EnumChatFormatting.GRAY + this.aspect.getType());
            AspectWidget.renderTooltip(this.mouseX, this.mouseY, tooltipData, 0xFFFFFF, -267386864);
        }
    }

    public static void renderIcon(int x, int y, int width, int height, int id) {
        ResourceLocation ASPECT_MAP = new ResourceLocation("thebetweenlands:textures/items/strictlyHerblore/misc/aspectMap.png");
        int TEX_WIDTH = 64;
        int TEX_HEIGHT = 64;
        int ICON_WIDTH = 16;
        int ICON_HEIGHT = 16;
        int ICONS_H = 4;
        double REL_ICON_WIDTH = 0.25;
        double REL_ICON_HEIGHT = 0.25;
        int iconH = id % 4;
        int iconV = id / 4;
        double u = (double)iconH * 0.25;
        double v = (double)iconV * 0.25;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ASPECT_MAP);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glEnable((int)3042);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a(0.0, 0.0, 0.0, u, v);
        Tessellator.field_78398_a.func_78374_a(0.0, (double)height, 0.0, u, v + 0.25);
        Tessellator.field_78398_a.func_78374_a((double)width, (double)height, 0.0, u + 0.25, v + 0.25);
        Tessellator.field_78398_a.func_78374_a((double)width, 0.0, 0.0, u + 0.25, v);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

