/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.manual.widgets.ManualWidgetsBase;
import thebetweenlands.utils.AspectIconRenderer;

public class AspectSlideShowWidget
extends ManualWidgetsBase {
    public ItemStack itemStack;
    public ArrayList<IAspectType> aspects = new ArrayList();
    public int currentItems = 0;

    public AspectSlideShowWidget(int xStart, int yStart, ItemStack itemStack) {
        super(xStart, yStart);
        this.itemStack = itemStack;
    }

    public AspectSlideShowWidget(int xStart, int yStart, ArrayList<IAspectType> aspects) {
        super(xStart, yStart);
        this.aspects = aspects;
    }

    public AspectSlideShowWidget(int xStart, int yStart, IAspectType[] aspects) {
        super(xStart, yStart);
        Collections.addAll(this.aspects, aspects);
    }

    @Override
    public void drawForeGround() {
        List<IAspectType> subItems = this.aspects.subList(this.currentItems, this.currentItems + (this.aspects.size() - this.currentItems > 5 ? 6 : this.aspects.size() - this.currentItems));
        int width = 0;
        for (IAspectType aspect : subItems) {
            AspectIconRenderer.renderIcon(this.xStart + width, this.yStart, 16, 16, aspect.getIconIndex());
            ManualWidgetsBase.PageLink link = new ManualWidgetsBase.PageLink(this.xStart + width, this.yStart, 16, 16, aspect);
            if (link.category != null) {
                this.pageLinks.add(link);
            }
            if (this.mouseX >= this.xStart + width && this.mouseX <= this.xStart + 16 + width && this.mouseY >= this.yStart && this.mouseY <= this.yStart + 16) {
                ArrayList<String> tooltipData = new ArrayList<String>();
                tooltipData.add(aspect.getName());
                tooltipData.add(EnumChatFormatting.GRAY + aspect.getType());
                tooltipData.add(EnumChatFormatting.GRAY + "Open guide book entry");
                AspectSlideShowWidget.renderTooltip(this.mouseX, this.mouseY, tooltipData, 0xFFFFFF, -267386864);
            }
            width += 18;
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.itemStack != null) {
            this.getAspects();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 20 == 0) {
            this.currentItems = this.currentItems + 1 < this.aspects.size() && this.aspects.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + 96 && y >= this.yStart && y <= this.yStart + 16) {
            this.currentItems = this.currentItems + 1 < this.aspects.size() && this.aspects.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    public void getAspects() {
        this.aspects.clear();
        for (Aspect aspect : AspectManager.get((World)Minecraft.func_71410_x().field_71441_e).getDiscoveredAspects(this.itemStack, AspectManager.getMergedDiscoveryContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g))) {
            this.aspects.add(aspect.type);
        }
    }
}

