/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual.widgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class AspectItemSlideShowWidget
extends ManualWidgetsBase {
    public IAspectType aspectType;
    public ArrayList<ItemStack> items = new ArrayList();
    public int currentItems = 0;

    public AspectItemSlideShowWidget(int xStart, int yStart, IAspectType aspectType) {
        super(xStart, yStart);
        this.aspectType = aspectType;
    }

    public AspectItemSlideShowWidget(int xStart, int yStart, ArrayList<ItemStack> items) {
        super(xStart, yStart);
        this.items = items;
    }

    @Override
    public void drawForeGround() {
        super.drawForeGround();
        List<ItemStack> subItems = this.items.subList(this.currentItems, this.currentItems + (this.items.size() - this.currentItems > 5 ? 6 : this.items.size() - this.currentItems));
        int width = 0;
        for (ItemStack itemStack : subItems) {
            this.renderItem(this.xStart + width, this.yStart, itemStack, false, true, this.manual.manualType);
            width += 18;
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.aspectType != null) {
            this.getItems();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 60 == 0) {
            this.currentItems = this.currentItems + 1 < this.items.size() && this.items.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + 96 && y >= this.yStart && y <= this.yStart + 16) {
            this.currentItems = this.currentItems + 1 < this.items.size() && this.items.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    public void getItems() {
        this.items.clear();
        AspectManager manager = AspectManager.get((World)Minecraft.func_71410_x().field_71441_e);
        for (Map.Entry<AspectManager.AspectItem, List<AspectManager.AspectItemEntry>> entry : AspectManager.getRegisteredItems().entrySet()) {
            List<Aspect> discoveredAspects = manager.getDiscoveredAspects(entry.getKey(), AspectManager.getMergedDiscoveryContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            for (Aspect aspect : discoveredAspects) {
                if (!aspect.type.equals(this.aspectType)) continue;
                this.items.add(new ItemStack(entry.getKey().item, 1, entry.getKey().damage));
            }
        }
    }
}

