/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.elixirs.ElixirRecipe;
import thebetweenlands.herblore.elixirs.ElixirRecipes;
import thebetweenlands.herblore.elixirs.effects.ElixirEffect;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.IManualEntryEntity;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.manual.Page;
import thebetweenlands.manual.widgets.AnimatorRecipeWidget;
import thebetweenlands.manual.widgets.AspectItemSlideShowWidget;
import thebetweenlands.manual.widgets.AspectSlideShowWidget;
import thebetweenlands.manual.widgets.AspectWidget;
import thebetweenlands.manual.widgets.ButtonWidget;
import thebetweenlands.manual.widgets.CompostRecipeWidget;
import thebetweenlands.manual.widgets.CraftingRecipeWidget;
import thebetweenlands.manual.widgets.DruidAltarWidget;
import thebetweenlands.manual.widgets.ItemWidget;
import thebetweenlands.manual.widgets.ManualWidgetsBase;
import thebetweenlands.manual.widgets.PestleAndMortarRecipeWidget;
import thebetweenlands.manual.widgets.PictureWidget;
import thebetweenlands.manual.widgets.PurifierRecipeWidget;
import thebetweenlands.manual.widgets.RubberTabWidget;
import thebetweenlands.manual.widgets.SmeltingRecipeWidget;
import thebetweenlands.manual.widgets.text.FormatTags;
import thebetweenlands.manual.widgets.text.TextContainer;
import thebetweenlands.manual.widgets.text.TextWidget;
import thebetweenlands.recipes.misc.PestleAndMortarRecipe;

public class PageCreators {
    public static int craftingRecipeHeight = CraftingRecipeWidget.height + 5;
    public static int smeltingRecipeHeight = SmeltingRecipeWidget.height + 5;
    public static int compostRecipeHeight = CompostRecipeWidget.height + 5;
    public static int pestleAndMortarRecipeHeight = PestleAndMortarRecipeWidget.height + 5;
    public static int purifierRecipeHeight = PurifierRecipeWidget.height + 5;
    public static int druidAltarRecipeHeight = DruidAltarWidget.height + 5;
    public static int rubberTabRecipeHeight = RubberTabWidget.height + 5;
    public static int animatorRecipeHeight = AnimatorRecipeWidget.height + 5;

    public static ArrayList<Page> pageCreatorButtons(ArrayList<Page> pages, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int pageAmount = pages.size();
        int times = 0;
        while (pageAmount > 0) {
            ArrayList<Page> pagesTemp = new ArrayList<Page>();
            pagesTemp.addAll(pages.subList(7 * times, pageAmount > 7 ? 7 + 7 * times : 7 * times + pageAmount));
            int height = 0;
            ArrayList<ButtonWidget> widgets = new ArrayList<ButtonWidget>();
            for (Page page : pagesTemp) {
                widgets.add(new ButtonWidget(15, 10 + height, page));
                height += 20;
            }
            newPages.add(new Page("index" + times, (ArrayList)widgets.clone(), false, manualType));
            widgets.clear();
            pagesTemp.clear();
            pageAmount -= 7;
            ++times;
        }
        return newPages;
    }

    public static ArrayList<Page> pageCreatorEntities(IManualEntryEntity entity, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        String title = entity.pageName();
        newPages.add(new Page(title, isHidden, manualType, new TextWidget(15, 10, "manual." + entity.pageName() + ".title"), new PictureWidget(74 - entity.pictureWidth() / 2, 15, entity.manualPictureLocation(), entity.pictureWidth(), entity.pictureHeight(), entity.manualStats(), 128.0, 128.0)).setParent().setEntity(entity));
        newPages.addAll(PageCreators.TextPages(15, 10, "manual." + entity.pageName() + ".description", title, isHidden, manualType));
        return newPages;
    }

    public static ArrayList<Page> pageCreatorMachines(String entryName, ItemStack machine, String imageLocation, int width, int height, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        newPages.add(new Page(entryName, isHidden, manualType, new TextWidget(15, 10, "manual." + entryName + ".title", 1.5f), new ItemWidget(49, 77, machine, 3.0f)).addItem(machine).setParent());
        newPages.add(new Page(entryName, isHidden, manualType, new PictureWidget(73 - width / 2, 70 - height / 2, imageLocation, width, height, 256.0, 256.0)));
        newPages.addAll(PageCreators.TextPages(16, 10, "manual." + entryName + ".description", entryName, isHidden, manualType));
        return newPages;
    }

    public static ArrayList<Page> pageCreatorItems(IManualEntryItem item, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        String title = item.manualName(0);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i <= item.metas(); ++i) {
            items.add(new ItemStack(item.getItem(), 1, i));
        }
        newPages.add(new Page(title, isHidden, manualType, new TextWidget(18, 12, "manual." + item.manualName(0) + ".title", 1.5f), new ItemWidget(49, 77, item, 3.0f)).addItems(items).setParent());
        newPages.addAll(PageCreators.TextPages(16, 10, "manual." + item.manualName(0) + ".description", title, isHidden, manualType));
        ArrayList<IManualEntryItem> manualItem = new ArrayList<IManualEntryItem>();
        manualItem.add(item);
        newPages.addAll(PageCreators.RecipePages(manualItem, title, isHidden, manualType));
        return newPages;
    }

    public static ArrayList<Page> pageCreatorItems(String name, ArrayList<IManualEntryItem> manualItems, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IManualEntryItem item : manualItems) {
            for (int i = 0; i <= item.metas(); ++i) {
                items.add(new ItemStack(item.getItem(), 1, i));
            }
        }
        newPages.add(new Page(name, false, manualType, new TextWidget(15, 10, "manual." + name + ".title", 1.5f), new ItemWidget(49, 77, items, 3.0f)).addItems(items).setParent());
        newPages.addAll(PageCreators.TextPages(16, 10, "manual." + name + ".description", name, isHidden, manualType));
        newPages.addAll(PageCreators.RecipePages(manualItems, name, isHidden, manualType));
        return newPages;
    }

    public static ArrayList<Page> TextPages(int x, int y, String unlocalizedName, String pageName, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        String text = StatCollector.func_74838_a((String)unlocalizedName);
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(116.0, 144.0, text, Minecraft.func_71410_x().field_71466_p));
        for (int i = 0; i < textContainer.getPages().size(); ++i) {
            newPages.add(new Page(pageName, isHidden, manualType, new TextWidget(x, y, unlocalizedName, i)));
        }
        return newPages;
    }

    public static ArrayList<Page> RecipePages(ArrayList<IManualEntryItem> items, String pageName, boolean isHidden, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 10;
        ArrayList<ManualWidgetsBase> widgets = new ArrayList<ManualWidgetsBase>();
        for (int type = 0; type <= 8; ++type) {
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            for (IManualEntryItem item : items) {
                for (int i : item.recipeType(0)) {
                    for (int j = 0; j <= item.metas(); ++j) {
                        if (i != type) continue;
                        itemStacks.add(new ItemStack(item.getItem(), 1, j));
                    }
                }
            }
            if (itemStacks.size() <= 0) continue;
            int latestAdded = 0;
            switch (type) {
                case 1: {
                    widgets.add(new SmeltingRecipeWidget(itemStacks, 15, height));
                    height += smeltingRecipeHeight;
                    latestAdded += smeltingRecipeHeight;
                    break;
                }
                case 2: {
                    widgets.add(new CraftingRecipeWidget(itemStacks, 15, height));
                    height += craftingRecipeHeight;
                    latestAdded += craftingRecipeHeight;
                    break;
                }
                case 3: {
                    widgets.add(new PestleAndMortarRecipeWidget(itemStacks, 15, height));
                    height += pestleAndMortarRecipeHeight;
                    latestAdded += pestleAndMortarRecipeHeight;
                    break;
                }
                case 4: {
                    widgets.add(new CompostRecipeWidget(15, height));
                    height += compostRecipeHeight;
                    latestAdded += compostRecipeHeight;
                    break;
                }
                case 5: {
                    widgets.add(new PurifierRecipeWidget(itemStacks, 15, height));
                    height += purifierRecipeHeight;
                    latestAdded += purifierRecipeHeight;
                    break;
                }
                case 6: {
                    widgets.add(new RubberTabWidget(15, height));
                    height += rubberTabRecipeHeight;
                    latestAdded += rubberTabRecipeHeight;
                    break;
                }
                case 7: {
                    widgets.add(new DruidAltarWidget(itemStacks, 15, height));
                    height += druidAltarRecipeHeight;
                    latestAdded += druidAltarRecipeHeight;
                    break;
                }
                case 8: {
                    widgets.add(new AnimatorRecipeWidget(itemStacks, 15, height));
                    height += animatorRecipeHeight;
                    latestAdded += animatorRecipeHeight;
                }
            }
            if (height < 152) continue;
            ManualWidgetsBase temp = (ManualWidgetsBase)widgets.get(widgets.size() - 1);
            widgets.remove(widgets.size() - 1);
            Page page = new Page(pageName, (ArrayList)widgets.clone(), isHidden, manualType);
            newPages.add(page);
            widgets.clear();
            temp.changeYStart(10);
            widgets.add(temp);
            height = 10 + latestAdded;
        }
        if (widgets.size() > 0) {
            Page page = new Page(pageName, (ArrayList)widgets.clone(), isHidden, manualType);
            newPages.add(page);
            widgets.clear();
        }
        return newPages;
    }

    public static ArrayList<Page> AspectPages(IAspectType aspect, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ArrayList<ManualWidgetsBase> widgets = new ArrayList<ManualWidgetsBase>();
        widgets.add(new AspectWidget(18, 12, aspect, 1.0f));
        widgets.add(new TextWidget(38, 14, "<font:custom>" + aspect.getName() + "</font>", true));
        widgets.add(new TextWidget(18, 12 + (height += 24), "manual." + aspect.getName().toLowerCase() + ".description"));
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(116.0, 144.0, StatCollector.func_74838_a((String)("manual." + aspect.getName().toLowerCase() + ".description")), Minecraft.func_71410_x().field_71466_p));
        height = (int)((double)height + (textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y + 18.0));
        if (height + 18 + 16 < 152) {
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.found.in"));
            widgets.add(new AspectItemSlideShowWidget(18, 12 + (height += 16), aspect));
            height += 18;
        } else {
            newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.found.in"));
            widgets.add(new AspectItemSlideShowWidget(18, 12 + (height += 16), aspect));
            height += 18;
        }
        if (height + 10 + 18 < 152) {
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.used.in"));
            height += 10;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ElixirRecipe recipe : ElixirRecipes.getFromAspect(aspect)) {
                items.add(BLItemRegistry.elixir.getElixirItem(recipe.positiveElixir, recipe.baseDuration, 1, 0));
                items.add(BLItemRegistry.elixir.getElixirItem(recipe.negativeElixir, recipe.baseDuration, 1, 1));
            }
            widgets.add(new AspectItemSlideShowWidget(18, 12 + height, items));
            height += 18;
        } else {
            if (newPages.size() > 0) {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setAspect(aspect).setLocalizedPageName(aspect.getName()));
            } else {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            }
            widgets.add(new TextWidget(18, 12 + height, "manual.aspect.found.in"));
            height += 10;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (ElixirRecipe recipe : ElixirRecipes.getFromAspect(aspect)) {
                items.add(BLItemRegistry.elixir.getElixirItem(recipe.positiveElixir, recipe.baseDuration, 1, 0));
                items.add(BLItemRegistry.elixir.getElixirItem(recipe.negativeElixir, recipe.baseDuration, 1, 1));
            }
            widgets.add(new AspectItemSlideShowWidget(18, 12 + height, items));
            height += 18;
        }
        if (widgets.size() > 0) {
            if (newPages.size() > 0) {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setAspect(aspect).setLocalizedPageName(aspect.getName()));
            } else {
                newPages.add(new Page(aspect.getName().toLowerCase(), widgets, false, manualType).setParent().setAspect(aspect).setLocalizedPageName(aspect.getName()));
            }
        }
        return newPages;
    }

    public static ArrayList<Page> AspectItemPages(AspectManager.AspectItem item, Item manualType) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ItemStack itemStack = new ItemStack(item.item, 1, item.damage);
        ArrayList<ManualWidgetsBase> widgets = new ArrayList<ManualWidgetsBase>();
        widgets.add(new ItemWidget(18, 12, itemStack, 1.0f));
        widgets.add(new ItemWidget(118, 12, PestleAndMortarRecipe.getInput(itemStack), 1.0f));
        widgets.add(new TextWidget(38, 16, itemStack.func_82833_r(), true).setWidth(70));
        widgets.add(new TextWidget(18, 12 + (height += 28), "manual." + itemStack.func_77977_a() + ".description"));
        TextContainer textContainer = PageCreators.parseTextContainer(new TextContainer(116.0, 144.0, StatCollector.func_74838_a((String)("manual." + itemStack.func_77977_a() + ".description")), Minecraft.func_71410_x().field_71466_p));
        height = (int)((double)height + (18.0 + textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y));
        widgets.add(new TextWidget(18, 12 + height, "manual.has.aspects"));
        widgets.add(new AspectSlideShowWidget(18, 12 + (height += 18), itemStack));
        newPages.add(new Page(itemStack.func_82833_r().toLowerCase().replace(" ", ""), widgets, true, manualType).setParent().addItem(itemStack).addItem(PestleAndMortarRecipe.getInput(itemStack)).setLocalizedPageName(itemStack.func_82833_r()));
        return newPages;
    }

    public static ArrayList<Page> elixirPages(ItemStack item, Item manualType, ElixirEffect effect) {
        ArrayList<Page> newPages = new ArrayList<Page>();
        int height = 0;
        ArrayList<ManualWidgetsBase> widgets = new ArrayList<ManualWidgetsBase>();
        widgets.add(new ItemWidget(18, 12, item, 1.0f));
        widgets.add(new TextWidget(38, 14, item.func_82833_r(), true));
        height += 32;
        TextContainer textContainer = new TextContainer(114.0, 130.0, StatCollector.func_74838_a((String)("manual." + item.func_77977_a() + ".description")), Minecraft.func_71410_x().field_71466_p);
        textContainer = PageCreators.parseTextContainer(textContainer);
        Page temp = null;
        if (textContainer.getPages().size() > 1) {
            widgets.add(new TextWidget(15, height, "manual." + item.func_77977_a() + ".description", 0, 114, 130));
            newPages.add(new Page(item.func_82833_r().toLowerCase().replace(" ", ""), (ArrayList)widgets.clone(), false, manualType).setParent().setLocalizedPageName(item.func_82833_r()).addItem(item));
            widgets.clear();
            widgets.add(new TextWidget(15, 14, "manual." + item.func_77977_a() + ".description", 1, 114, 130));
            if (ElixirRecipes.getFromEffect(effect) != null && ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects != null) {
                if (textContainer.getPages().get((int)1).getSegments().get((int)(textContainer.getPages().get((int)1).getSegments().size() - 1)).y + 38.0 < 142.0) {
                    widgets.add(new AspectSlideShowWidget(18, (int)(textContainer.getPages().get((int)1).getSegments().get((int)(textContainer.getPages().get((int)1).getSegments().size() - 1)).y + 22.0), ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                } else {
                    temp = new Page(item.func_82833_r().toLowerCase().replace(" ", ""), false, manualType, new AspectSlideShowWidget(15, 12, ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                }
            }
            newPages.add(new Page(item.func_82833_r().toLowerCase().replace(" ", ""), widgets, false, manualType).setLocalizedPageName(item.func_82833_r()).addItem(item));
            if (temp != null) {
                newPages.add(temp);
            }
        } else {
            widgets.add(new TextWidget(15, height, "manual." + item.func_77977_a() + ".description"));
            if (ElixirRecipes.getFromEffect(effect) != null && ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects != null) {
                if (height + 24 < 142) {
                    widgets.add(new AspectSlideShowWidget(18, height + (int)(textContainer.getPages().get((int)0).getSegments().get((int)(textContainer.getPages().get((int)0).getSegments().size() - 1)).y + 8.0), ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                } else {
                    temp = new Page(item.func_82833_r().toLowerCase().replace(" ", ""), false, manualType, new AspectSlideShowWidget(15, 12, ElixirRecipes.getFromEffect((ElixirEffect)effect).aspects));
                }
            }
            newPages.add(new Page(item.func_82833_r().toLowerCase().replace(" ", ""), widgets, false, manualType).setParent().setLocalizedPageName(item.func_82833_r()).addItem(item));
            if (temp != null) {
                newPages.add(temp);
            }
        }
        return newPages;
    }

    private static TextContainer parseTextContainer(TextContainer textContainer) {
        textContainer.setCurrentScale(1.0f).setCurrentColor(0x808080);
        textContainer.registerTag(new FormatTags.TagNewLine());
        textContainer.registerTag(new FormatTags.TagScale(1.0f));
        textContainer.registerTag(new FormatTags.TagColor(0x808080));
        textContainer.registerTag(new FormatTags.TagTooltip("N/A"));
        textContainer.registerTag(new FormatTags.TagSimple("bold", EnumChatFormatting.BOLD));
        textContainer.registerTag(new FormatTags.TagSimple("obfuscated", EnumChatFormatting.OBFUSCATED));
        textContainer.registerTag(new FormatTags.TagSimple("italic", EnumChatFormatting.ITALIC));
        textContainer.registerTag(new FormatTags.TagSimple("strikethrough", EnumChatFormatting.STRIKETHROUGH));
        textContainer.registerTag(new FormatTags.TagSimple("underline", EnumChatFormatting.UNDERLINE));
        textContainer.registerTag(new FormatTags.TagPagelink());
        textContainer.registerTag(new FormatTags.TagRainbow());
        try {
            textContainer.parse();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return textContainer;
    }
}

