/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.DiscoveryContainer;
import thebetweenlands.herblore.aspects.IDiscoveryProvider;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.GuideBookEntryRegistry;
import thebetweenlands.manual.HLEntryRegistry;
import thebetweenlands.manual.ManualCategory;

public class ManualManager {
    public static List<String> findablePagesGuideBook = new ArrayList<String>();
    public static List<String> findablePagesHL = new ArrayList<String>();
    public static List<String> findablePagesAll = new ArrayList<String>();

    public static boolean findPage(EntityPlayer player, String pageName, Item itemManual) {
        if (pageName != null && player != null) {
            for (int i = -1; i < 36; ++i) {
                ArrayList<String> foundPages;
                ItemStack stack = i >= 0 ? player.field_71071_by.func_70301_a(i) : player.func_71045_bC();
                if (stack == null || stack.func_77973_b() != itemManual) continue;
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                if ((foundPages = ManualManager.getFoundPages(player, itemManual)) != null && !foundPages.contains(pageName)) {
                    NBTTagList pages = new NBTTagList();
                    for (String string : foundPages) {
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74778_a("page", string);
                        pages.func_74742_a((NBTBase)data);
                    }
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("page", pageName);
                    pages.func_74742_a((NBTBase)data);
                    nbt.func_74782_a("pages", (NBTBase)pages);
                } else {
                    NBTTagList pages = new NBTTagList();
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("page", pageName);
                    pages.func_74742_a((NBTBase)data);
                    nbt.func_74782_a("pages", (NBTBase)pages);
                }
                player.field_71071_by.func_70301_a(i).func_77982_d(nbt);
                return true;
            }
        }
        return false;
    }

    public static ArrayList<String> getFoundPages(EntityPlayer player, Item itemManual) {
        if (player != null) {
            ArrayList<String> foundPages = new ArrayList<String>();
            for (int i = -1; i < 36; ++i) {
                NBTTagCompound nbt;
                ItemStack stack = i >= 0 ? player.field_71071_by.func_70301_a(i) : player.func_71045_bC();
                if (stack == null || stack.func_77973_b() != itemManual || (nbt = stack.func_77978_p()) == null) continue;
                NBTTagList tag = nbt.func_150295_c("pages", 10);
                if (tag != null) {
                    for (int j = 0; j < tag.func_74745_c(); ++j) {
                        NBTTagCompound data = tag.func_150305_b(j);
                        foundPages.add(data.func_74779_i("page"));
                    }
                }
                return foundPages;
            }
        }
        return null;
    }

    public static boolean hasFoundPage(EntityPlayer player, String page, Item itemManual) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() == BLItemRegistry.manualHL) {
            IDiscoveryProvider provider = (IDiscoveryProvider)stack.func_77973_b();
            DiscoveryContainer container = provider.getContainer(stack);
            ItemStack ingredient = null;
            Map<AspectManager.AspectItem, List<AspectManager.AspectItemEntry>> matchedAspects = AspectManager.getRegisteredItems();
            for (Map.Entry<AspectManager.AspectItem, List<AspectManager.AspectItemEntry>> e : matchedAspects.entrySet()) {
                if (e.getKey() == null || !new ItemStack(e.getKey().item, 1, e.getKey().damage).func_82833_r().toLowerCase().replace(" ", "").equals(page)) continue;
                ingredient = new ItemStack(e.getKey().item, 1, e.getKey().damage);
                break;
            }
            return ingredient != null && AspectManager.get(player.field_70170_p).getDiscoveredAspects(ingredient, container).size() > 0;
        }
        return player != null && page != null && ManualManager.getFoundPages(player, itemManual) != null && ManualManager.getFoundPages(player, itemManual).contains(page);
    }

    public static void playerDiscoverPage(EntityPlayer player, String name, Item itemManual) {
        if (!ManualManager.hasFoundPage(player, name, itemManual) && player != null && player.field_71071_by.func_146028_b(itemManual) && !player.field_70170_p.field_72995_K && ManualManager.findPage(player, name, itemManual)) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.manual.discover.page", new Object[]{new ChatComponentTranslation("manual." + name + ".title", new Object[0])}));
        }
    }

    public static void setCurrentPage(String category, int pageNumber, Item itemManual, EntityPlayer player) {
        if (player != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == itemManual && category != null) {
            if (player.func_70694_bm().field_77990_d == null) {
                player.func_70694_bm().field_77990_d = new NBTTagCompound();
            }
            player.func_70694_bm().field_77990_d.func_74768_a("pageNumber", pageNumber);
            player.func_70694_bm().field_77990_d.func_74778_a("category", category);
        }
    }

    public static int getCurrentPageNumber(Item itemManual, EntityPlayer player) {
        if ((player = player.field_70170_p.func_72890_a((Entity)player, 20.0)) != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == itemManual && player.func_70694_bm().field_77990_d != null && player.func_70694_bm().field_77990_d.func_74764_b("pageNumber")) {
            return player.func_70694_bm().field_77990_d.func_74762_e("pageNumber");
        }
        return 1;
    }

    public static ManualCategory getCurrentCategory(Item itemManual, EntityPlayer player) {
        if ((player = player.field_70170_p.func_72890_a((Entity)player, 20.0)) != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == itemManual) {
            NBTTagCompound nbt = player.func_70694_bm().func_77978_p();
            if (nbt != null && nbt.func_74764_b("category") && ManualManager.getCategoryFromString(nbt.func_74779_i("category"), itemManual) != null) {
                return ManualManager.getCategoryFromString(nbt.func_74779_i("category"), itemManual);
            }
            if (itemManual == BLItemRegistry.manualHL) {
                return HLEntryRegistry.aspectCategory;
            }
            return GuideBookEntryRegistry.itemsCategory;
        }
        return null;
    }

    public static ManualCategory getCategoryFromString(String categoryName, Item itemManual) {
        if (itemManual == BLItemRegistry.manualGuideBook && categoryName != null) {
            for (ManualCategory category : GuideBookEntryRegistry.CATEGORIES) {
                if (!category.getName().equals(categoryName)) continue;
                return category;
            }
        }
        if (itemManual == BLItemRegistry.manualHL && categoryName != null) {
            for (ManualCategory category : HLEntryRegistry.CATEGORIES) {
                if (!category.getName().equals(categoryName)) continue;
                return category;
            }
        }
        return null;
    }
}

