/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.GuiManualBase;
import thebetweenlands.manual.ManualManager;
import thebetweenlands.manual.Page;
import thebetweenlands.manual.PageCreators;
import thebetweenlands.manual.widgets.ManualWidgetsBase;

public class ManualCategory {
    private List<Page> pages = new ArrayList<Page>();
    private List<Page> visiblePages = new ArrayList<Page>();
    private LimitedList<Integer> lastPages = new LimitedList(100);
    private Page blankPage = new Page("blank", false, BLItemRegistry.manualGuideBook, new ManualWidgetsBase[0]);
    private Page currentPageLeft = null;
    private Page currentPageRight = null;
    private int currentPage = 1;
    private int indexPages = 0;
    private int number;
    private String name;

    public ManualCategory(ArrayList<Page> pages, int number, Item manualType, String name) {
        int pageNumber = 1;
        ArrayList<Page> buttonPages = new ArrayList<Page>();
        ArrayList<Page> tempPages = new ArrayList<Page>();
        for (Page page : pages) {
            page.setPageNumber(pageNumber);
            if (page.isParent) {
                buttonPages.add(page);
            }
            tempPages.add(page);
            page.setParentCategory(this);
            ++pageNumber;
        }
        ArrayList<Page> buttonPagesNew = PageCreators.pageCreatorButtons(buttonPages, manualType);
        this.indexPages = buttonPagesNew.size();
        this.pages.addAll(buttonPagesNew);
        this.pages.addAll(tempPages);
        this.number = number;
        this.name = name;
    }

    public ManualCategory(ArrayList<Page> pages, int number, Item manualType, String name, boolean customPageInitializing, int indexPages) {
        if (!customPageInitializing) {
            int pageNumber = 1;
            ArrayList<Page> buttonPages = new ArrayList<Page>();
            ArrayList<Page> tempPages = new ArrayList<Page>();
            for (Page page : pages) {
                page.setPageNumber(pageNumber);
                if (page.isParent) {
                    buttonPages.add(page);
                }
                tempPages.add(page);
                ++pageNumber;
            }
            ArrayList<Page> buttonPagesNew = PageCreators.pageCreatorButtons(buttonPages, manualType);
            this.pages.addAll(buttonPagesNew);
            this.pages.addAll(tempPages);
            this.indexPages = buttonPagesNew.size();
        } else {
            this.pages.addAll(pages);
            this.indexPages = indexPages;
        }
        this.number = number;
        this.name = name;
    }

    public void init(GuiManualBase manual, boolean force) {
        if (this.currentPageLeft == null || this.currentPageRight == null || force) {
            this.visiblePages.clear();
            for (Page page : this.pages) {
                if (page.isHidden && !ManualManager.hasFoundPage(manual.player, page.unlocalizedPageName, manual.manualType)) continue;
                this.visiblePages.add(page);
            }
            if (!this.visiblePages.isEmpty()) {
                this.currentPageLeft = this.visiblePages.get(0);
                this.currentPageRight = this.visiblePages.size() > 1 ? this.visiblePages.get(1) : this.blankPage;
                this.currentPageRight.setPageToRight();
            }
        }
        if (this.currentPageLeft != null) {
            this.currentPageLeft.init(manual);
        }
        if (this.currentPageRight != null) {
            this.currentPageRight.init(manual);
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getCategoryNumber() {
        return this.number;
    }

    public int getIndexPages() {
        return this.indexPages;
    }

    public String getName() {
        return this.name;
    }

    public List<Page> getVisiblePages() {
        return this.visiblePages;
    }

    public void setPage(int pageNumber, GuiManualBase manual) {
        if (this.currentPageLeft != null && this.currentPageRight != null) {
            this.lastPages.add(this.currentPage);
            if (pageNumber % 2 == 0) {
                --pageNumber;
            }
            if (pageNumber <= this.visiblePages.size()) {
                this.currentPageLeft = this.visiblePages.get(pageNumber - 1);
                this.currentPageRight = this.visiblePages.size() >= pageNumber + 1 ? this.visiblePages.get(pageNumber) : this.blankPage;
                this.currentPage = pageNumber;
            }
            this.currentPageLeft.init(manual);
            this.currentPageRight.init(manual);
            this.currentPageRight.setPageToRight();
            this.currentPageLeft.resize();
            this.currentPageRight.resize();
        }
    }

    public void nextPage(GuiManualBase manual) {
        if (this.currentPage + 2 <= this.visiblePages.size()) {
            this.setPage(this.currentPage + 2, manual);
        }
    }

    public void previousPage(GuiManualBase manual) {
        if (this.currentPage - 2 >= 1) {
            this.setPage(this.currentPage - 2, manual);
        }
    }

    public void previousOpenPage(GuiManualBase manual) {
        if (this.lastPages.size() > 0) {
            int prevPage = (Integer)this.lastPages.get(this.lastPages.size() - 1);
            this.lastPages.remove(this.lastPages.size() - 1);
            this.setPage(prevPage, manual);
            this.lastPages.remove(this.lastPages.size() - 1);
        }
    }

    public void draw(int mouseX, int mouseY) {
        if (this.currentPageLeft != null) {
            this.currentPageLeft.draw(mouseX, mouseY);
        }
        if (this.currentPageRight != null) {
            this.currentPageRight.draw(mouseX, mouseY);
        }
    }

    public void keyTyped(char c, int key) {
        if (this.currentPageLeft != null) {
            this.currentPageLeft.keyTyped(c, key);
        }
        if (this.currentPageRight != null) {
            this.currentPageRight.keyTyped(c, key);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        if (this.currentPageLeft != null) {
            this.currentPageLeft.mouseClicked(x, y, button);
        }
        if (this.currentPageRight != null) {
            this.currentPageRight.mouseClicked(x, y, button);
        }
    }

    public void updateScreen() {
        if (this.currentPageLeft != null) {
            this.currentPageLeft.updateScreen();
        }
        if (this.currentPageRight != null) {
            this.currentPageRight.updateScreen();
        }
    }

    class LimitedList<E>
    extends LinkedList<E> {
        private int limit;

        public LimitedList(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(E o) {
            boolean added = super.add(o);
            while (added && this.size() > this.limit) {
                super.remove();
            }
            return added;
        }
    }
}

