/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.manual;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.GuideBookEntryRegistry;
import thebetweenlands.manual.ManualCategory;
import thebetweenlands.manual.ManualManager;

public class GuiManualBase
extends GuiScreen {
    private static ResourceLocation book = new ResourceLocation("thebetweenlands:textures/gui/manual/manual.png");
    public int xStart;
    public int xStartRightPage;
    public int yStart;
    public int WIDTH = 292;
    public int HEIGHT = 180;
    public EntityPlayer player;
    public int untilUpdate = 0;
    public ManualCategory currentCategory;
    public Item manualType;

    public GuiManualBase(EntityPlayer player) {
        this.player = player;
    }

    public void func_73866_w_() {
        this.manualType = BLItemRegistry.manualGuideBook;
        this.xStart = this.field_146294_l / 2 - 146;
        this.xStartRightPage = this.xStart + 146;
        this.yStart = (this.field_146295_m - this.HEIGHT) / 2;
        this.untilUpdate = 0;
        this.changeCategory(ManualManager.getCurrentCategory(this.manualType, this.player), ManualManager.getCurrentPageNumber(this.manualType, this.player));
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
        ManualManager.setCurrentPage(this.currentCategory.getName(), this.currentCategory.getCurrentPage(), this.manualType, this.player);
        ManualManager.setCurrentPage(this.currentCategory.getName(), this.currentCategory.getCurrentPage(), this.manualType, this.player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73863_a(int mouseX, int mouseY, float renderPartials) {
        super.func_73863_a(mouseX, mouseY, renderPartials);
        this.field_146297_k.field_71446_o.func_110577_a(book);
        this.drawTexture(this.xStart, this.yStart, this.WIDTH, this.HEIGHT, 512.0, 512.0, 0.0, 292.0, 0.0, 180.0);
        if (this.currentCategory != null) {
            if (this.currentCategory.getCurrentPage() - 2 >= 1) {
                if (mouseX >= this.xStart + 15 && mouseX <= this.xStart + 15 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8) {
                    this.drawTexture(this.xStart + 15, this.yStart + 160, 19, 8, 512.0, 512.0, 292.0, 311.0, 9.0, 18.0);
                } else {
                    this.drawTexture(this.xStart + 15, this.yStart + 160, 19, 8, 512.0, 512.0, 292.0, 311.0, 0.0, 9.0);
                }
            }
            if (this.currentCategory.getCurrentPage() + 2 <= this.currentCategory.getVisiblePages().size()) {
                if (mouseX >= this.xStart + 256 && mouseX <= this.xStart + 256 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8) {
                    this.drawTexture(this.xStart + 256, this.yStart + 160, 19, 8, 512.0, 512.0, 311.0, 330.0, 9.0, 18.0);
                } else {
                    this.drawTexture(this.xStart + 256, this.yStart + 160, 19, 8, 512.0, 512.0, 311.0, 330.0, 0.0, 9.0);
                }
            }
            this.drawTexture(this.xStart, this.yStart + 10, 14, 22 * this.currentCategory.getCategoryNumber(), 512.0, 512.0, 293.0, 306.0, 18.0, 18.0 + 22.0 * (double)this.currentCategory.getCategoryNumber());
            this.drawTexture(this.xStart + 279, this.yStart + 10 + 22 * this.currentCategory.getCategoryNumber(), 14, 154 - 22 * this.currentCategory.getCategoryNumber(), 512.0, 512.0, 306.0, 293.0, 18.0 + 22.0 * (double)this.currentCategory.getCategoryNumber(), 174.0);
            this.currentCategory.draw(mouseX, mouseY);
        }
        this.renderPageNumbers(mouseX, mouseY, renderPartials);
    }

    protected void renderPageNumbers(int mouseX, int mouseY, float partialTicks) {
        if (this.currentCategory != null) {
            int leftPageStrWidth = this.field_146289_q.func_78256_a(String.valueOf(this.currentCategory.getCurrentPage()));
            GL11.glEnable((int)3042);
            this.field_146289_q.func_78276_b(String.valueOf(this.currentCategory.getCurrentPage()), this.xStart + this.WIDTH / 2 - 11 - leftPageStrWidth, this.yStart + this.HEIGHT - 17, -2142289132);
            this.field_146289_q.func_78276_b(String.valueOf(this.currentCategory.getCurrentPage() + 1), this.xStart + this.WIDTH / 2 + 11, this.yStart + this.HEIGHT - 17, -2142289132);
        }
    }

    public void drawTexture(int xStart, int yStart, int width, int height, double textureWidth, double textureHeight, double textureXStart, double textureXEnd, double textureYStart, double textureYEnd) {
        double umin = 1.0 / textureWidth * textureXStart;
        double umax = 1.0 / textureWidth * textureXEnd;
        double vmin = 1.0 / textureHeight * textureYStart;
        double vmax = 1.0 / textureHeight * textureYEnd;
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78374_a((double)xStart, (double)yStart, 0.0, umin, vmin);
        Tessellator.field_78398_a.func_78374_a((double)xStart, (double)(yStart + height), 0.0, umin, vmax);
        Tessellator.field_78398_a.func_78374_a((double)(xStart + width), (double)(yStart + height), 0.0, umax, vmax);
        Tessellator.field_78398_a.func_78374_a((double)(xStart + width), (double)yStart, 0.0, umax, vmin);
        Tessellator.field_78398_a.func_78381_a();
    }

    protected void func_73869_a(char c, int key) {
        switch (key) {
            case 1: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 14: {
                if (this.currentCategory == null) break;
                this.currentCategory.previousOpenPage(this);
            }
        }
        if (this.currentCategory != null) {
            GameSettings gameSettings = Minecraft.func_71410_x().field_71474_y;
            if (key == gameSettings.field_74370_x.func_151463_i()) {
                this.currentCategory.previousPage(this);
            } else if (key == gameSettings.field_74366_z.func_151463_i()) {
                this.currentCategory.nextPage(this);
            }
            this.currentCategory.keyTyped(c, key);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int mouseScroll = Mouse.getEventDWheel();
        if (mouseScroll != 0) {
            if (mouseScroll > 1) {
                this.currentCategory.nextPage(this);
            } else if (mouseScroll < -1) {
                this.currentCategory.previousPage(this);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) {
        if (this.currentCategory != null) {
            if (mouseX >= this.xStart + 15 && mouseX <= this.xStart + 15 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8 && button == 0) {
                this.currentCategory.previousPage(this);
            }
            if (mouseX >= this.xStart + 256 && mouseX <= this.xStart + 256 + 19 && mouseY >= this.yStart + 160 && mouseY <= this.yStart + 160 + 8 && button == 0) {
                this.currentCategory.nextPage(this);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 1 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 1 ? 0 : 279) + 14 && mouseY >= this.yStart + 11 && mouseY <= this.yStart + 10 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.itemsCategory);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 2 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 2 ? 0 : 279) + 14 && mouseY >= this.yStart + 33 && mouseY <= this.yStart + 32 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.machineCategory);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 3 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 3 ? 0 : 279) + 14 && mouseY >= this.yStart + 55 && mouseY <= this.yStart + 54 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.entitiesCategory);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 4 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 4 ? 0 : 279) + 14 && mouseY >= this.yStart + 77 && mouseY <= this.yStart + 76 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.category4);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 5 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 5 ? 0 : 279) + 14 && mouseY >= this.yStart + 99 && mouseY <= this.yStart + 98 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.category5);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 6 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 6 ? 0 : 279) + 14 && mouseY >= this.yStart + 121 && mouseY <= this.yStart + 120 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.category6);
            }
            if (mouseX >= this.xStart + (this.currentCategory.getCategoryNumber() >= 7 ? 0 : 279) && mouseX <= this.xStart + (this.currentCategory.getCategoryNumber() >= 7 ? 0 : 279) + 14 && mouseY >= this.yStart + 143 && mouseY <= this.yStart + 142 + 20 && button == 0) {
                this.changeCategory(GuideBookEntryRegistry.category7);
            }
            this.currentCategory.mouseClicked(mouseX, mouseY, button);
        }
    }

    public void changeTo(int pageNumber, boolean doMathWithIndexPages) {
        this.currentCategory.setPage(pageNumber + (doMathWithIndexPages ? this.currentCategory.getIndexPages() : 0), this);
    }

    public void changeCategory(ManualCategory category) {
        this.currentCategory = category;
        this.currentCategory.init(this, true);
        this.currentCategory.setPage(1, this);
    }

    public void changeCategory(ManualCategory category, int page) {
        this.currentCategory = category;
        this.currentCategory.init(this, false);
        this.currentCategory.setPage(page, this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_73876_c() {
        ++this.untilUpdate;
        if (this.currentCategory != null) {
            this.currentCategory.updateScreen();
        }
    }

    public boolean matches(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack2.func_77973_b() == itemStack1.func_77973_b() && itemStack2.func_77960_j() == itemStack1.func_77960_j();
    }
}

