/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.elixirs.ElixirRecipe;
import thebetweenlands.herblore.elixirs.ElixirRecipes;

public class ItemWeedwoodBucketInfusion
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLiquid;

    public ItemWeedwoodBucketInfusion() {
        this.func_77625_d(1);
        this.func_77655_b("thebetweenlands.weedwoodBucketInfusion");
        this.func_111206_d("thebetweenlands:weedwoodBucket");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        if (this.hasTag(stack)) {
            if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("infused") && stack.field_77990_d.func_74764_b("ingredients") && stack.field_77990_d.func_74764_b("infusionTime")) {
                int infusionTime = stack.field_77990_d.func_74762_e("infusionTime");
                String infusionTimeSeconds = BigDecimal.valueOf((float)infusionTime / 20.0f).setScale(1, 4).toPlainString();
                list.add(EnumChatFormatting.GREEN + "Infusion time: " + EnumChatFormatting.RESET + infusionTimeSeconds);
                list.add(EnumChatFormatting.GREEN + "Ingredients:");
                NBTTagList nbtList = (NBTTagList)stack.field_77990_d.func_74781_a("ingredients");
                LinkedHashMap stackMap = new LinkedHashMap();
                for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                    ItemStack ingredient = ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i));
                    boolean contained = false;
                    for (Map.Entry stackCount : stackMap.entrySet()) {
                        if (!ItemStack.func_77989_b((ItemStack)((ItemStack)stackCount.getKey()), (ItemStack)ingredient)) continue;
                        stackMap.put(stackCount.getKey(), (Integer)stackCount.getValue() + 1);
                        contained = true;
                    }
                    if (contained) continue;
                    stackMap.put(ingredient, 1);
                }
                for (Map.Entry stackCount : stackMap.entrySet()) {
                    ItemStack ingredient = (ItemStack)stackCount.getKey();
                    int count = (Integer)stackCount.getValue();
                    if (ingredient == null) continue;
                    list.add((count > 1 ? count + "x " : "") + ingredient.func_82833_r());
                    List<Aspect> ingredientAspects = AspectManager.get(TheBetweenlands.proxy.getClientWorld()).getDiscoveredAspects(ingredient, AspectManager.getMergedDiscoveryContainer(player));
                    if (ingredientAspects.size() < 1 || !Keyboard.isKeyDown((int)42)) continue;
                    for (Aspect aspect : ingredientAspects) {
                        list.add("  - " + aspect.type.getName() + " (" + aspect.getAmount() * (float)count + ")");
                    }
                }
            } else {
                list.add("This Infusion Contains Nothing");
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        stack.func_77982_d(new NBTTagCompound());
    }

    private boolean hasTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.iconLiquid = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/infusionLiquid");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 1 ? this.iconLiquid : super.func_77618_c(damage, pass);
    }

    public ElixirRecipe getInfusionElixirRecipe(ItemStack stack) {
        return ElixirRecipes.getFromAspects(this.getInfusingAspects(stack));
    }

    public List<IAspectType> getInfusingAspects(ItemStack stack) {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        if (this.hasTag(stack) && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("infused") && stack.field_77990_d.func_74764_b("ingredients") && stack.field_77990_d.func_74764_b("infusionTime")) {
            NBTTagList nbtList = (NBTTagList)stack.field_77990_d.func_74781_a("ingredients");
            LinkedHashMap stackMap = new LinkedHashMap();
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack ingredient = ItemStack.func_77949_a((NBTTagCompound)nbtList.func_150305_b(i));
                infusingAspects.addAll(AspectManager.get(TheBetweenlands.proxy.getClientWorld()).getDiscoveredAspectTypes(ingredient, null));
            }
        }
        return infusingAspects;
    }

    public int getInfusionTime(ItemStack stack) {
        if (this.hasTag(stack) && stack.field_77990_d != null && stack.field_77990_d.func_74764_b("infused") && stack.field_77990_d.func_74764_b("ingredients") && stack.field_77990_d.func_74764_b("infusionTime")) {
            int infusionTime = stack.field_77990_d.func_74762_e("infusionTime");
            return infusionTime;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass == 1) {
            ElixirRecipe recipe = this.getInfusionElixirRecipe(stack);
            int infusionTime = this.getInfusionTime(stack);
            if (recipe != null) {
                if (infusionTime > recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                    float[] failedColor = recipe.getRGBA(recipe.infusionFailedColor);
                    return this.getColorFromRGBA(failedColor[0], failedColor[1], failedColor[2], failedColor[3]);
                }
                if (infusionTime > recipe.idealInfusionTime - recipe.infusionTimeVariation && infusionTime < recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                    float[] finishedColor = recipe.getRGBA(recipe.infusionFinishedColor);
                    return this.getColorFromRGBA(finishedColor[0], finishedColor[1], finishedColor[2], finishedColor[3]);
                }
                float startR = 0.2f;
                float startG = 0.6f;
                float startB = 0.4f;
                float startA = 0.9f;
                float[] targetColor = recipe.getRGBA(recipe.infusionGradient);
                int targetTime = recipe.idealInfusionTime - recipe.infusionTimeVariation;
                float infusingPercentage = (float)infusionTime / (float)targetTime;
                float interpR = startR + (targetColor[0] - startR) * infusingPercentage;
                float interpG = startG + (targetColor[1] - startG) * infusingPercentage;
                float interpB = startB + (targetColor[2] - startB) * infusingPercentage;
                float interpA = startA + (targetColor[3] - startA) * infusingPercentage;
                return this.getColorFromRGBA(interpR, interpG, interpB, interpA);
            }
            return this.getColorFromRGBA(0.8f, 0.0f, 0.8f, 1.0f);
        }
        return -1;
    }

    private int getColorFromRGBA(float r, float g, float b, float a) {
        return (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
    }
}

