/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.tools;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidStack;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.tileentities.TileEntityInfuser;

public class ItemWeedwoodBucket
extends Item
implements IManualEntryItem {
    private final Block fluid;

    public ItemWeedwoodBucket() {
        this(Blocks.field_150350_a);
        this.func_77655_b("thebetweenlands.weedwoodBucket");
        this.func_111206_d("thebetweenlands:weedwoodBucket");
    }

    public ItemWeedwoodBucket(Block fluid) {
        this.fluid = fluid;
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean flag = this.fluid == Blocks.field_150350_a;
        MovingObjectPosition pos = this.func_77621_a(world, player, flag);
        if (pos == null) {
            return stack;
        }
        FillBucketEvent event = new FillBucketEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return stack;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.field_71075_bZ.field_75098_d) {
                return stack;
            }
            if (--stack.field_77994_a <= 0) {
                return event.result;
            }
            if (!player.field_71071_by.func_70441_a(event.result)) {
                player.func_71019_a(event.result, false);
            }
            return stack;
        }
        if (pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = pos.field_72311_b;
            int y = pos.field_72312_c;
            int z = pos.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return stack;
            }
            if (flag) {
                int i;
                int tz;
                int tx;
                if (!player.func_82247_a(x, y, z, pos.field_72310_e, stack)) {
                    return stack;
                }
                Block block = world.func_147439_a(x, y, z);
                int meta = world.func_72805_g(x, y, z);
                if (block == BLBlockRegistry.rubberTreeLog && meta == 1 && pos.field_72310_e >= 2 && !world.field_72995_K && world.func_147437_c(tx = x + (pos.field_72310_e == 4 ? -1 : (pos.field_72310_e == 5 ? 1 : 0)), y, tz = z + (pos.field_72310_e == 2 ? -1 : (pos.field_72310_e == 3 ? 1 : 0)))) {
                    ItemStack swampReedRopeItem = ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SWAMP_REED_ROPE);
                    boolean hasRope = player.field_71075_bZ.field_75098_d;
                    if (!hasRope && player.field_71071_by.func_70431_c(swampReedRopeItem)) {
                        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                            if (player.field_71071_by.field_70462_a[i] == null || !player.field_71071_by.field_70462_a[i].func_77969_a(swampReedRopeItem)) continue;
                            player.field_71071_by.func_70298_a(i, 1);
                            hasRope = true;
                            break;
                        }
                    }
                    if (hasRope) {
                        world.func_147465_d(tx, y, tz, (Block)BLBlockRegistry.rubberTap, 0, 0);
                        --stack.field_77994_a;
                        return stack;
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.bucket.needsrope", new Object[0]));
                    }
                }
                if (!world.field_72995_K && block == BLBlockRegistry.tarFluid && meta == 0) {
                    world.func_147468_f(x, y, z);
                    return this.addBucketToPlayer(stack, player, BLItemRegistry.weedwoodBucketTar);
                }
                if (!world.field_72995_K && !world.field_72995_K && block == BLBlockRegistry.swampWater && meta == 0) {
                    world.func_147468_f(x, y, z);
                    return this.addBucketToPlayer(stack, player, BLItemRegistry.weedwoodBucketWater);
                }
                if (!world.field_72995_K && block == BLBlockRegistry.infuser && player.func_70093_af()) {
                    TileEntityInfuser tile = (TileEntityInfuser)world.func_147438_o(x, y, z);
                    if (tile != null && !tile.hasInfusion() && tile.getWaterAmount() >= 1000) {
                        tile.extractFluids(new FluidStack(BLFluidRegistry.swampWater, 1000));
                        return this.addBucketToPlayer(stack, player, BLItemRegistry.weedwoodBucketWater);
                    }
                    if (tile != null && tile.hasInfusion() && tile.getWaterAmount() >= 1000) {
                        ItemStack infusionBucket = new ItemStack(BLItemRegistry.weedwoodBucketInfusion);
                        NBTTagCompound nbtCompound = new NBTTagCompound();
                        infusionBucket.func_77982_d(nbtCompound);
                        nbtCompound.func_74778_a("infused", "Infused");
                        NBTTagList nbtList = new NBTTagList();
                        for (i = 0; i < tile.func_70302_i_() - 1; ++i) {
                            ItemStack stackInSlot = tile.func_70301_a(i);
                            if (stackInSlot == null) continue;
                            nbtList.func_74742_a((NBTBase)stackInSlot.func_77955_b(new NBTTagCompound()));
                        }
                        nbtCompound.func_74782_a("ingredients", (NBTBase)nbtList);
                        nbtCompound.func_74768_a("infusionTime", tile.getInfusionTime());
                        tile.extractFluids(new FluidStack(BLFluidRegistry.swampWater, 1000));
                        return infusionBucket;
                    }
                    return stack;
                }
            } else {
                if (pos.field_72310_e == 0) {
                    --y;
                }
                if (pos.field_72310_e == 1) {
                    ++y;
                }
                if (pos.field_72310_e == 2) {
                    --z;
                }
                if (pos.field_72310_e == 3) {
                    ++z;
                }
                if (pos.field_72310_e == 4) {
                    --x;
                }
                if (pos.field_72310_e == 5) {
                    ++x;
                }
                if (!player.func_82247_a(x, y, z, pos.field_72310_e, stack)) {
                    return stack;
                }
                if (!world.field_72995_K && this.tryPlaceContainedLiquid(world, x, y, z) && !player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        return new ItemStack(BLItemRegistry.weedwoodBucket);
                    }
                    player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.weedwoodBucket));
                    return stack;
                }
            }
        }
        return stack;
    }

    private ItemStack addBucketToPlayer(ItemStack stack, EntityPlayer player, Item item) {
        if (player.field_71075_bZ.field_75098_d) {
            return stack;
        }
        if (--stack.field_77994_a <= 0) {
            return new ItemStack(item);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack(item))) {
            player.func_71019_a(new ItemStack(item), false);
        }
        return stack;
    }

    private boolean tryPlaceContainedLiquid(World world, int x, int y, int z) {
        boolean flag;
        if (this.fluid == Blocks.field_150350_a) {
            return false;
        }
        Material material = world.func_147439_a(x, y, z).func_149688_o();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_147437_c(x, y, z) && !flag) {
            return false;
        }
        if (world.field_73011_w.field_76575_d && this.fluid == BLBlockRegistry.tarFluid || world.field_73011_w.field_76575_d && this.fluid == BLBlockRegistry.swampWater) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_147480_a(x, y, z, true);
            }
            world.func_147465_d(x, y, z, this.fluid, 0, 3);
        }
        return true;
    }

    @Override
    public String manualName(int meta) {
        return "weedwoodBucket" + this.fluid.func_149732_F();
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{2};
    }

    @Override
    public int metas() {
        return 0;
    }
}

