/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.ICorrodible;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.utils.CorrodibleItemHelper;
import thebetweenlands.utils.IGemTextureProvider;

public class ItemSwordBL
extends ItemSword
implements ICorrodible,
IManualEntryItem,
IGemTextureProvider {
    private IIcon[] corrosionIcons;
    private String[] gemTextures = new String[CircleGem.TYPES.length];
    private IIcon[][] gemTextureIcons = new IIcon[CircleGem.TYPES.length][1];
    private float attackDamageWeaponModifier;

    public ItemSwordBL(Item.ToolMaterial material) {
        super(material);
        this.attackDamageWeaponModifier = 4.0f + material.func_78000_c();
        this.func_77637_a(null);
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase entity, EntityLivingBase player) {
        is.func_77972_a(1, player);
        if (is.func_77973_b() == BLItemRegistry.octineSword && player.field_70170_p.field_73012_v.nextInt(CircleGem.getGem(is) == CircleGem.CRIMSON ? 3 : 4) == 0) {
            entity.func_70015_d(10);
        }
        return true;
    }

    public IIcon func_77650_f(ItemStack stack) {
        int gemID;
        CircleGem gem = CircleGem.getGem(stack);
        if (gem != CircleGem.NONE && this.gemTextureIcons[gemID = gem.ordinal()][0] != null) {
            return this.gemTextureIcons[gemID][CorrodibleItemHelper.getCorrosionStage(stack)];
        }
        return this.corrosionIcons[CorrodibleItemHelper.getCorrosionStage(stack)];
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    @Override
    public IIcon[] getIcons() {
        ArrayList<IIcon> iconList = new ArrayList<IIcon>();
        iconList.add(this.field_77791_bV);
        for (int i = 0; i < this.gemTextureIcons.length; ++i) {
            IIcon gemTextureIcon = this.gemTextureIcons[i][0];
            if (gemTextureIcon == null) continue;
            iconList.add(gemTextureIcon);
        }
        return iconList.toArray(new IIcon[0]);
    }

    @Override
    public void setCorrosionIcons(IIcon[][] corrosionIcons) {
        this.corrosionIcons = corrosionIcons[0];
        for (int i = 0; i < this.gemTextureIcons.length; ++i) {
            IIcon gemTextureIcon = this.gemTextureIcons[i][0];
            if (gemTextureIcon == null) continue;
            this.gemTextureIcons[i] = corrosionIcons[i + 1];
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        for (int i = 0; i < this.gemTextures.length; ++i) {
            String gemTexture = this.gemTextures[i];
            if (gemTexture == null) continue;
            this.gemTextureIcons[i][0] = register.func_94245_a(gemTexture);
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrodibleItemHelper.onUpdate(itemStack, world, holder, slot, isHeldItem);
    }

    public Multimap getAttributeModifiers(ItemStack itemStack) {
        HashMultimap multimap = HashMultimap.create();
        AttributeModifier attributeModifier = new AttributeModifier(field_111210_e, "Weapon modifier", (double)(this.attackDamageWeaponModifier * CorrodibleItemHelper.getModifier(itemStack)), 0);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)attributeModifier);
        return multimap;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        CorrodibleItemHelper.addInformation(itemStack, player, lines, advancedItemTooltips);
    }

    @Override
    public String manualName(int meta) {
        return this.func_150932_j().toLowerCase() + "Sword";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{2};
    }

    @Override
    public int metas() {
        return 0;
    }

    @Override
    public ItemSwordBL setGemTextures(CircleGem gem, String ... texture) {
        this.gemTextures[gem.ordinal()] = texture[0];
        return this;
    }

    @Override
    public String[] getGemTextures(CircleGem gem) {
        return new String[]{this.gemTextures[gem.ordinal()]};
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack is, ItemStack book) {
        return false;
    }
}

