/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.misc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.world.feature.trees.WorldGenWeedWoodPortalTree;

public class ItemSwampTalisman
extends Item
implements IManualEntryItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public static ItemStack createStack(EnumTalisman swampTalisman, int size) {
        return new ItemStack(BLItemRegistry.swampTalisman, size, swampTalisman.ordinal());
    }

    public ItemSwampTalisman() {
        this.func_77656_e(0);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.func_77655_b("thebetweenlands.swampTalisman");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[EnumTalisman.VALUES.length];
        for (int i = 0; i < EnumTalisman.VALUES.length; ++i) {
            this.icons[i] = reg.func_94245_a("thebetweenlands:" + EnumTalisman.VALUES[i].iconName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return null;
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumTalisman.VALUES.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + stack.func_77960_j();
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int meta, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!player.func_82247_a(x, y, z, meta, is)) {
                return false;
            }
            if (is.func_77973_b().getDamage(is) == 0) {
                Block block = world.func_147439_a(x, y, z);
                if (block instanceof BlockSapling) {
                    if (new WorldGenWeedWoodPortalTree().func_76484_a(world, field_77697_d, x, y, z)) {
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thebetweenlands:portalActivate", 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                        int radius = 4;
                        int height = 16;
                        int maxRadius = 9;
                        AxisAlignedBB playerCheckArea = AxisAlignedBB.func_72330_a((double)(x - maxRadius), (double)y, (double)(z - maxRadius), (double)(x + maxRadius), (double)(y + height), (double)(z + maxRadius));
                        List players = world.func_72872_a(EntityPlayer.class, playerCheckArea);
                        for (EntityPlayer p : players) {
                            p.func_70078_a(null);
                            if (p instanceof EntityPlayerMP) {
                                EntityPlayerMP playerMP = (EntityPlayerMP)p;
                                playerMP.field_71135_a.func_147364_a((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
                                continue;
                            }
                            p.func_70012_b((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
                        }
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("talisman.noplace", new Object[0]));
                        return false;
                    }
                }
                is.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return false;
    }

    @Override
    public String manualName(int meta) {
        return "swampTalisman";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{7};
    }

    @Override
    public int metas() {
        return 4;
    }

    public static enum EnumTalisman {
        SWAMP_TALISMAN("swampTalisman"),
        SWAMP_TALISMAN_1("swampTalisman1"),
        SWAMP_TALISMAN_2("swampTalisman2"),
        SWAMP_TALISMAN_3("swampTalisman3"),
        SWAMP_TALISMAN_4("swampTalisman4");

        public final String iconName;
        public static final EnumTalisman[] VALUES;

        private EnumTalisman(String unlocName) {
            this.iconName = unlocName;
        }

        static {
            VALUES = EnumTalisman.values();
        }
    }
}

