/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.misc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.entities.EntityShockwaveBlock;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.tools.ItemSwordBL;
import thebetweenlands.utils.CorrodibleItemHelper;

public class ItemShockwaveSword
extends ItemSwordBL {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCharging;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconsChargingCorroded;

    public ItemShockwaveSword(Item.ToolMaterial material) {
        super(material);
        this.func_77655_b("thebetweenlands.shockwaveSword");
        this.func_111206_d("thebetweenlands:shockwaveSword");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        ItemShockwaveSword item = (ItemShockwaveSword)stack.func_77973_b();
        if (item == BLItemRegistry.shockwaveSword) {
            list.add(StatCollector.func_74838_a((String)"shockwaveSword.usage"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.iconCharging = reg.func_94245_a("thebetweenlands:shockwaveSwordDepleted");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.func_77978_p().func_74764_b("uses")) {
            stack.func_77978_p().func_74768_a("uses", 0);
        }
        if (stack.func_77978_p().func_74762_e("uses") == 3) {
            return this.iconsChargingCorroded[CorrodibleItemHelper.getCorrosionStage(stack)];
        }
        return super.func_77650_f(stack);
    }

    @Override
    public IIcon[] getIcons() {
        IIcon[] defaultIcons = super.getIcons();
        IIcon[] allIcons = new IIcon[defaultIcons.length + 1];
        System.arraycopy(defaultIcons, 0, allIcons, 0, defaultIcons.length);
        allIcons[allIcons.length - 1] = this.iconCharging;
        return allIcons;
    }

    @Override
    public void setCorrosionIcons(IIcon[][] corrosionIcons) {
        super.setCorrosionIcons(corrosionIcons);
        this.iconsChargingCorroded = corrosionIcons[corrosionIcons.length - 1];
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.func_77978_p().func_74764_b("cooldown")) {
            stack.func_77978_p().func_74768_a("cooldown", 0);
        }
        if (!stack.func_77978_p().func_74764_b("uses")) {
            stack.func_77978_p().func_74768_a("uses", 0);
        }
        if (stack.func_77978_p().func_74762_e("uses") == 3) {
            if (stack.func_77978_p().func_74762_e("cooldown") < 60) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") + 1);
            }
            if (stack.func_77978_p().func_74762_e("cooldown") >= 60) {
                stack.func_77978_p().func_74768_a("cooldown", 60);
                stack.func_77978_p().func_74768_a("uses", 0);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 1000;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
            return false;
        }
        if (side == 1 && player.func_70093_af() && !world.field_72995_K && stack.func_77978_p().func_74762_e("uses") < 3) {
            stack.func_77972_a(2, (EntityLivingBase)player);
            world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "thebetweenlands:shockwaveSword", 1.0f, 2.0f);
            double direction = Math.toRadians(player.field_70177_z);
            Vec3 diag = Vec3.func_72443_a((double)Math.sin(direction + 1.5707963267948966), (double)0.0, (double)Math.cos(direction + 1.5707963267948966)).func_72432_b();
            for (int distance = 1; distance < 16; ++distance) {
                for (int distance2 = -(distance - 2); distance2 < distance - 2; ++distance2) {
                    int originZ;
                    int originY;
                    int originX = MathHelper.func_76128_c((double)(player.field_70165_t - Math.sin(direction) * (double)distance - diag.field_72450_a * (double)distance2 * 0.25));
                    Block block = world.func_147439_a(originX, originY = y, originZ = MathHelper.func_76128_c((double)(player.field_70161_v + Math.cos(direction) * (double)distance + diag.field_72449_c * (double)distance2 * 0.25)));
                    if (block == null || !block.func_149721_r() || block.hasTileEntity(world.func_72805_g(originX, originY, originZ)) || !(block.func_149712_f(world, originX, originY, originZ) <= 5.0f) || !(block.func_149712_f(world, originX, originY, originZ) >= 0.0f) || !world.func_147437_c(originX, originY + 1, originZ) && !world.func_147439_a(originX, originY + 1, originZ).isReplaceable((IBlockAccess)world, originX, originY + 1, originZ)) continue;
                    stack.func_77978_p().func_74768_a("blockID", Block.func_149682_b((Block)world.func_147439_a(originX, originY, originZ)));
                    stack.func_77978_p().func_74768_a("blockMeta", world.func_72805_g(originX, originY, originZ));
                    EntityShockwaveBlock shockwaveBlock = new EntityShockwaveBlock(world);
                    shockwaveBlock.setOrigin(originX, originY, originZ, MathHelper.func_76128_c((double)Math.sqrt(distance * distance + distance2 * distance2)), player.field_70165_t, player.field_70161_v, (Entity)player);
                    shockwaveBlock.func_70012_b((double)originX + 0.5, originY, (double)originZ + 0.5, 0.0f, 0.0f);
                    shockwaveBlock.setBlock(Block.func_149729_e((int)stack.func_77978_p().func_74762_e("blockID")), stack.func_77978_p().func_74762_e("blockMeta"));
                    world.func_147468_f(originX, originY, originZ);
                    world.func_72838_d((Entity)shockwaveBlock);
                }
            }
            stack.func_77978_p().func_74768_a("uses", stack.func_77978_p().func_74762_e("uses") + 1);
            if (stack.func_77978_p().func_74762_e("uses") >= 3) {
                stack.func_77978_p().func_74768_a("uses", 3);
                stack.func_77978_p().func_74768_a("cooldown", 0);
            }
            return true;
        }
        return false;
    }
}

