/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.misc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.herblore.ItemGenericCrushed;
import thebetweenlands.items.herblore.ItemGenericPlantDrop;
import thebetweenlands.manual.IManualEntryItem;

public class ItemGeneric
extends Item
implements IManualEntryItem {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public static ItemStack createStack(EnumItemGeneric enumGeneric) {
        return ItemGeneric.createStack(enumGeneric, 1);
    }

    public static ItemStack createStack(EnumItemGeneric enumGeneric, int size) {
        return new ItemStack(BLItemRegistry.itemsGeneric, size, enumGeneric.id);
    }

    public static ItemStack createStack(Item item, int size, int meta) {
        return new ItemStack(item, size, meta);
    }

    public ItemGeneric() {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("thebetweenlands.unknownGeneric");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        EnumItemGeneric enumGeneric;
        int i;
        int maxID = 0;
        for (i = 0; i < EnumItemGeneric.VALUES.length; ++i) {
            int enumID;
            enumGeneric = EnumItemGeneric.VALUES[i];
            if (enumGeneric == EnumItemGeneric.INVALID || (enumID = enumGeneric.id) <= maxID) continue;
            maxID = enumID;
        }
        this.icons = new IIcon[maxID + 1];
        for (i = 0; i < EnumItemGeneric.VALUES.length; ++i) {
            enumGeneric = EnumItemGeneric.VALUES[i];
            if (enumGeneric == EnumItemGeneric.INVALID) continue;
            this.icons[enumGeneric.id] = reg.func_94245_a("thebetweenlands:" + enumGeneric.iconName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return null;
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < EnumItemGeneric.VALUES.length; ++i) {
            if (EnumItemGeneric.VALUES[i] == EnumItemGeneric.INVALID) continue;
            list.add(new ItemStack(item, 1, EnumItemGeneric.VALUES[i].id));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + ItemGeneric.getEnumFromID((int)stack.func_77960_j()).iconName;
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknownGeneric";
        }
    }

    public static EnumItemGeneric getEnumFromID(int id) {
        for (int i = 0; i < EnumItemGeneric.VALUES.length; ++i) {
            EnumItemGeneric enumGeneric = EnumItemGeneric.VALUES[i];
            if (enumGeneric.id != id) continue;
            return enumGeneric;
        }
        return EnumItemGeneric.INVALID;
    }

    public String func_77653_i(ItemStack stack) {
        List<Aspect> itemAspects;
        if (stack.func_77960_j() == EnumItemGeneric.ASPECTRUS_FRUIT.id && !(itemAspects = AspectManager.getDynamicAspects(stack)).isEmpty()) {
            Aspect aspect = itemAspects.get(0);
            return super.func_77653_i(stack) + " - " + aspect.type.getName() + " (" + aspect.getAmount() + ")";
        }
        return super.func_77653_i(stack);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block block;
        if (stack.func_77960_j() == ItemGeneric.createStack(EnumItemGeneric.SWAMP_REED).func_77960_j() && side == 1) {
            block = world.func_147439_a(x, y + 1, z);
            if (block == Blocks.field_150350_a) {
                if (BLBlockRegistry.swampReed.func_149742_c(world, x, y + 1, z)) {
                    if (!world.field_72995_K) {
                        world.func_147449_b(x, y + 1, z, (Block)BLBlockRegistry.swampReed);
                        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), BLBlockRegistry.swampReed.field_149762_H.func_150496_b(), (BLBlockRegistry.swampReed.field_149762_H.func_150497_c() + 1.0f) / 2.0f, BLBlockRegistry.swampReed.field_149762_H.func_150494_d() * 0.8f);
                        --stack.field_77994_a;
                    }
                    return true;
                }
            } else if (block == BLBlockRegistry.swampWater && BLBlockRegistry.swampReedUW.func_149742_c(world, x, y + 1, z)) {
                if (!world.field_72995_K) {
                    world.func_147449_b(x, y + 1, z, (Block)BLBlockRegistry.swampReedUW);
                    world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), BLBlockRegistry.swampReed.field_149762_H.func_150496_b(), (BLBlockRegistry.swampReed.field_149762_H.func_150497_c() + 1.0f) / 2.0f, BLBlockRegistry.swampReed.field_149762_H.func_150494_d() * 0.8f);
                    --stack.field_77994_a;
                }
                return true;
            }
        }
        if (stack.func_77960_j() == ItemGeneric.createStack(EnumItemGeneric.SWAMP_KELP).func_77960_j() && side == 1 && (block = world.func_147439_a(x, y + 1, z)) == BLBlockRegistry.swampWater && BLBlockRegistry.swampKelp.func_149742_c(world, x, y + 1, z)) {
            if (!world.field_72995_K) {
                world.func_147449_b(x, y + 1, z, (Block)BLBlockRegistry.swampKelp);
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), BLBlockRegistry.swampKelp.field_149762_H.func_150496_b(), (BLBlockRegistry.swampKelp.field_149762_H.func_150497_c() + 1.0f) / 2.0f, BLBlockRegistry.swampKelp.field_149762_H.func_150494_d() * 0.8f);
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77960_j() == EnumItemGeneric.TANGLED_ROOT.id) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        if (stack.func_77960_j() == EnumItemGeneric.OCTINE_INGOT.id) {
            Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.field_70170_p.field_72995_K ? 0.0f : player.func_70047_e())), (double)player.field_70161_v);
            Vec3 rayDir = player.func_70040_Z();
            Vec3 rayTraceEnd = playerPos.func_72441_c(rayDir.field_72450_a * 5.0, rayDir.field_72448_b * 5.0, rayDir.field_72449_c * 5.0);
            MovingObjectPosition pos = player.field_70170_p.func_72933_a(playerPos, rayTraceEnd);
            if (pos != null && pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                int bx = pos.field_72311_b + dir.offsetX;
                int by = pos.field_72312_c + dir.offsetY;
                int bz = pos.field_72309_d + dir.offsetZ;
                boolean hasTinder = false;
                boolean isBlockTinder = false;
                Block block = player.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (this.isTinder(block, null)) {
                    hasTinder = true;
                    isBlockTinder = true;
                } else {
                    List items = player.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)bx, (double)by, (double)bz, (double)(bx + 1), (double)(by + 1), (double)(bz + 1)));
                    for (EntityItem entityItem : items) {
                        ItemStack entityItemStack = entityItem.func_92059_d();
                        if (!this.isTinder(null, entityItemStack)) continue;
                        hasTinder = true;
                        break;
                    }
                }
                if ((hasTinder || isBlockTinder) && block != Blocks.field_150480_ab) {
                    player.func_71008_a(stack, this.func_77626_a(stack));
                }
            }
        }
        return stack;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.func_77960_j() == EnumItemGeneric.TANGLED_ROOT.id) {
            return EnumAction.eat;
        }
        if (stack.func_77960_j() == EnumItemGeneric.OCTINE_INGOT.id) {
            return EnumAction.bow;
        }
        return null;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        if (stack.func_77960_j() == EnumItemGeneric.OCTINE_INGOT.id) {
            Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.field_70170_p.field_72995_K ? 0.0f : player.func_70047_e())), (double)player.field_70161_v);
            Vec3 rayDir = player.func_70040_Z();
            Vec3 rayTraceEnd = playerPos.func_72441_c(rayDir.field_72450_a * 5.0, rayDir.field_72448_b * 5.0, rayDir.field_72449_c * 5.0);
            MovingObjectPosition pos = player.field_70170_p.func_72933_a(playerPos, rayTraceEnd);
            if (pos != null && pos.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)pos.field_72310_e);
                int bx = pos.field_72311_b + dir.offsetX;
                int by = pos.field_72312_c + dir.offsetY;
                int bz = pos.field_72309_d + dir.offsetZ;
                boolean hasTinder = false;
                boolean isBlockTinder = false;
                Block block = player.field_70170_p.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                if (this.isTinder(block, null)) {
                    hasTinder = true;
                    isBlockTinder = true;
                } else {
                    List items = player.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)bx, (double)by, (double)bz, (double)(bx + 1), (double)(by + 1), (double)(bz + 1)));
                    for (EntityItem entityItem : items) {
                        ItemStack entityItemStack = entityItem.func_92059_d();
                        if (!this.isTinder(null, entityItemStack)) continue;
                        hasTinder = true;
                        break;
                    }
                }
                if (hasTinder) {
                    if (player.field_70170_p.field_73012_v.nextInt(count / 10 + 1) == 0) {
                        player.field_70170_p.func_72869_a("flame", pos.field_72307_f.field_72450_a + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, pos.field_72307_f.field_72448_b + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, pos.field_72307_f.field_72449_c + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, 0.0, 0.1, 0.0);
                        player.field_70170_p.func_72869_a("smoke", pos.field_72307_f.field_72450_a + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, pos.field_72307_f.field_72448_b + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, pos.field_72307_f.field_72449_c + (double)player.field_70170_p.field_73012_v.nextFloat() * 0.2 - 0.1, 0.0, 0.1, 0.0);
                    }
                    if (!player.field_70170_p.field_72995_K && count == 1) {
                        if (isBlockTinder) {
                            player.field_70170_p.func_147449_b(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d, (Block)Blocks.field_150480_ab);
                        } else if (player.field_70170_p.func_147439_a(bx, by, bz).func_149688_o().func_76222_j()) {
                            player.field_70170_p.func_147449_b(bx, by, bz, (Block)Blocks.field_150480_ab);
                        }
                    }
                }
            }
        }
        super.onUsingTick(stack, player, count);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean debug) {
        if (stack.func_77960_j() == EnumItemGeneric.OCTINE_INGOT.id) {
            info.add(StatCollector.func_74838_a((String)"octine.fire"));
        }
        super.func_77624_a(stack, player, info, debug);
    }

    private boolean isTinder(Block block, ItemStack stack) {
        if (block != null) {
            return block == BLBlockRegistry.caveMoss || block == BLBlockRegistry.wallPlants || block == BLBlockRegistry.thorns;
        }
        if (stack != null) {
            if (stack.func_77973_b() instanceof ItemBlock) {
                ItemBlock itemBlock = (ItemBlock)stack.func_77973_b();
                return this.isTinder(itemBlock.field_150939_a, null);
            }
            return stack.func_77973_b() == BLItemRegistry.itemsGenericPlantDrop && (stack.func_77960_j() == ItemGenericPlantDrop.EnumItemPlantDrop.CAVE_MOSS.id || stack.func_77960_j() == ItemGenericPlantDrop.EnumItemPlantDrop.MOSS.id || stack.func_77960_j() == ItemGenericPlantDrop.EnumItemPlantDrop.LICHEN.id || stack.func_77960_j() == ItemGenericPlantDrop.EnumItemPlantDrop.THORNS.id) || stack.func_77973_b() == BLItemRegistry.itemsGenericCrushed && (stack.func_77960_j() == ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CAVE_MOSS.id || stack.func_77960_j() == ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MOSS.id || stack.func_77960_j() == ItemGenericCrushed.EnumItemGenericCrushed.GROUND_LICHEN.id || stack.func_77960_j() == ItemGenericCrushed.EnumItemGenericCrushed.GROUND_THORNS.id);
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77960_j() == EnumItemGeneric.TANGLED_ROOT.id) {
            --stack.field_77994_a;
            world.func_72956_a((Entity)player, "random.burp", 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(stack, world, player);
        }
        return stack;
    }

    protected void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            player.curePotionEffects(new ItemStack(Items.field_151117_aB));
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    @Override
    public String manualName(int meta) {
        return "genericItems";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{1, 2, 3, 5, 4, 6, 8};
    }

    @Override
    public int metas() {
        return 32;
    }

    public static enum EnumItemGeneric {
        INVALID("invalid", 1024),
        BLOOD_SNAIL_SHELL("bloodSnailShell", 3),
        MIRE_SNAIL_SHELL("mireSnailShell", 4),
        COMPOST("compost", 5),
        DRAGONFLY_WING("dragonflyWing", 6),
        LURKER_SKIN("lurkerSkin", 7),
        SWAMP_REED("swampReed", 8),
        DRIED_SWAMP_REED("driedSwampReed", 9),
        SWAMP_REED_ROPE("swampReedRope", 10),
        TANGLED_ROOT("tangledRoot", 11),
        PLANT_TONIC("plantTonic", 12),
        MUD_BRICK("mudBrick", 13),
        SYRMORITE_INGOT("syrmoriteIngot", 14),
        OCTINE_INGOT("octineIngot", 15),
        ROTTEN_BARK("rottenBark", 16),
        SLIMY_BONE("slimyBone", 17),
        SLUDGE_BALL("sludgeBall", 18),
        SNAPPER_ROOT("snapperRoot", 19),
        STALKER_EYE("stalkerEye", 20),
        SULFUR("sulfur", 21),
        VALONITE_SHARD("valoniteShard", 22),
        WEEDWOOD_STICK("weedWoodStick", 23),
        ANGLER_TOOTH("anglerTooth", 24),
        WEEDWOOD_BOWL("weedwoodBowl", 25),
        RUBBER_BALL("rubber", 26),
        TAR_BEAST_HEART("tarBeastHeart", 27),
        TAR_BEAST_HEART_ANIMATED("tarBeastHeartAnimated", 28),
        TAR_DRIP("tarDrip", 29),
        LIMESTONE_FLUX("limestoneFlux", 30),
        SWAMP_KELP("swampKelp", 31),
        INANIMATE_TARMINION("inanimateTarminion", 32),
        POISON_GLAND("poisonGland", 33),
        ASPECTRUS_FRUIT("aspectrusFruit", 34),
        PARCHMENT("parchment", 35),
        SHOCKWAVE_SWORD_1("shockwaveSword1", 36),
        SHOCKWAVE_SWORD_2("shockwaveSword2", 37),
        SHOCKWAVE_SWORD_3("shockwaveSword3", 38),
        SHOCKWAVE_SWORD_4("shockwaveSword4", 39),
        PYRAD_FLAME("pyradFlame", 40),
        AMULET_SOCKET("amuletSocket", 41),
        SCABYST("scabyst", 42);

        public final String iconName;
        public final int id;
        public static final EnumItemGeneric[] VALUES;

        private EnumItemGeneric(String unlocName, int id) {
            this.iconName = unlocName;
            this.id = id;
        }

        static {
            VALUES = EnumItemGeneric.values();
        }
    }
}

