/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.loot;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.items.IEquippable;

public abstract class ItemRing
extends Item
implements IEquippable {
    public ItemRing() {
        this.field_77777_bU = 1;
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77960_j() < stack.func_77958_k();
    }

    protected float getXPConversionRate(ItemStack stack, EntityPlayer player) {
        return 5.0f;
    }

    public void drainPower(ItemStack stack, Entity entity) {
        if (stack.func_77960_j() < stack.func_77958_k() && stack.func_77973_b() instanceof ItemRing && ((ItemRing)stack.func_77973_b()).isActive(stack)) {
            stack.func_77964_b(stack.func_77960_j() + 1);
        }
    }

    @Override
    public EnumEquipmentCategory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentCategory.RING;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && !player.func_70093_af() && stack.func_77960_j() > 0 && player.field_71067_cb > 0) {
            int repairPerClick = 40;
            float conversion = this.getXPConversionRate(stack, player);
            float requiredRepair = Math.min((float)repairPerClick, (float)stack.func_77960_j() / conversion);
            stack.func_77964_b(Math.max(0, stack.func_77960_j() - MathHelper.func_76123_f((float)((float)Math.min(repairPerClick, player.field_71067_cb) * conversion))));
            this.removeXp(player, MathHelper.func_76123_f((float)Math.min(requiredRepair, (float)player.field_71067_cb)));
        }
        return stack;
    }

    protected void removeXp(EntityPlayer player, int amount) {
        int newXP = Math.max(player.field_71067_cb - amount, 0);
        player.field_71067_cb = 0;
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        if (newXP > 0) {
            int xpCap = Integer.MAX_VALUE - player.field_71067_cb;
            if (newXP > xpCap) {
                newXP = xpCap;
            }
            player.field_71106_cc += (float)newXP / (float)player.func_71050_bK();
            player.field_71067_cb += newXP;
            while (player.field_71106_cc >= 1.0f) {
                player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
                ++player.field_71068_ca;
                player.field_71106_cc /= (float)player.func_71050_bK();
            }
        }
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        return entity instanceof EntityPlayer && inventory.getEquipment(EnumEquipmentCategory.RING).size() == 0;
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        return true;
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, EquipmentInventory inventory) {
        return true;
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, EquipmentInventory inventory) {
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, EquipmentInventory inventory) {
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        return stack.func_77960_j() == 0 || player.field_71067_cb == 0 || player.func_70093_af();
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity) {
        if (entity.field_70173_aa % 20 == 0) {
            this.drainPower(stack, entity);
        }
    }
}

