/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.herblore;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thebetweenlands.entities.projectiles.EntityElixir;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;
import thebetweenlands.herblore.elixirs.ElixirRecipe;
import thebetweenlands.herblore.elixirs.ElixirRecipes;
import thebetweenlands.herblore.elixirs.effects.ElixirEffect;
import thebetweenlands.items.BLItemRegistry;

public class ItemElixir
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLiquid;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVialOrange;
    private final List<ElixirEffect> effects = new ArrayList<ElixirEffect>();

    public ItemElixir() {
        this.func_77655_b("item.thebetweenlands.elixir");
        this.effects.addAll(ElixirEffectRegistry.getEffects());
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_111206_d("thebetweenlands:strictlyHerblore/misc/vialGreen");
    }

    private ElixirEffect getElixirByID(int id) {
        for (ElixirEffect effect : this.effects) {
            if (id != effect.getID()) continue;
            return effect;
        }
        return null;
    }

    private ElixirEffect getElixirFromItem(ItemStack stack) {
        return this.getElixirByID(stack.func_77960_j() / 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.iconLiquid = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/vialLiquid");
        this.iconVialOrange = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/vialOrange");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        ElixirRecipe recipe;
        ElixirEffect effect;
        if (pass == 0 && (effect = this.getElixirFromItem(stack)) != null && (recipe = ElixirRecipes.getFromEffect(effect)) != null) {
            return recipe.infusionFinishedColor;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 0 ? this.iconLiquid : super.func_77618_c(damage, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage % 2 == 0 ? this.field_77791_bV : this.iconVialOrange;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (ElixirEffect effect : this.effects) {
            list.add(new ItemStack(item, 1, effect.getID() * 2));
            list.add(new ItemStack(item, 1, effect.getID() * 2 + 1));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + this.getElixirFromItem(stack).getEffectName();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknown";
        }
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)this.getElixirFromItem(stack).getEffectName());
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("throwing") && stack.field_77990_d.func_74767_n("throwing")) {
            return EnumAction.bow;
        }
        return EnumAction.drink;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("throwing") && stack.field_77990_d.func_74767_n("throwing")) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (stack.field_77994_a <= 0) {
                    player.func_70062_b(0, null);
                }
            }
            world.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int useCount = this.func_77626_a(stack) - inUseCount;
                float strength = Math.min(0.4f + (float)useCount / 15.0f, 2.0f);
                world.func_72838_d((Entity)new EntityElixir(world, (EntityLivingBase)player, stack, strength));
            }
        }
    }

    public ItemStack getElixirItem(ElixirEffect effect, int duration, int strength, int vialType) {
        ItemStack elixirStack = new ItemStack((Item)this, 1, effect.getID() * 2 + vialType);
        NBTTagCompound elixirData = new NBTTagCompound();
        elixirData.func_74768_a("duration", duration);
        elixirData.func_74768_a("strength", strength);
        if (elixirStack.field_77990_d == null) {
            elixirStack.field_77990_d = new NBTTagCompound();
        }
        elixirStack.field_77990_d.func_74782_a("elixirData", (NBTBase)elixirData);
        return elixirStack;
    }

    public int func_77626_a(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("throwing") && stack.field_77990_d.func_74767_n("throwing")) {
            return 100000;
        }
        return 32;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74757_a("throwing", player.func_70093_af());
        player.func_71008_a(stack, this.func_77626_a(stack));
        return stack;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if (!world.field_72995_K) {
            ElixirEffect effect = this.getElixirFromItem(stack);
            int duration = this.getElixirDuration(stack);
            int strength = this.getElixirStrength(stack);
            player.func_70690_d(effect.createEffect(duration == -1 ? 1200 : duration, strength == -1 ? 0 : strength));
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (stack.field_77994_a <= 0) {
                return BLItemRegistry.dentrothystVial.createStack(stack.func_77960_j() % 2 == 0 ? 1 : 2);
            }
            player.field_71071_by.func_70441_a(BLItemRegistry.dentrothystVial.createStack(stack.func_77960_j() % 2 == 0 ? 1 : 2));
        }
        return stack;
    }

    public void applyEffect(ItemStack stack, EntityLivingBase entity, double modifier) {
        ElixirEffect effect = this.getElixirFromItem(stack);
        int strength = this.getElixirStrength(stack);
        int duration = this.getElixirDuration(stack);
        entity.func_70690_d(effect.createEffect(duration == -1 ? (int)(1200.0 * modifier) : (int)((double)duration * modifier), strength == -1 ? 0 : strength));
    }

    public int getElixirDuration(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("elixirData")) {
            NBTTagCompound elixirData = stack.field_77990_d.func_74775_l("elixirData");
            return elixirData.func_74762_e("duration");
        }
        return -1;
    }

    public int getElixirStrength(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("elixirData")) {
            NBTTagCompound elixirData = stack.field_77990_d.func_74775_l("elixirData");
            return elixirData.func_74762_e("strength");
        }
        return -1;
    }
}

