/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.herblore;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.event.render.AspectItemOverlayHandler;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.AspectRegistry;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityAspectVial;
import thebetweenlands.utils.AdvancedRecipeHelper;
import thebetweenlands.utils.AtlasIcon;
import thebetweenlands.utils.ColorUtils;

public class ItemAspectVial
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLiquid;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVialOrange;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] aspectIcons;

    public ItemAspectVial() {
        this.func_77655_b("item.thebetweenlands.aspectVial");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_111206_d("thebetweenlands:strictlyHerblore/misc/vialGreen");
        this.func_77642_a(BLItemRegistry.dentrothystVial);
    }

    public String func_77653_i(ItemStack stack) {
        List<Aspect> itemAspects = AspectManager.getDynamicAspects(stack);
        if (itemAspects.size() >= 1) {
            Aspect aspect = itemAspects.get(0);
            return super.func_77653_i(stack) + " - " + aspect.type.getName() + " (" + AspectItemOverlayHandler.ASPECT_AMOUNT_FORMAT.format(aspect.getAmount()) + ")";
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.iconLiquid = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/aspectLiquid");
        this.iconVialOrange = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/vialOrange");
        IIcon aspectIconAtlas = reg.func_94245_a("thebetweenlands:strictlyHerblore/misc/aspectMap");
        this.aspectIcons = new IIcon[AspectRegistry.ASPECT_TYPES.size()];
        for (IAspectType aspect : AspectRegistry.ASPECT_TYPES) {
            this.aspectIcons[aspect.getIconIndex()] = new AtlasIcon(aspectIconAtlas, aspect.getIconIndex(), 4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        switch (pass) {
            case 0: {
                List<Aspect> aspects = AspectManager.getDynamicAspects(stack);
                if (aspects.size() > 0) {
                    Aspect aspect = aspects.get(0);
                    float[] aspectRGBA = ColorUtils.getRGBA(aspect.type.getColor());
                    return ColorUtils.toHex(aspectRGBA[0], aspectRGBA[1], aspectRGBA[2], 1.0f);
                }
                return -1;
            }
            case 2: {
                return -1;
            }
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int pass) {
        return pass == 0 ? this.iconLiquid : super.func_77618_c(damage, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return damage % 2 == 0 ? this.field_77791_bV : this.iconVialOrange;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        List<Aspect> itemAspects;
        if (pass == 2 && (itemAspects = AspectManager.getDynamicAspects(stack)).size() >= 1) {
            Aspect aspect = itemAspects.get(0);
            return this.aspectIcons[aspect.type.getIconIndex()];
        }
        return super.getIcon(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        for (IAspectType aspect : AspectRegistry.ASPECT_TYPES) {
            Aspect itemAspect = new Aspect(aspect, 4.0f);
            ItemStack stackGreen = new ItemStack(item, 1, 0);
            AspectManager.addDynamicAspects(stackGreen, itemAspect);
            list.add(stackGreen);
            ItemStack stackOrange = new ItemStack(item, 1, 1);
            AspectManager.addDynamicAspects(stackOrange, itemAspect);
            list.add(stackOrange);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return Keyboard.isKeyDown((int)42) ? 3 : 2;
    }

    public String func_77667_c(ItemStack stack) {
        try {
            switch (stack.func_77960_j()) {
                case 0: {
                    return "item.thebetweenlands.aspectVial.green";
                }
                case 1: {
                    return "item.thebetweenlands.aspectVial.orange";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "item.thebetweenlands.unknown";
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack containerDefault;
        switch (itemStack.func_77960_j()) {
            default: {
                containerDefault = BLItemRegistry.dentrothystVial.createStack(0);
                break;
            }
            case 1: {
                containerDefault = BLItemRegistry.dentrothystVial.createStack(2);
            }
        }
        ItemStack containerRubberBoots = AdvancedRecipeHelper.getContainerItem(itemStack, null, "rubberBoots");
        ItemStack containerBait = AdvancedRecipeHelper.getContainerItem(itemStack, null, "bait");
        return containerRubberBoots != null ? containerRubberBoots : (containerBait != null ? containerBait : containerDefault);
    }

    public boolean func_77630_h(ItemStack itemStack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List lst, boolean debug) {
        if (!AspectManager.getDynamicAspects(stack).isEmpty() && AspectManager.getDynamicAspects((ItemStack)stack).get((int)0).type == AspectRegistry.BYARIIS) {
            lst.add(StatCollector.func_74838_a((String)"aspectvial.byariis.fuel"));
        }
    }

    public static void placeAspectVial(World world, int x, int y, int z, int vialType, Aspect aspect) {
        world.func_147465_d(x, y, z, BLBlockRegistry.vial, vialType, 2);
        TileEntityAspectVial tile = (TileEntityAspectVial)world.func_147438_o(x, y, z);
        if (tile != null) {
            tile.setAspect(aspect);
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return world.func_147439_a(x, y, z) == BLBlockRegistry.vial;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && AspectManager.getDynamicAspects(stack).size() == 1 && side == 1 && world.func_147437_c(x, y + 1, z)) {
            if (!world.field_72995_K) {
                ItemAspectVial.placeAspectVial(world, x, y + 1, z, stack.func_77960_j(), AspectManager.getDynamicAspects(stack).get(0));
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }
}

