/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.equipment;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import org.lwjgl.input.Keyboard;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesFlight;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.event.item.ItemTooltipHandler;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.loot.ItemRing;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.network.base.SubscribePacket;
import thebetweenlands.network.packet.client.PacketFlightState;

public class ItemRingOfFlight
extends ItemRing
implements IManualEntryItem {
    public ItemRingOfFlight() {
        this.func_77656_e(1800);
        this.func_77655_b("thebetweenlands.ringOfFlight");
        this.func_111206_d("thebetweenlands:ringOfFlight");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"ring.flight.bonus"));
        if (Keyboard.isKeyDown((int)42)) {
            String toolTip = StatCollector.func_74838_a((String)"item.thebetweenlands.ringOfFlight.tooltip");
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(StatCollector.func_74838_a((String)"item.thebetweenlands.press.shift"));
        }
    }

    @Override
    public String manualName(int meta) {
        return "ringOfFlight";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{6};
    }

    @Override
    public int metas() {
        return 0;
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity) {
        block17: {
            EntityPropertiesFlight props;
            EntityPlayer player;
            block18: {
                block19: {
                    if (!(entity instanceof EntityPlayer)) break block17;
                    player = (EntityPlayer)entity;
                    props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)player, EntityPropertiesFlight.class);
                    player.getEntityData().func_74757_a("thebetweenlands.hadFlightRing", true);
                    if (player.field_71075_bZ.field_75098_d || !this.canFly(player, stack)) break block18;
                    double flightHeight = 2.1;
                    if (player.field_70170_p.field_72995_K || props.isFlying()) {
                        player.field_71075_bZ.field_75101_c = true;
                    }
                    boolean isFlying = props.isFlying();
                    if (entity.field_70122_E) break block19;
                    if (!isFlying) break block17;
                    if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 20 == 0) {
                        this.removeXp((EntityPlayer)entity, 2);
                    }
                    if (entity.func_70093_af()) {
                        entity.field_70181_x = -0.2f;
                    } else {
                        double actualPosY = entity.field_70163_u + (entity == TheBetweenlands.proxy.getClientPlayer() ? -1.65 : 0.0);
                        double height = this.getGroundHeight(player);
                        Vec3 dir = Vec3.func_72443_a((double)entity.func_70040_Z().field_72450_a, (double)0.0, (double)entity.func_70040_Z().field_72449_c).func_72432_b();
                        if (player.field_70701_bs > 0.0f) {
                            entity.field_70159_w += dir.field_72450_a * (double)0.015f;
                            entity.field_70179_y += dir.field_72449_c * (double)0.015f;
                        }
                        double my = 0.0;
                        boolean moveUp = false;
                        if (player.field_70170_p.field_72995_K && player instanceof EntityPlayerSP) {
                            moveUp = ((EntityPlayerSP)player).field_71158_b.field_78901_c;
                        }
                        if (moveUp) {
                            my = 0.1;
                        }
                        double mul = height - (actualPosY - flightHeight);
                        entity.field_70181_x = my * mul;
                        if (actualPosY - flightHeight > height && entity.field_70181_x > 0.0) {
                            entity.field_70181_x = 0.0;
                        }
                        if (actualPosY - flightHeight > height) {
                            entity.field_70181_x = -Math.min(actualPosY - flightHeight - height, 2.0) / 8.0;
                        }
                    }
                    entity.field_70143_R = 0.0f;
                    if (!entity.field_70122_E && entity.field_70170_p.field_72995_K) {
                        if (props.flightTime > 40) {
                            BLParticle.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 1.0f, entity, Float.valueOf(0.0f));
                        } else {
                            for (int i = 0; i < 5; ++i) {
                                BLParticle.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 1.0f, entity, Float.valueOf(1.0f - ((float)props.flightTime + (float)i / 5.0f) / 40.0f));
                            }
                        }
                    }
                    break block17;
                }
                props.setFlying(false);
                break block17;
            }
            if (props.isFlying() && !player.field_70122_E && player.field_70170_p.field_72995_K) {
                if (props.flightTime > 40) {
                    BLParticle.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 1.0f, entity, Float.valueOf(0.0f));
                } else {
                    for (int i = 0; i < 5; ++i) {
                        BLParticle.LEAF_SWIRL.spawn(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 1.0f, entity, Float.valueOf(1.0f - ((float)props.flightTime + (float)i / 5.0f) / 40.0f));
                    }
                }
            }
        }
    }

    @SubscribePacket
    public static void onPacketEquipment(PacketFlightState packet) {
        EntityPlayerMP sender;
        if (packet.getContext().getServerHandler() != null && (sender = packet.getContext().getServerHandler().field_147369_b) != null) {
            EntityPropertiesFlight props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)sender, EntityPropertiesFlight.class);
            props.setFlying(packet.isFlying());
        }
    }

    private double getGroundHeight(EntityPlayer player) {
        double actualPosY = player.field_70163_u + (player == TheBetweenlands.proxy.getClientPlayer() ? -1.65 : 0.0);
        MovingObjectPosition result = player.field_70170_p.func_72901_a(Vec3.func_72443_a((double)player.field_70165_t, (double)actualPosY, (double)player.field_70161_v), Vec3.func_72443_a((double)player.field_70165_t, (double)(actualPosY - 64.0), (double)player.field_70161_v), true);
        if (result != null && result.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return result.field_72307_f.field_72448_b;
        }
        return -512.0;
    }

    public boolean canFly(EntityPlayer player, ItemStack stack) {
        return player.field_71075_bZ.field_75098_d || player.field_71067_cb > 0;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player != null) {
            EntityPlayer player = event.player;
            if (!player.field_71075_bZ.field_75098_d) {
                NBTTagCompound playerNBT;
                boolean hadFlightRing;
                EntityPropertiesFlight props = BLEntityPropertiesRegistry.HANDLER.getProperties((Entity)player, EntityPropertiesFlight.class);
                if (props.isFlying()) {
                    ++props.flightTime;
                }
                EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)player);
                boolean canPlayerFly = false;
                if (equipmentInventory != null) {
                    List<Equipment> rings = equipmentInventory.getEquipment(EnumEquipmentCategory.RING);
                    for (Equipment equipment : rings) {
                        if (equipment.item.func_77973_b() != BLItemRegistry.ringOfFlight || !((ItemRingOfFlight)equipment.item.func_77973_b()).canFly(player, equipment.item)) continue;
                        canPlayerFly = true;
                    }
                }
                if (canPlayerFly && player.field_70170_p.field_72995_K) {
                    if (event.phase == TickEvent.Phase.START) {
                        player.field_71075_bZ.field_75100_b = false;
                    } else if (player.field_71075_bZ.field_75100_b) {
                        props.setFlying(!props.isFlying());
                        if (player == TheBetweenlands.proxy.getClientPlayer()) {
                            TheBetweenlands.networkWrapper.sendToServer((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketFlightState(props.isFlying())));
                        }
                    }
                }
                if (player == TheBetweenlands.proxy.getClientPlayer() && player.field_70173_aa % 20 == 0) {
                    TheBetweenlands.networkWrapper.sendToServer((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketFlightState(props.isFlying())));
                }
                if (!(event.phase != TickEvent.Phase.END || canPlayerFly && props.isFlying() || !(hadFlightRing = (playerNBT = player.getEntityData()).func_74767_n("thebetweenlands.hadFlightRing")))) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75101_c = false;
                        if (player.field_70170_p.field_72995_K) {
                            player.field_71075_bZ.func_75092_a(0.05f);
                        }
                    }
                    playerNBT.func_74757_a("thebetweenlands.hadFlightRing", false);
                }
            }
        }
    }
}

