/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.equipment;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderLivingEvent;
import org.lwjgl.opengl.GL11;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.mobs.EntityGiantToad;
import thebetweenlands.entities.mobs.EntityTarminion;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesCircleGem;
import thebetweenlands.entities.properties.list.equipment.EnumEquipmentCategory;
import thebetweenlands.entities.properties.list.equipment.Equipment;
import thebetweenlands.entities.properties.list.equipment.EquipmentInventory;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.gemcircle.EntityGem;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.IEquippable;
import thebetweenlands.utils.ItemRenderHelper;
import thebetweenlands.utils.LightingUtil;

public class ItemAmulet
extends Item
implements IEquippable {
    public static final List<Class<? extends EntityLivingBase>> SUPPORTED_ENTITIES = new ArrayList<Class<? extends EntityLivingBase>>();
    private IIcon[] gemIcons = new IIcon[CircleGem.TYPES.length];

    public ItemAmulet() {
        this.func_77655_b("thebetweenlands.amulet");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_111206_d("thebetweenlands:emptyAmulet");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        for (int i = 0; i < CircleGem.TYPES.length; ++i) {
            CircleGem gem = CircleGem.TYPES[i];
            String texture = this.func_111208_A();
            switch (gem) {
                case CRIMSON: {
                    texture = "thebetweenlands:amuletCrimsonMiddleGem";
                    break;
                }
                case AQUA: {
                    texture = "thebetweenlands:amuletAquaMiddleGem";
                    break;
                }
                case GREEN: {
                    texture = "thebetweenlands:amuletGreenMiddleGem";
                    break;
                }
            }
            this.gemIcons[i] = register.func_94245_a(texture);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        CircleGem gem = CircleGem.getGem(stack);
        if (gem == CircleGem.NONE) {
            return this.field_77791_bV;
        }
        return this.gemIcons[gem.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public static ItemStack createStack(CircleGem gem) {
        ItemStack stack = new ItemStack(BLItemRegistry.amulet, 1, 0);
        CircleGem.setGem(stack, gem);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands.amulet." + CircleGem.getGem((ItemStack)stack).name;
        }
        catch (Exception e) {
            return "item.thebetweenlands.amulet.none";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (CircleGem gem : CircleGem.TYPES) {
            list.add(ItemAmulet.createStack(gem));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Specials.Post event) {
        if (event.entity != null) {
            GL11.glPushMatrix();
            if (event.entity == TheBetweenlands.proxy.getClientPlayer()) {
                GL11.glTranslated((double)0.0, (double)1.65, (double)0.0);
            }
            this.renderAmulet(event.entity, event.x, event.y, event.z, 0.0f);
            GL11.glPopMatrix();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAmulet(EntityLivingBase entity, double x, double y, double z, float partialTicks) {
        EquipmentInventory equipmentInventory = EquipmentInventory.getEquipmentInventory((Entity)entity);
        List<Equipment> equippedAmulets = equipmentInventory.getEquipment(EnumEquipmentCategory.AMULET);
        if (equippedAmulets.size() > 0) {
            int amulets = equippedAmulets.size();
            float degOffset = 360.0f / (float)amulets;
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            for (int i = 0; i < amulets; ++i) {
                GL11.glRotated((double)degOffset, (double)0.0, (double)1.0, (double)0.0);
                Equipment amuletEquipment = equippedAmulets.get(i);
                CircleGem gem = CircleGem.getGem(amuletEquipment.item);
                ItemStack gemItem = null;
                switch (gem) {
                    case CRIMSON: {
                        gemItem = new ItemStack((Item)BLItemRegistry.crimsonMiddleGem);
                        break;
                    }
                    case AQUA: {
                        gemItem = new ItemStack((Item)BLItemRegistry.aquaMiddleGem);
                        break;
                    }
                    case GREEN: {
                        gemItem = new ItemStack((Item)BLItemRegistry.greenMiddleGem);
                        break;
                    }
                }
                if (gemItem == null) continue;
                GL11.glPushMatrix();
                GL11.glRotated((double)((double)((float)entity.field_70173_aa + partialTicks) * 1.5), (double)0.0, (double)1.0, (double)0.0);
                double eyeHeight = entity.func_70047_e();
                if (entity == TheBetweenlands.proxy.getClientPlayer()) {
                    eyeHeight = -0.65;
                }
                GL11.glTranslated((double)0.0, (double)(eyeHeight / 1.5 + Math.sin((double)((float)entity.field_70173_aa + partialTicks) / 60.0 + (double)i / (double)amulets * Math.PI * 2.0) / 2.0 * (double)entity.field_70131_O / 4.0), (double)((double)entity.field_70130_N / 1.5));
                GL11.glScaled((double)((double)(0.25f * entity.field_70131_O) / 2.0), (double)((double)(0.25f * entity.field_70131_O) / 2.0), (double)((double)(0.25f * entity.field_70131_O) / 2.0));
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
                GL11.glBlendFunc((int)770, (int)771);
                LightingUtil.INSTANCE.setLighting(255);
                ItemRenderHelper.renderItem(gemItem, 0);
                LightingUtil.INSTANCE.revert();
                GL11.glBlendFunc((int)1, (int)1);
                float scale = ((float)Math.cos((float)entity.field_70173_aa / 5.0f) + 1.0f) / 15.0f + 1.05f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                ItemRenderHelper.renderItem(gemItem, 0);
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                ItemRenderHelper.renderItem(gemItem, 0);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    public static void addAmulet(CircleGem gem, Entity entity, boolean canUnequip, boolean canDrop) {
        ItemStack amulet = ItemAmulet.createStack(gem);
        if (amulet.field_77990_d == null) {
            amulet.field_77990_d = new NBTTagCompound();
        }
        amulet.field_77990_d.func_74757_a("canUnequip", canUnequip);
        amulet.field_77990_d.func_74757_a("canDrop", canDrop);
        EquipmentInventory.equipItem(null, entity, amulet);
    }

    @Override
    public EnumEquipmentCategory getEquipmentCategory(ItemStack stack) {
        return EnumEquipmentCategory.AMULET;
    }

    @Override
    public boolean canEquip(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        if (!(entity instanceof EntityPlayer)) {
            if (!SUPPORTED_ENTITIES.contains(entity.getClass()) && player != null) {
                return false;
            }
        }
        if (CircleGem.getGem(stack) == CircleGem.NONE) {
            return false;
        }
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        return property != null && inventory.getEquipment(EnumEquipmentCategory.AMULET).size() < property.getAmuletSlots();
    }

    @Override
    public boolean canUnequip(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        return entity == player || stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("canUnequip") || stack.field_77990_d.func_74767_n("canUnequip");
    }

    @Override
    public boolean canDrop(ItemStack stack, Entity entity, EquipmentInventory inventory) {
        return stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("canDrop") || stack.field_77990_d.func_74767_n("canDrop");
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, EquipmentInventory inventory) {
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        if (property != null) {
            property.addGem(CircleGem.getGem(stack), EntityGem.Type.BOTH);
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, EquipmentInventory inventory) {
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        if (property != null) {
            for (EntityGem gem : property.getGems()) {
                if (gem.getGem() != CircleGem.getGem(stack) || !gem.matches(EntityGem.Type.BOTH)) continue;
                property.removeGem(gem);
                break;
            }
        }
    }

    @Override
    public boolean canEquipOnRightClick(ItemStack stack, EntityPlayer player, Entity entity, EquipmentInventory inventory) {
        return true;
    }

    @Override
    public void onEquipmentTick(ItemStack stack, Entity entity) {
    }

    static {
        SUPPORTED_ENTITIES.add(EntityTarminion.class);
        SUPPORTED_ENTITIES.add(EntityGiantToad.class);
    }
}

