/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.bow;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import thebetweenlands.entities.projectiles.EntityBLArrow;
import thebetweenlands.items.ICorrodible;
import thebetweenlands.items.bow.EnumArrowType;
import thebetweenlands.items.bow.ItemBLArrow;
import thebetweenlands.manual.IManualEntryItem;
import thebetweenlands.utils.CorrodibleItemHelper;

public class ItemWeedwoodBow
extends ItemBow
implements ICorrodible,
IManualEntryItem {
    public static final int ANIMATION_LENGTH = 3;
    private IIcon[] iconArray;
    private IIcon[][] corrosionIcons;

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(this.field_111218_cA);
        this.iconArray = new IIcon[4];
        this.iconArray[0] = this.field_77791_bV;
        for (int iconIndex = 1; iconIndex < this.iconArray.length; ++iconIndex) {
            this.iconArray[iconIndex] = icon.func_94245_a(this.field_111218_cA + (iconIndex - 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (usingItem != null) {
            int time = 36000 - useRemaining;
            return this.corrosionIcons[time < 6 ? 1 : (time < 10 ? 2 : 3)][CorrodibleItemHelper.getCorrosionStage(usingItem)];
        }
        return this.corrosionIcons[0][CorrodibleItemHelper.getCorrosionStage(stack)];
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.corrosionIcons[0][CorrodibleItemHelper.getCorrosionStage(stack)];
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 100000;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        int maxUseDuration = this.func_77626_a(stack) - inUseCount;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, maxUseDuration);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        maxUseDuration = Math.min(event.charge, 10);
        boolean canShoot = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        EnumArrowType type = null;
        ItemBLArrow arrowItem = null;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack currentStack = player.field_71071_by.field_70462_a[i];
            if (currentStack == null || !(currentStack.func_77973_b() instanceof ItemBLArrow)) continue;
            arrowItem = (ItemBLArrow)currentStack.func_77973_b();
            type = arrowItem.getType();
            break;
        }
        if (canShoot || type != null) {
            int punchEnchant;
            int powerEnchant;
            float power = (float)maxUseDuration / 10.0f;
            power = (power * power + power * 2.0f) / 2.0f;
            if ((power *= CorrodibleItemHelper.getModifier(stack) * 1.15f) < 0.1f) {
                return;
            }
            if (power > 1.0f) {
                power = 1.0f;
            }
            EntityBLArrow entityarrow = new EntityBLArrow(world, (EntityLivingBase)player, power * 2.0f);
            if (!world.field_72995_K) {
                entityarrow.setArrowType(type != null ? type : EnumArrowType.DEFAULT);
            }
            if (power == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            if ((powerEnchant = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerEnchant * 0.5 + 0.5);
            }
            if ((punchEnchant = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(punchEnchant);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
            if (player.field_71075_bZ.field_75098_d) {
                entityarrow.field_70251_a = 2;
            } else if (arrowItem != null) {
                player.field_71071_by.func_146026_a((Item)arrowItem);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        ArrowNockEvent event = new ArrowNockEvent(player, item);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        EnumArrowType type = null;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack currentStack = player.field_71071_by.field_70462_a[i];
            if (currentStack == null || !(currentStack.func_77973_b() instanceof ItemBLArrow)) continue;
            type = ((ItemBLArrow)currentStack.func_77973_b()).getType();
            break;
        }
        if (player.field_71075_bZ.field_75098_d || type != null) {
            player.func_71008_a(item, this.func_77626_a(item));
        }
        return item;
    }

    @Override
    public IIcon[] getIcons() {
        return this.iconArray;
    }

    @Override
    public void setCorrosionIcons(IIcon[][] corrosionIcons) {
        this.corrosionIcons = corrosionIcons;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity holder, int slot, boolean isHeldItem) {
        CorrodibleItemHelper.onUpdate(itemStack, world, holder, slot, isHeldItem);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List lines, boolean advancedItemTooltips) {
        CorrodibleItemHelper.addInformation(itemStack, player, lines, advancedItemTooltips);
    }

    @Override
    public String manualName(int meta) {
        return "weedwoodBow";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{2};
    }

    @Override
    public int metas() {
        return 0;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack is, ItemStack book) {
        return false;
    }
}

