/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.armor;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.BLMaterial;
import thebetweenlands.items.armor.ItemArmorBL;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.manual.IManualEntryItem;

public class ItemLurkerSkinArmor
extends ItemArmorBL
implements IManualEntryItem {
    public ItemLurkerSkinArmor(int armorType) {
        super(BLMaterial.armorLurkerSkin, 2, armorType, "thebetweenlands:textures/armour/lurker1.png", "thebetweenlands:textures/armour/lurker2.png");
        String itemTexture;
        switch (armorType) {
            default: {
                itemTexture = "thebetweenlands:lurkerSkinHelmet";
                break;
            }
            case 1: {
                itemTexture = "thebetweenlands:lurkerSkinChestplate";
                break;
            }
            case 2: {
                itemTexture = "thebetweenlands:lurkerSkinLeggings";
                break;
            }
            case 3: {
                itemTexture = "thebetweenlands:lurkerSkinBoots";
            }
        }
        this.func_111206_d(itemTexture);
        this.setGemTextures(CircleGem.AQUA, itemTexture + "AquaGem", "thebetweenlands:textures/armour/lurker1AquaGem.png", "thebetweenlands:textures/armour/lurker2AquaGem.png");
        this.setGemTextures(CircleGem.CRIMSON, itemTexture + "CrimsonGem", "thebetweenlands:textures/armour/lurker1CrimsonGem.png", "thebetweenlands:textures/armour/lurker2CrimsonGem.png");
        this.setGemTextures(CircleGem.GREEN, itemTexture + "GreenGem", "thebetweenlands:textures/armour/lurker1GreenGem.png", "thebetweenlands:textures/armour/lurker2GreenGem.png");
    }

    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return material.func_77973_b() == BLItemRegistry.itemsGeneric && material.func_77960_j() == ItemGeneric.EnumItemGeneric.LURKER_SKIN.id;
    }

    @Override
    protected boolean isLeggings(ItemStack stack) {
        return stack.func_77973_b() == BLItemRegistry.lurkerSkinLeggings;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        int armorPieces = 0;
        for (ItemStack anArmor : armor) {
            if (anArmor == null || !(anArmor.func_77973_b() instanceof ItemLurkerSkinArmor)) continue;
            ++armorPieces;
        }
        if (itemStack.func_77973_b() == BLItemRegistry.lurkerSkinBoots && player.func_70090_H()) {
            boolean fullyInWater = player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)(player.field_70121_D.field_72337_e + 0.1), (int)player.field_70161_v).func_149688_o().func_76224_d();
            if (fullyInWater) {
                if (!player.func_70093_af() && player.field_70701_bs == 0.0f) {
                    player.field_70181_x = Math.sin((float)player.field_70173_aa / 5.0f) * 0.016;
                }
                if (player.field_70701_bs != 0.0f) {
                    if (player.field_70701_bs > 0.0f) {
                        Vec3 lookVec = player.func_70040_Z().func_72432_b();
                        double speed = 0.01 + 0.0125 * (double)armorPieces;
                        player.field_70159_w += lookVec.field_72450_a * (double)player.field_70701_bs * speed;
                        player.field_70179_y += lookVec.field_72449_c * (double)player.field_70701_bs * speed;
                        player.field_70181_x += lookVec.field_72448_b * (double)player.field_70701_bs * speed;
                        player.func_71024_bL().func_75113_a(0.003f);
                    }
                    player.field_70181_x += 0.02;
                }
            }
            if (armorPieces >= 4) {
                if (!player.func_70644_a(Potion.field_76427_o)) {
                    player.func_70690_d(new PotionEffect(Potion.field_76427_o.field_76415_H, 0));
                }
                if (player.field_70173_aa % 3 == 0) {
                    player.func_70050_g(player.func_70086_ai() - 1);
                }
                if (player.func_70086_ai() <= -20) {
                    player.func_70050_g(0);
                    for (int i = 0; i < 8; ++i) {
                        Random rand = world.field_73012_v;
                        float f = rand.nextFloat() - rand.nextFloat();
                        float f1 = rand.nextFloat() - rand.nextFloat();
                        float f2 = rand.nextFloat() - rand.nextFloat();
                        player.field_70170_p.func_72869_a("bubble", player.field_70165_t + (double)f, player.field_70163_u + (double)f1, player.field_70161_v + (double)f2, player.field_70159_w, player.field_70181_x, player.field_70179_y);
                    }
                    player.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            }
        }
    }

    @Override
    public String manualName(int meta) {
        return "lurkerArmor";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{2};
    }

    @Override
    public int metas() {
        return 0;
    }
}

