/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.armor;

import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.armor.ItemRubberBoots;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.manual.IManualEntryItem;

public class ItemImprovedRubberBoots
extends ItemRubberBoots
implements IManualEntryItem {
    private static final int MAX_WALK_TICKS = 20;

    @Override
    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return material.func_77973_b() == BLItemRegistry.itemsGeneric && material.func_77960_j() == ItemGeneric.EnumItemGeneric.RUBBER_BALL.id;
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        itemStack.field_77990_d = new NBTTagCompound();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        boolean playerOnGround;
        if (world.field_72995_K) {
            if (itemStack.field_77990_d != null) {
                int walkTicksLeft = itemStack.field_77990_d.func_74762_e("walkTicksLeft");
                if (player.field_70122_E && world.func_147439_a((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u) - 2, (int)Math.floor(player.field_70161_v)) == BLBlockRegistry.swampWater) {
                    player.field_70159_w *= 0.05 * (double)walkTicksLeft;
                    player.field_70179_y *= 0.05 * (double)walkTicksLeft;
                }
            }
            return;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        int walkTicksLeft = itemStack.field_77990_d.func_74762_e("walkTicksLeft");
        Block blockBelowPlayer = world.func_147439_a((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
        Block blockBelowPlayer2 = world.func_147439_a((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u) - 1, (int)Math.floor(player.field_70161_v));
        boolean bl = playerOnGround = player.field_70122_E && !player.func_70090_H() && blockBelowPlayer != BLBlockRegistry.swampWater && blockBelowPlayer2 != BLBlockRegistry.swampWater;
        if (walkTicksLeft == 0 || playerOnGround) {
            itemStack.field_77990_d.func_74768_a("walkTicksLeft", 20);
        } else if (walkTicksLeft > 1) {
            itemStack.field_77990_d.func_74768_a("walkTicksLeft", --walkTicksLeft);
        }
    }

    public static boolean checkPlayerEffect(EntityPlayer player) {
        if (ElixirEffectRegistry.EFFECT_HEAVYWEIGHT.isActive((EntityLivingBase)player)) {
            return false;
        }
        ItemStack boots = player.field_71071_by.field_70460_b[0];
        return boots != null && boots.func_77973_b() instanceof ItemImprovedRubberBoots && boots.field_77990_d != null && boots.field_77990_d.func_74762_e("walkTicksLeft") > 1;
    }

    public static double getWalkPercentage(EntityPlayer player) {
        ItemStack boots = player.field_71071_by.field_70460_b[0];
        if (boots != null && boots.func_77973_b() instanceof ItemImprovedRubberBoots && boots.field_77990_d != null) {
            return (double)boots.field_77990_d.func_74762_e("walkTicksLeft") / 20.0;
        }
        return 0.0;
    }

    @Override
    public String manualName(int meta) {
        return "improvedRubberBoots";
    }

    @Override
    public Item getItem() {
        return this;
    }

    @Override
    public int[] recipeType(int meta) {
        return new int[]{2};
    }

    @Override
    public int metas() {
        return 0;
    }
}

