/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.items.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import thebetweenlands.gemcircle.CircleGem;
import thebetweenlands.utils.IGemTextureProvider;

public class ItemArmorBL
extends ItemArmor
implements IGemTextureProvider {
    public final String armorTexture1;
    public final String armorTexture2;
    private IIcon[] gemItemIcons = new IIcon[CircleGem.TYPES.length];
    private String[][] gemTextures = new String[CircleGem.TYPES.length][0];

    public ItemArmorBL(ItemArmor.ArmorMaterial material, int renderIndex, int armorType, String armorTexture1, String armorTexture2) {
        super(material, renderIndex, armorType);
        this.armorTexture1 = armorTexture1;
        this.armorTexture2 = armorTexture2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        for (int i = 0; i < this.gemTextures.length; ++i) {
            if (this.gemTextures[i].length <= 2 || this.gemTextures[i][0] == null) continue;
            this.gemItemIcons[i] = register.func_94245_a(this.gemTextures[i][0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        CircleGem gem = CircleGem.getGem(stack);
        if (gem != CircleGem.NONE && this.gemTextures[gem.ordinal()].length > 2 && this.gemTextures[gem.ordinal()][0] != null) {
            return this.gemItemIcons[gem.ordinal()];
        }
        return super.func_77650_f(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity event, int slot, String type) {
        CircleGem gem = CircleGem.getGem(stack);
        if (this.isLeggings(stack)) {
            if (gem != CircleGem.NONE) {
                if (this.gemTextures[gem.ordinal()].length >= 3) {
                    return this.gemTextures[gem.ordinal()][2];
                }
                return this.gemTextures[gem.ordinal()][1];
            }
            if (this.armorTexture2 != null) {
                return this.armorTexture2;
            }
            return this.armorTexture1;
        }
        if (gem != CircleGem.NONE) {
            if (this.gemTextures[gem.ordinal()].length >= 3) {
                return this.gemTextures[gem.ordinal()][1];
            }
            return this.gemTextures[gem.ordinal()][0];
        }
        return this.armorTexture1;
    }

    protected boolean isLeggings(ItemStack stack) {
        return false;
    }

    @Override
    public ItemArmorBL setGemTextures(CircleGem gem, String ... textures) {
        this.gemTextures[gem.ordinal()] = textures;
        return this;
    }

    @Override
    public String[] getGemTextures(CircleGem gem) {
        return this.gemTextures[gem.ordinal()];
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack is, ItemStack book) {
        return false;
    }
}

