/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.inventory.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.inventory.container.ContainerAnimator;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.recipes.misc.AnimatorRecipe;
import thebetweenlands.tileentities.TileEntityAnimator;

@SideOnly(value=Side.CLIENT)
public class GuiAnimator
extends GuiContainer {
    private final ResourceLocation GUI_ANIMATOR = new ResourceLocation("thebetweenlands:textures/gui/animator.png");
    private final TileEntityAnimator tile;
    private EntityPlayer playerSent;
    private int updateTicks = 0;

    public GuiAnimator(EntityPlayer player, TileEntityAnimator tile) {
        super((Container)new ContainerAnimator(player.field_71071_by, tile));
        this.tile = tile;
        this.field_146291_p = false;
        this.field_146999_f = 174;
        this.field_147000_g = 164;
        this.playerSent = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    protected void func_146979_b(int x, int y) {
    }

    protected void func_146976_a(float partialTickTime, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.GUI_ANIMATOR);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.tile.isCrystalInslot()) {
            int lifeCrystalCount = 40 - this.tile.lifeCrystalLife / 3;
            this.func_73729_b(k + 39, l + 8 + lifeCrystalCount, 175, 2 + lifeCrystalCount, 6, 42);
            if (this.tile.isValidFocalItem()) {
                int requiredLifeCrystal = this.tile.requiredLifeCount / 3;
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)0.1f, (float)0.1f, (float)(0.35f + (float)(Math.cos(((float)this.updateTicks + partialTickTime) / 10.0f) + 1.0) / 2.0f * 0.65f));
                this.func_73729_b(k + 39, l + 8 + lifeCrystalCount, 175, 2 + lifeCrystalCount, 6, requiredLifeCrystal);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
            }
        }
        if (this.tile.isSlotInUse(0) && this.tile.isCrystalInslot() && this.tile.isSulfurInslot() && this.tile.fuelConsumed < this.tile.requiredFuelCount && this.tile.lifeCrystalLife >= this.tile.requiredLifeCount && this.tile.isValidFocalItem()) {
            int fuelBurnProgress = this.tile.fuelBurnProgress;
            this.func_73729_b(k + 129, l + 8 + fuelBurnProgress, 175, 2 + fuelBurnProgress, 6, 42);
            double relTotalProgress = ((double)this.tile.fuelConsumed + (double)this.tile.fuelBurnProgress / 42.0) / (double)this.tile.requiredFuelCount;
            if (relTotalProgress <= 0.5) {
                int barWidth = (int)(relTotalProgress * 32.0);
                this.func_73729_b(k + 51, l + 65, 182, 18, barWidth * 2, 2);
                this.func_73729_b(k + 123 - barWidth * 2, l + 65, 254 - barWidth * 2, 18, barWidth * 2, 2);
            }
            if (relTotalProgress > 0.5 && relTotalProgress <= 1.0) {
                int barHeight = (int)(relTotalProgress * 32.0);
                this.func_73729_b(k + 51, l + 65 - barHeight + 16, 182, 18 - barHeight + 16, 72, 2 + barHeight - 16);
            }
        }
        if (this.tile.func_70301_a(1) == null) {
            this.renderSlot(ItemGeneric.createStack(BLItemRegistry.lifeCrystal, 1, 0).func_77954_c(), 34, 57);
        }
        if (this.tile.func_70301_a(2) == null) {
            this.renderSlot(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SULFUR).func_77954_c(), 124, 57);
        }
    }

    private void renderSlot(IIcon icon, int iconX, int iconY) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110576_c);
        this.func_94065_a(this.field_147003_i + iconX, this.field_147009_r + iconY, icon, 16, 16);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public void func_73876_c() {
        AnimatorRecipe recipe;
        super.func_73876_c();
        boolean shouldClose = false;
        ItemStack input = this.tile.func_70301_a(0);
        if (input != null && (recipe = AnimatorRecipe.getRecipe(input)) != null) {
            shouldClose = recipe.getCloseOnFinish();
        }
        if (this.tile.itemAnimated && shouldClose) {
            this.playerSent.func_71053_j();
        }
        ++this.updateTicks;
    }
}

