/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.elixirs.effects;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import thebetweenlands.manual.widgets.text.TextContainer;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class ElixirEffect {
    private final String effectName;
    private final int effectID;
    private final ResourceLocation icon;
    private final int color;
    private List<ElixirAttributeModifier> elixirAttributeModifiers = new ArrayList<ElixirAttributeModifier>();
    private ElixirPotionEffect potionEffect;
    private int potionID;
    private boolean isAntiInfusion = false;

    public ElixirEffect(int id, String name) {
        this(id, name, null, 0);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon) {
        this(id, name, icon, 0);
    }

    public ElixirEffect(int id, String name, int color) {
        this(id, name, null, color);
    }

    public ElixirEffect(int id, String name, ResourceLocation icon, int color) {
        this.effectID = id;
        this.effectName = name;
        this.icon = icon;
        this.color = color;
    }

    public PotionEffect createEffect(int duration, int strength) {
        return new PotionEffect(this.potionID, duration, strength);
    }

    public void registerPotion() {
        this.potionID = ConfigHandler.potionIDs.get(this.getID());
        this.potionEffect = new ElixirPotionEffect(this, this.effectName, this.color, this.icon);
        for (ElixirAttributeModifier modifier : this.elixirAttributeModifiers) {
            this.potionEffect.func_111184_a(modifier.attribute, modifier.uuid, modifier.modifier, modifier.operation);
        }
    }

    public int getID() {
        return this.effectID;
    }

    public String getEffectName() {
        return this.effectName;
    }

    public ResourceLocation getIcon() {
        return this.potionEffect.icon;
    }

    protected boolean isReady(int ticks, int strength) {
        return true;
    }

    protected void performEffect(EntityLivingBase entity, int strength) {
    }

    protected void affectEntity(EntityLivingBase attacker, EntityLivingBase target, int strength, double multiplier) {
    }

    protected boolean isInstant() {
        return false;
    }

    protected double getAttributeModifier(AttributeModifier attributeModifier, int strength) {
        return attributeModifier.func_111164_d() * (double)(strength + 1);
    }

    public ElixirEffect addAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
        if (this.potionEffect != null) {
            this.potionEffect.func_111184_a(attribute, uuid, modifier, operation);
        } else {
            this.elixirAttributeModifiers.add(new ElixirAttributeModifier(attribute, uuid, modifier, operation));
        }
        return this;
    }

    public ElixirEffect setAntiInfusion() {
        this.isAntiInfusion = true;
        return this;
    }

    public boolean isAntiInfusion() {
        return this.isAntiInfusion;
    }

    public boolean isActive(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_76456_a() != this.potionID) continue;
            return true;
        }
        return false;
    }

    public int getDuration(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_76456_a() != this.potionID) continue;
            return effect.func_76459_b();
        }
        return -1;
    }

    public int getStrength(EntityLivingBase entity) {
        if (entity == null) {
            return -1;
        }
        Collection activePotions = entity.func_70651_bq();
        for (PotionEffect effect : activePotions) {
            if (effect.func_76456_a() != this.potionID) continue;
            return effect.func_76458_c();
        }
        return -1;
    }

    public PotionEffect getPotionEffect(EntityLivingBase entity) {
        if (entity.func_82165_m(this.potionID)) {
            return entity.func_70660_b((Potion)this.potionEffect);
        }
        return null;
    }

    public void removeElixir(EntityLivingBase entity) {
        entity.func_82170_o(this.potionID);
    }

    public ElixirPotionEffect getPotionEffect() {
        return this.potionEffect;
    }

    public static class ElixirPotionEffect
    extends Potion {
        private final ElixirEffect effect;
        private final ResourceLocation icon;
        private final String elixirName;
        private TextContainer nameContainer;

        protected ElixirPotionEffect(ElixirEffect effect, String name, int color, ResourceLocation icon) {
            super(effect.potionID, false, color);
            this.func_76390_b(name);
            this.elixirName = StatCollector.func_74838_a((String)name);
            this.effect = effect;
            this.icon = icon;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76400_d() {
            return this.icon != null;
        }

        public boolean func_76403_b() {
            return this.effect.isInstant();
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            if (this.icon != null) {
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.icon);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)(x + 6), (double)(y + 6), 0.0, 0.0, 0.0);
                tessellator.func_78374_a((double)(x + 6), (double)(y + 6 + 20), 0.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(x + 6 + 20), (double)(y + 6 + 20), 0.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(x + 6 + 20), (double)(y + 6), 0.0, 1.0, 0.0);
                tessellator.func_78381_a();
            }
            if (this.nameContainer == null) {
                this.nameContainer = new TextContainer(88.0, 100.0, this.elixirName, Minecraft.func_71410_x().field_71466_p);
                int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.elixirName);
                float scale = 1.0f;
                if (width > 88) {
                    scale = 88.0f / (float)width;
                    scale -= scale % 0.25f;
                }
                if (scale < 0.5f) {
                    scale = 0.5f;
                }
                this.nameContainer.setCurrentScale(scale);
                this.nameContainer.setCurrentColor(-1);
                try {
                    this.nameContainer.parse();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.nameContainer != null && this.nameContainer.getPages().size() > 0) {
                this.func_76390_b("");
                TextContainer.TextPage page0 = this.nameContainer.getPages().get(0);
                page0.render(x + 28, y + 6);
            }
        }

        public boolean func_76397_a(int ticks, int strength) {
            return this.field_76415_H == this.effect.potionID ? this.effect.isReady(ticks, strength) : false;
        }

        public void func_76394_a(EntityLivingBase entity, int strength) {
            if (this.field_76415_H == this.effect.potionID) {
                this.effect.performEffect(entity, strength);
            }
        }

        public void func_76402_a(EntityLivingBase attacker, EntityLivingBase target, int strength, double distance) {
            if (this.field_76415_H == this.effect.potionID) {
                this.effect.affectEntity(attacker, target, strength, distance);
            }
        }

        public double func_111183_a(int strength, AttributeModifier attributeModifier) {
            if (this.field_76415_H == this.effect.potionID) {
                return this.effect.getAttributeModifier(attributeModifier, strength);
            }
            return super.func_111183_a(strength, attributeModifier);
        }
    }

    private static class ElixirAttributeModifier {
        private final IAttribute attribute;
        private final String uuid;
        private final double modifier;
        private final int operation;

        private ElixirAttributeModifier(IAttribute attribute, String uuid, double modifier, int operation) {
            this.attribute = attribute;
            this.uuid = uuid;
            this.modifier = modifier;
            this.operation = operation;
        }
    }
}

