/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.elixirs;

import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.elixirs.effects.ElixirEffect;

public class ElixirRecipe {
    public final String name;
    public final int infusionFinishedColor;
    public final int infusionGradient;
    public final int infusionFailedColor;
    public final int idealInfusionTime;
    public final int infusionTimeVariation;
    public final int baseDuration;
    public final int durationModifier;
    public final int negativeBaseDuration;
    public final int negativeDurationModifier;
    public final ElixirEffect positiveElixir;
    public final ElixirEffect negativeElixir;
    public final IAspectType strengthAspect;
    public final IAspectType durationAspect;
    public final IAspectType[] aspects;

    public ElixirRecipe(String name, int infusionGradient, int infusionFinishedColor, int infusionFailedColor, int idealInfusionTime, int infusionTimeVariation, int baseDuration, int durationModifier, int negativeBaseDuration, int negativeDurationModifier, ElixirEffect positiveElixir, ElixirEffect negativeElixir, IAspectType[] aspects) {
        this(name, infusionGradient, infusionFinishedColor, infusionFailedColor, idealInfusionTime, infusionTimeVariation, baseDuration, durationModifier, negativeBaseDuration, negativeDurationModifier, positiveElixir, negativeElixir, null, null, aspects);
    }

    public ElixirRecipe(String name, int infusionGradient, int infusionFinishedColor, int infusionFailedColor, int idealInfusionTime, int infusionTimeVariation, int baseDuration, int durationModifier, int negativeBaseDuration, int negativeDurationModifier, ElixirEffect positiveElixir, ElixirEffect negativeElixir, IAspectType strengthAspect, IAspectType durationAspect, IAspectType[] aspects) {
        this.name = name;
        this.infusionGradient = infusionGradient;
        this.infusionFinishedColor = infusionFinishedColor;
        this.infusionFailedColor = infusionFailedColor;
        this.idealInfusionTime = idealInfusionTime;
        this.infusionTimeVariation = infusionTimeVariation;
        this.positiveElixir = positiveElixir;
        this.negativeElixir = negativeElixir;
        this.strengthAspect = strengthAspect;
        this.durationAspect = durationAspect;
        this.baseDuration = baseDuration;
        this.durationModifier = durationModifier;
        this.negativeBaseDuration = negativeBaseDuration;
        this.negativeDurationModifier = negativeDurationModifier;
        this.aspects = aspects;
    }

    public float[] getRGBA(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public static float[] getInfusionColor(ElixirRecipe recipe, int infusionTime) {
        if (recipe != null) {
            if (infusionTime > recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                return recipe.getRGBA(recipe.infusionFailedColor);
            }
            if (infusionTime > recipe.idealInfusionTime - recipe.infusionTimeVariation && infusionTime <= recipe.idealInfusionTime + recipe.infusionTimeVariation) {
                return recipe.getRGBA(recipe.infusionFinishedColor);
            }
            float startR = 0.2f;
            float startG = 0.6f;
            float startB = 0.4f;
            float startA = 0.9f;
            float[] targetColor = recipe.getRGBA(recipe.infusionGradient);
            int targetTime = recipe.idealInfusionTime - recipe.infusionTimeVariation;
            float infusingPercentage = (float)infusionTime / (float)targetTime;
            float interpR = startR + (targetColor[0] - startR) * infusingPercentage;
            float interpG = startG + (targetColor[1] - startG) * infusingPercentage;
            float interpB = startB + (targetColor[2] - startB) * infusingPercentage;
            float interpA = startA + (targetColor[3] - startA) * infusingPercentage;
            return new float[]{interpR, interpG, interpB, interpA};
        }
        return new float[]{0.8f, 0.0f, 0.8f, 1.0f};
    }
}

