/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.aspects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.aspects.IDiscoveryProvider;

public class DiscoveryContainer {
    private final Map<AspectManager.AspectItem, List<IAspectType>> discoveredStaticAspects = new HashMap<AspectManager.AspectItem, List<IAspectType>>();
    private final IDiscoveryProvider provider;
    private final Object providerObj;

    public DiscoveryContainer(IDiscoveryProvider provider, Object providerObj) {
        this.provider = provider;
        this.providerObj = providerObj;
    }

    public DiscoveryContainer() {
        this.provider = null;
        this.providerObj = null;
    }

    public static DiscoveryContainer readFromNBT(NBTTagCompound nbt) {
        DiscoveryContainer container = new DiscoveryContainer();
        container.updateFromNBT(nbt, false);
        return container;
    }

    private int getDiscoveryCount(AspectManager.AspectItem item) {
        return !this.discoveredStaticAspects.containsKey(item) ? 0 : this.discoveredStaticAspects.get(item).size();
    }

    private DiscoveryContainer saveContainer() {
        if (this.provider != null && this.providerObj != null) {
            this.provider.saveContainer(this.providerObj, this);
        }
        return this;
    }

    public AspectDiscovery discover(AspectManager manager, AspectManager.AspectItem item) {
        List<Aspect> staticAspects = manager.getStaticAspects(item);
        if (staticAspects.size() == 0) {
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.NONE, null, false);
        }
        int discoveryCount = this.getDiscoveryCount(item) + 1;
        if (discoveryCount > staticAspects.size()) {
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.END, null, false);
        }
        Aspect undiscovered = this.getUndiscoveredAspect(staticAspects, this.discoveredStaticAspects.get(item));
        this.addDiscovery(item, undiscovered.type);
        if (discoveryCount == staticAspects.size()) {
            this.saveContainer();
            return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.LAST, undiscovered, true);
        }
        this.saveContainer();
        return new AspectDiscovery(AspectDiscovery.EnumDiscoveryResult.NEW, undiscovered, true);
    }

    public void discoverAll(AspectManager manager) {
        for (Map.Entry<AspectManager.AspectItem, List<Aspect>> e : manager.getMatchedAspects().entrySet()) {
            for (Aspect a : e.getValue()) {
                this.addDiscovery(e.getKey(), a.type);
            }
        }
        this.saveContainer();
    }

    public void resetDiscovery(AspectManager.AspectItem item) {
        this.discoveredStaticAspects.remove(item);
        this.saveContainer();
    }

    public void resetAllDiscovery() {
        this.discoveredStaticAspects.clear();
        this.saveContainer();
    }

    public void addDiscovery(AspectManager.AspectItem item, IAspectType discovered) {
        List<IAspectType> discoveredAspects = this.discoveredStaticAspects.get(item);
        if (discoveredAspects == null) {
            discoveredAspects = new ArrayList<IAspectType>();
            this.discoveredStaticAspects.put(item, discoveredAspects);
        }
        if (!discoveredAspects.contains(discovered)) {
            discoveredAspects.add(discovered);
        }
        this.saveContainer();
    }

    private Aspect getUndiscoveredAspect(List<Aspect> all, List<IAspectType> discovered) {
        if (discovered == null) {
            return all.size() == 0 ? null : all.get(0);
        }
        for (Aspect a : all) {
            if (discovered.contains(a.type)) continue;
            return a;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList discoveryList = new NBTTagList();
        Iterator<Map.Entry<AspectManager.AspectItem, List<IAspectType>>> discoveryIT = this.discoveredStaticAspects.entrySet().iterator();
        while (discoveryIT.hasNext()) {
            Map.Entry<AspectManager.AspectItem, List<IAspectType>> e = discoveryIT.next();
            if (e.getValue() == null || e.getValue().size() == 0) {
                discoveryIT.remove();
                continue;
            }
            NBTTagCompound discoveryEntry = new NBTTagCompound();
            e.getKey().writeToNBT(discoveryEntry);
            NBTTagList aspectListCompound = new NBTTagList();
            for (IAspectType type : e.getValue()) {
                aspectListCompound.func_74742_a((NBTBase)AspectManager.writeAspectTypeNBT(type, new NBTTagCompound()));
            }
            discoveryEntry.func_74782_a("aspects", (NBTBase)aspectListCompound);
            discoveryList.func_74742_a((NBTBase)discoveryEntry);
        }
        nbt.func_74782_a("discoveries", (NBTBase)discoveryList);
    }

    public DiscoveryContainer updateFromNBT(NBTTagCompound nbt, boolean save) {
        this.discoveredStaticAspects.clear();
        NBTTagList discoveryList = nbt.func_150295_c("discoveries", 10);
        int discoveryEntries = discoveryList.func_74745_c();
        for (int i = 0; i < discoveryEntries; ++i) {
            NBTTagCompound discoveryEntry = discoveryList.func_150305_b(i);
            AspectManager.AspectItem item = AspectManager.AspectItem.readFromNBT(discoveryEntry);
            ArrayList<IAspectType> aspectTypeList = new ArrayList<IAspectType>();
            NBTTagList aspectListCompound = discoveryEntry.func_150295_c("aspects", 10);
            for (int c = 0; c < aspectListCompound.func_74745_c(); ++c) {
                NBTTagCompound aspectTypeCompound = aspectListCompound.func_150305_b(c);
                aspectTypeList.add(AspectManager.readAspectTypeFromNBT(aspectTypeCompound));
            }
            this.discoveredStaticAspects.put(item, aspectTypeList);
        }
        if (save) {
            this.saveContainer();
        }
        return this;
    }

    public DiscoveryContainer mergeDiscoveries(DiscoveryContainer other) {
        boolean changed = false;
        for (Map.Entry<AspectManager.AspectItem, List<IAspectType>> entry : other.discoveredStaticAspects.entrySet()) {
            AspectManager.AspectItem otherItem = entry.getKey();
            List<IAspectType> otherTypes = entry.getValue();
            if (!this.discoveredStaticAspects.containsKey(otherItem)) {
                this.discoveredStaticAspects.put(otherItem, otherTypes);
                changed = true;
                continue;
            }
            List<IAspectType> aspectTypes = this.discoveredStaticAspects.get(otherItem);
            for (IAspectType otherType : otherTypes) {
                if (aspectTypes.contains(otherType)) continue;
                aspectTypes.add(otherType);
                changed = true;
            }
        }
        if (changed) {
            this.saveContainer();
        }
        return this;
    }

    public List<Aspect> getDiscoveredStaticAspects(AspectManager manager, AspectManager.AspectItem item) {
        ArrayList<Aspect> discoveredStaticAspects = new ArrayList<Aspect>();
        if (this.discoveredStaticAspects.containsKey(item)) {
            List<IAspectType> discoveredAspects = this.discoveredStaticAspects.get(item);
            List<Aspect> staticAspects = manager.getStaticAspects(item);
            for (Aspect a : staticAspects) {
                if (!discoveredAspects.contains(a.type)) continue;
                discoveredStaticAspects.add(a);
            }
        }
        return discoveredStaticAspects;
    }

    public static class AspectDiscovery {
        public final EnumDiscoveryResult result;
        public final boolean successful;
        public final Aspect discovered;

        private AspectDiscovery(EnumDiscoveryResult result, Aspect discovered, boolean successful) {
            this.result = result;
            this.discovered = discovered;
            this.successful = successful;
        }

        public static enum EnumDiscoveryResult {
            NONE,
            NEW,
            LAST,
            END;

        }
    }
}

