/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.aspects;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import thebetweenlands.herblore.Amounts;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.aspects.list.AspectArmaniis;
import thebetweenlands.herblore.aspects.list.AspectAzuwynn;
import thebetweenlands.herblore.aspects.list.AspectByariis;
import thebetweenlands.herblore.aspects.list.AspectByrginaz;
import thebetweenlands.herblore.aspects.list.AspectCelawynn;
import thebetweenlands.herblore.aspects.list.AspectDayuniis;
import thebetweenlands.herblore.aspects.list.AspectFergalaz;
import thebetweenlands.herblore.aspects.list.AspectFirnalaz;
import thebetweenlands.herblore.aspects.list.AspectFreiwynn;
import thebetweenlands.herblore.aspects.list.AspectGeoliirgaz;
import thebetweenlands.herblore.aspects.list.AspectOrdaniis;
import thebetweenlands.herblore.aspects.list.AspectYeowynn;
import thebetweenlands.herblore.aspects.list.AspectYihinren;
import thebetweenlands.herblore.aspects.list.AspectYunugaz;
import thebetweenlands.items.herblore.ItemGenericCrushed;

public class AspectRegistry {
    public static final List<IAspectType> ASPECT_TYPES = new ArrayList<IAspectType>();
    public static final IAspectType AZUWYNN = new AspectAzuwynn();
    public static final IAspectType ARMANIIS = new AspectArmaniis();
    public static final IAspectType BYARIIS = new AspectByariis();
    public static final IAspectType BYRGINAZ = new AspectByrginaz();
    public static final IAspectType CELAWYNN = new AspectCelawynn();
    public static final IAspectType DAYUNIIS = new AspectDayuniis();
    public static final IAspectType FERGALAZ = new AspectFergalaz();
    public static final IAspectType FIRNALAZ = new AspectFirnalaz();
    public static final IAspectType FREIWYNN = new AspectFreiwynn();
    public static final IAspectType GEOLIIRGAZ = new AspectGeoliirgaz();
    public static final IAspectType ORDANIIS = new AspectOrdaniis();
    public static final IAspectType YEOWYNN = new AspectYeowynn();
    public static final IAspectType YUNUGAZ = new AspectYunugaz();
    public static final IAspectType YIHINREN = new AspectYihinren();

    public static IAspectType getAspectTypeFromName(String name) {
        for (IAspectType type : ASPECT_TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static void init() {
        AspectRegistry.registerItems();
        AspectRegistry.registerAspects();
    }

    private static void registerItems() {
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_ALGAE)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_ARROW_ARUM)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BLACKHAT_MUSHROOM)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BOG_BEAN)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BONESET)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BOTTLE_BRUSH_GRASS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BROOM_SEDGE)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BUTTON_BUSH)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CATTAIL)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CAVE_GRASS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CAVE_MOSS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_COPPER_IRIS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_DRIED_SWAMP_REED)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_FLATHEAD_MUSHROOM)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_HANGER)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_LICHEN)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MARSH_HIBISCUS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MARSH_MALLOW)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MILKWEED)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MOSS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_NETTLE)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_PHRAGMITES)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_PICKEREL_WEED)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SHOOTS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SLUDGECREEP)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SOFT_RUSH)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SWAMP_KELP)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SWAMP_GRASS_TALL)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_TANGLED_ROOTS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_WEEDWOOD_BARK)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_WATER_WEEDS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_VOLARPAD)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_THORNS)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_POISON_IVY)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.45f, 1.0f), 3);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_GENERIC_LEAF)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.15f, 0.2f), 4);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_WATER_FLOWER)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.25f, 0.5f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_WATER_FLOWER_STALK)), AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.15f, 0.5f), 4);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BLOOD_SNAIL_SHELL)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 1.0f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BLUE_IRIS)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 1.0f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BLUE_EYED_GRASS)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CARDINAL_FLOWER)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MIRE_CORAL)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MARSH_MARIGOLD)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_GOLDEN_CLUB)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_DEEP_WATER_CORAL)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_MIRE_SNAIL_SHELL)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_BULB_CAPPED_MUSHROOM)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_ANGLER_TOOTH)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 1.6f, 0.65f), 2);
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_SUNDEW)), AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 2.0f, 0.5f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_PITCHER_PLANT)), AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 2.0f, 0.5f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_VENUS_FLY_TRAP)), AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 2.0f, 0.5f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_GREEN_MIDDLE_GEM)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FERGALAZ, 2.0f, 0.25f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_CRIMSON_MIDDLE_GEM)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FIRNALAZ, 2.0f, 0.25f));
        AspectManager.addStaticAspectsToItem(new AspectManager.AspectItemEntry(new AspectManager.AspectItem(ItemGenericCrushed.createStack(ItemGenericCrushed.EnumItemGenericCrushed.GROUND_AQUA_MIDDLE_GEM)), AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_BYRGINAZ, 2.0f, 0.25f));
    }

    private static void registerAspects() {
        AspectManager.registerAspect(new AspectManager.AspectEntry(BYARIIS, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, Amounts.HIGH));
        AspectManager.registerAspect(new AspectManager.AspectEntry(AZUWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, Amounts.LOW_MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(CELAWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, Amounts.LOW_MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(ORDANIIS, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, Amounts.LOW_MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(YEOWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, Amounts.LOW_MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(ARMANIIS, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(BYRGINAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(DAYUNIIS, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(FERGALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(FIRNALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(FREIWYNN, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(YUNUGAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(GEOLIIRGAZ, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, Amounts.MEDIUM_HIGH));
        AspectManager.registerAspect(new AspectManager.AspectEntry(YIHINREN, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, Amounts.MEDIUM_HIGH));
        AspectManager.registerAspect(new AspectManager.AspectEntry(BYRGINAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_BYRGINAZ, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(FERGALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FERGALAZ, Amounts.MEDIUM));
        AspectManager.registerAspect(new AspectManager.AspectEntry(FIRNALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FIRNALAZ, Amounts.MEDIUM));
    }

    static {
        try {
            for (Field f : AspectRegistry.class.getDeclaredFields()) {
                Object obj;
                if (f.getType() != IAspectType.class || !((obj = f.get(null)) instanceof IAspectType)) continue;
                ASPECT_TYPES.add((IAspectType)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

