/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.aspects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectRegistry;
import thebetweenlands.herblore.aspects.DiscoveryContainer;
import thebetweenlands.herblore.aspects.IAspectType;
import thebetweenlands.herblore.aspects.IDiscoveryProvider;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.world.storage.world.BetweenlandsWorldData;

public class AspectManager {
    private static final List<AspectEntry> registeredAspects = new ArrayList<AspectEntry>();
    private static final Map<AspectItem, List<AspectItemEntry>> registeredItems = new LinkedHashMap<AspectItem, List<AspectItemEntry>>();
    private final Map<AspectItem, List<Aspect>> matchedAspects = new LinkedHashMap<AspectItem, List<Aspect>>();

    public Map<AspectItem, List<Aspect>> getMatchedAspects() {
        return Collections.unmodifiableMap(this.matchedAspects);
    }

    public static Map<AspectItem, List<AspectItemEntry>> getRegisteredItems() {
        return registeredItems;
    }

    public static void registerAspect(AspectEntry entry) {
        registeredAspects.add(entry);
    }

    public static void addStaticAspectsToItem(AspectItemEntry entry) {
        AspectManager.addStaticAspectsToItem(entry, 1);
    }

    public static void addStaticAspectsToItem(AspectItemEntry entry, int aspectCount) {
        List<AspectItemEntry> entryList;
        AspectItem itemEntry = entry.item;
        for (Map.Entry<AspectItem, List<AspectItemEntry>> e : registeredItems.entrySet()) {
            if (!e.getKey().equals(itemEntry)) continue;
            itemEntry = e.getKey();
            break;
        }
        if ((entryList = registeredItems.get(itemEntry)) == null) {
            entryList = new ArrayList<AspectItemEntry>();
            registeredItems.put(entry.item, entryList);
        }
        for (int i = 0; i < aspectCount; ++i) {
            entryList.add(entry);
        }
    }

    public static List<AspectEntry> getAspectEntriesFromName(String name) {
        ArrayList<AspectEntry> aspectEntries = new ArrayList<AspectEntry>();
        for (AspectEntry aspect : registeredAspects) {
            if (!aspect.aspect.getName().equals(name)) continue;
            aspectEntries.add(aspect);
        }
        return aspectEntries;
    }

    public static AspectItem getItemEntryFromName(String name, int damage) {
        for (AspectItem e : registeredItems.keySet()) {
            if (!e.item.func_77658_a().equals(name) || e.damage != damage) continue;
            return e;
        }
        return null;
    }

    public static long getAspectsSeed(long worldSeed) {
        Random rnd = new Random();
        rnd.setSeed(worldSeed);
        return rnd.nextLong();
    }

    public static AspectManager get(World world) {
        return BetweenlandsWorldData.forWorld(world).getAspectManager();
    }

    public void loadAndPopulateStaticAspects(NBTTagCompound nbt, long aspectSeed) {
        if (nbt != null && nbt.func_74764_b("aspects")) {
            NBTTagCompound aspectCompound = nbt.func_74775_l("aspects");
            this.loadStaticAspects(aspectCompound);
            this.updateAspects(aspectSeed);
        } else {
            this.generateStaticAspects(aspectSeed);
        }
    }

    private void updateMatchedAspects(AspectItem item, List<Aspect> aspects) {
        Collections.sort(aspects);
        this.matchedAspects.put(item, aspects);
    }

    public void loadStaticAspects(NBTTagCompound nbt) {
        this.matchedAspects.clear();
        NBTTagList entryList = (NBTTagList)nbt.func_74781_a("entries");
        block0: for (int i = 0; i < entryList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = entryList.func_150305_b(i);
            AspectItem itemEntry = AspectItem.readFromNBT(entryCompound);
            if (itemEntry == null) continue;
            NBTTagList aspectList = (NBTTagList)entryCompound.func_74781_a("aspects");
            ArrayList<Aspect> itemAspects = new ArrayList<Aspect>();
            for (int c = 0; c < aspectList.func_74745_c(); ++c) {
                NBTTagCompound aspectCompound = aspectList.func_150305_b(c);
                Aspect aspect = Aspect.readFromNBT(aspectCompound);
                if (aspect == null) continue block0;
                itemAspects.add(aspect);
            }
            this.updateMatchedAspects(itemEntry, itemAspects);
        }
    }

    public void saveStaticAspects(NBTTagCompound nbt) {
        NBTTagCompound aspectCompound = new NBTTagCompound();
        NBTTagList entryList = new NBTTagList();
        for (Map.Entry<AspectItem, List<Aspect>> entry : this.matchedAspects.entrySet()) {
            AspectItem itemEntry = entry.getKey();
            List<Aspect> itemAspects = entry.getValue();
            NBTTagCompound entryCompound = new NBTTagCompound();
            itemEntry.writeToNBT(entryCompound);
            NBTTagList aspectList = new NBTTagList();
            for (Aspect aspect : itemAspects) {
                aspectList.func_74742_a((NBTBase)aspect.writeToNBT(new NBTTagCompound()));
            }
            entryCompound.func_74782_a("aspects", (NBTBase)aspectList);
            entryList.func_74742_a((NBTBase)entryCompound);
        }
        aspectCompound.func_74782_a("entries", (NBTBase)entryList);
        nbt.func_74782_a("aspects", (NBTBase)aspectCompound);
    }

    public void resetStaticAspects(long aspectSeed) {
        this.generateStaticAspects(aspectSeed);
    }

    private void generateStaticAspects(long seed) {
        this.matchedAspects.clear();
        this.updateAspects(seed);
    }

    private void updateAspects(long seed) {
        Random rnd = new Random();
        rnd.setSeed(seed);
        ArrayList<AspectEntry> availableAspects = new ArrayList<AspectEntry>(registeredAspects.size());
        availableAspects.addAll(registeredAspects);
        ArrayList<AspectEntry> possibleAspects = new ArrayList<AspectEntry>();
        for (Map.Entry<AspectItem, List<AspectItemEntry>> item : registeredItems.entrySet()) {
            AspectItem itemStack = item.getKey();
            if (this.matchedAspects.containsKey(itemStack)) continue;
            List<AspectItemEntry> itemEntries = item.getValue();
            ArrayList<Aspect> itemAspects = new ArrayList<Aspect>(itemEntries.size());
            if (!this.fillItemAspects(itemAspects, itemEntries.size(), itemEntries, possibleAspects, availableAspects, rnd)) {
                this.fillItemAspects(itemAspects, itemEntries.size(), itemEntries, possibleAspects, registeredAspects, rnd);
            }
            for (Aspect itemAspect : itemAspects) {
                this.removeAvailableAspect(itemAspect, availableAspects);
            }
            ArrayList<Aspect> mergedAspects = new ArrayList<Aspect>(itemAspects.size());
            for (Aspect aspect : itemAspects) {
                Aspect mergedAspect = null;
                for (Aspect ma : mergedAspects) {
                    if (ma.type != aspect.type) continue;
                    mergedAspect = ma;
                    break;
                }
                if (mergedAspect == null) {
                    mergedAspects.add(aspect);
                    continue;
                }
                mergedAspects.remove(mergedAspect);
                mergedAspects.add(new Aspect(mergedAspect.type, mergedAspect.getAmount() + aspect.getAmount()));
            }
            this.updateMatchedAspects(itemStack, mergedAspects);
        }
    }

    private void removeAvailableAspect(Aspect itemAspect, List<AspectEntry> availableAspects) {
        Iterator<AspectEntry> it = availableAspects.iterator();
        AspectEntry availableAspect = null;
        while (it.hasNext() && (availableAspect = it.next()) != null) {
            if (!availableAspect.aspect.equals(itemAspect.type)) continue;
            it.remove();
        }
    }

    private boolean fillItemAspects(List<Aspect> itemAspects, int itemAspectsSize, List<AspectItemEntry> itemEntries, List<AspectEntry> possibleAspects, List<AspectEntry> availableAspects, Random rnd) {
        boolean foundMatches = false;
        int possibleAspectCount = this.fillPossibleAspects(itemEntries, possibleAspects, availableAspects, null);
        if (possibleAspectCount == 0) {
            return false;
        }
        for (int i = 0; i < itemAspectsSize; ++i) {
            if (possibleAspects.size() == 0) {
                this.fillPossibleAspects(itemEntries, possibleAspects, availableAspects, itemAspectsSize < possibleAspectCount ? itemAspects : null);
            }
            AspectEntry randomAspect = possibleAspects.get(rnd.nextInt(possibleAspects.size()));
            possibleAspects.remove(randomAspect);
            AspectItemEntry matchingItemEntry = null;
            Collections.shuffle(itemEntries, rnd);
            for (AspectItemEntry itemEntry : itemEntries) {
                if (!randomAspect.matchEntry(itemEntry)) continue;
                matchingItemEntry = itemEntry;
                break;
            }
            float baseAmount = randomAspect.baseAmount * matchingItemEntry.amountMultiplier;
            itemAspects.add(new Aspect(randomAspect.aspect, baseAmount + baseAmount * matchingItemEntry.amountVaration * (rnd.nextFloat() * 2.0f - 1.0f)));
            foundMatches = true;
        }
        return foundMatches;
    }

    private int fillPossibleAspects(List<AspectItemEntry> itemEntries, List<AspectEntry> possibleAspects, List<AspectEntry> availableAspects, List<Aspect> takenAspects) {
        possibleAspects.clear();
        for (AspectItemEntry itemEntry : itemEntries) {
            for (AspectEntry availableAspect : availableAspects) {
                if (!availableAspect.matchEntry(itemEntry) || possibleAspects.contains(availableAspect) || takenAspects != null && takenAspects.contains(availableAspect)) continue;
                possibleAspects.add(availableAspect);
            }
        }
        return possibleAspects.size();
    }

    public List<Aspect> getStaticAspects(AspectItem item) {
        for (Map.Entry<AspectItem, List<Aspect>> e : this.matchedAspects.entrySet()) {
            if (!e.getKey().equals(item)) continue;
            return e.getValue();
        }
        return new ArrayList<Aspect>();
    }

    public static List<Aspect> getDynamicAspects(ItemStack stack) {
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("herbloreAspects")) {
            NBTTagList lst = stack.field_77990_d.func_150295_c("herbloreAspects", 10);
            for (int i = 0; i < lst.func_74745_c(); ++i) {
                NBTTagCompound aspectCompound = lst.func_150305_b(i);
                Aspect itemAspect = Aspect.readFromNBT(aspectCompound);
                if (itemAspect == null) continue;
                aspects.add(itemAspect);
            }
        }
        return aspects;
    }

    public static ItemStack addDynamicAspects(ItemStack stack, Aspect ... aspects) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!stack.field_77990_d.func_74764_b("herbloreAspects")) {
            stack.field_77990_d.func_74782_a("herbloreAspects", (NBTBase)new NBTTagList());
        }
        NBTTagList lst = stack.field_77990_d.func_150295_c("herbloreAspects", 10);
        for (Aspect aspect : aspects) {
            NBTTagCompound aspectCompound = new NBTTagCompound();
            aspect.writeToNBT(aspectCompound);
            lst.func_74742_a((NBTBase)aspectCompound);
        }
        return stack;
    }

    public static ItemStack removeDynamicAspects(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("herbloreAspects")) {
            stack.field_77990_d.func_82580_o("herbloreAspects");
        }
        return stack;
    }

    public static ItemStack removeDynamicAspects(ItemStack stack, IAspectType ... types) {
        block0: for (IAspectType type : types) {
            if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("herbloreAspects")) continue;
            NBTTagList lst = stack.field_77990_d.func_150295_c("herbloreAspects", 10);
            int count = lst.func_74745_c();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound aspectCompound = lst.func_150305_b(i);
                Aspect itemAspect = Aspect.readFromNBT(aspectCompound);
                if (itemAspect == null || !itemAspect.type.equals(type)) continue;
                lst.func_74744_a(i);
                continue block0;
            }
        }
        return stack;
    }

    public static ItemStack removeDynamicAspects(ItemStack stack, Aspect ... aspects) {
        block0: for (Aspect aspect : aspects) {
            if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("herbloreAspects")) continue;
            NBTTagList lst = stack.field_77990_d.func_150295_c("herbloreAspects", 10);
            int count = lst.func_74745_c();
            for (int i = 0; i < count; ++i) {
                NBTTagCompound aspectCompound = lst.func_150305_b(i);
                Aspect itemAspect = Aspect.readFromNBT(aspectCompound);
                if (itemAspect == null || !itemAspect.equals(aspect)) continue;
                lst.func_74744_a(i);
                continue block0;
            }
        }
        return stack;
    }

    public List<Aspect> getDiscoveredAspects(ItemStack stack, DiscoveryContainer discoveryContainer) {
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        if (discoveryContainer == null) {
            aspects.addAll(this.getStaticAspects(new AspectItem(stack)));
        } else {
            aspects.addAll(discoveryContainer.getDiscoveredStaticAspects(this, new AspectItem(stack)));
        }
        aspects.addAll(AspectManager.getDynamicAspects(stack));
        return aspects;
    }

    public List<IAspectType> getDiscoveredAspectTypes(ItemStack stack, DiscoveryContainer discoveryContainer) {
        ArrayList<IAspectType> aspects = new ArrayList<IAspectType>();
        for (Aspect aspect : this.getDiscoveredAspects(stack, discoveryContainer)) {
            aspects.add(aspect.type);
        }
        return aspects;
    }

    public List<Aspect> getDiscoveredAspects(AspectItem item, DiscoveryContainer discoveryContainer) {
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        if (discoveryContainer == null) {
            aspects.addAll(this.getStaticAspects(item));
        } else {
            aspects.addAll(discoveryContainer.getDiscoveredStaticAspects(this, item));
        }
        return aspects;
    }

    public List<IAspectType> getDiscoveredAspectTypes(AspectItem item, DiscoveryContainer discoveryContainer) {
        ArrayList<IAspectType> aspects = new ArrayList<IAspectType>();
        for (Aspect aspect : this.getDiscoveredAspects(item, discoveryContainer)) {
            aspects.add(aspect.type);
        }
        return aspects;
    }

    public static NBTTagCompound writeAspectTypeNBT(IAspectType type, NBTTagCompound nbt) {
        nbt.func_74778_a("type", type.getName());
        return nbt;
    }

    public static IAspectType readAspectTypeFromNBT(NBTTagCompound nbt) {
        return AspectRegistry.getAspectTypeFromName(nbt.func_74779_i("type"));
    }

    public static boolean hasDiscoveryProvider(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != BLItemRegistry.manualHL) continue;
            return true;
        }
        return false;
    }

    public static List<DiscoveryContainer> getWritableDiscoveryContainers(EntityPlayer player) {
        ArrayList<DiscoveryContainer> containerList = new ArrayList<DiscoveryContainer>();
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != BLItemRegistry.manualHL) continue;
            IDiscoveryProvider provider = (IDiscoveryProvider)stack.func_77973_b();
            ItemStack providerObj = stack;
            DiscoveryContainer container = provider.getContainer(stack);
            if (container == null) continue;
            containerList.add(container);
        }
        return containerList;
    }

    public static DiscoveryContainer getMergedDiscoveryContainer(EntityPlayer player) {
        List<DiscoveryContainer> containerList = AspectManager.getWritableDiscoveryContainers(player);
        DiscoveryContainer merged = new DiscoveryContainer();
        for (DiscoveryContainer container : containerList) {
            if (container == null) continue;
            merged.mergeDiscoveries(container);
        }
        return merged;
    }

    public static void addDiscoveryToContainers(EntityPlayer player, AspectItem item, IAspectType type) {
        List<DiscoveryContainer> discoveryContainers = AspectManager.getWritableDiscoveryContainers(player);
        for (DiscoveryContainer container : discoveryContainers) {
            container.addDiscovery(item, type);
        }
    }

    public static final class AspectItem {
        public final Item item;
        public final int damage;

        public AspectItem(Item item, int damage) {
            this.item = item;
            this.damage = damage;
        }

        public AspectItem(Item item) {
            this(item, -1);
        }

        public AspectItem(ItemStack itemStack) {
            this(itemStack.func_77973_b(), itemStack.func_77960_j());
        }

        public boolean matchItemStack(ItemStack itemStack) {
            return itemStack.func_77973_b().equals(this.item) && (this.damage == -1 || itemStack.func_77960_j() == this.damage);
        }

        public boolean matchItem(Item item) {
            return this.item.equals(item);
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_74778_a("item", this.item.func_77658_a());
            nbt.func_74768_a("damage", this.damage);
            return nbt;
        }

        public static AspectItem readFromNBT(NBTTagCompound nbt) {
            String itemName = nbt.func_74779_i("item");
            int itemDamage = nbt.func_74762_e("damage");
            AspectItem aspectItem = AspectManager.getItemEntryFromName(itemName, itemDamage);
            return aspectItem;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.damage;
            result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AspectItem other = (AspectItem)obj;
            if (this.damage != other.damage) {
                return false;
            }
            return !(this.item == null ? other.item != null : !this.item.equals(other.item));
        }
    }

    public static final class AspectItemEntry {
        public final AspectItem item;
        public final AspectTier tier;
        public final AspectGroup type;
        public final float amountMultiplier;
        public final float amountVaration;
        public final String itemName;

        public AspectItemEntry(AspectItem item, AspectTier tier, AspectGroup type, float amountMultiplier, float amountVariation) {
            this.item = item;
            this.tier = tier;
            this.type = type;
            this.amountMultiplier = amountMultiplier;
            this.amountVaration = amountVariation;
            this.itemName = this.item.item.func_77658_a();
        }
    }

    public static class AspectEntry {
        public final IAspectType aspect;
        public final AspectTier tier;
        public final AspectGroup type;
        public final float baseAmount;
        public final String aspectName;

        public AspectEntry(IAspectType aspect, AspectTier tier, AspectGroup type, float baseAmount) {
            this.aspect = aspect;
            this.tier = tier;
            this.type = type;
            this.baseAmount = baseAmount;
            this.aspectName = this.aspect.getName();
        }

        public boolean matchEntry(AspectItemEntry itemEntry) {
            return itemEntry.tier == this.tier && itemEntry.type == this.type;
        }
    }

    public static enum AspectGroup {
        HERB,
        GEM_BYRGINAZ,
        GEM_FIRNALAZ,
        GEM_FERGALAZ;

    }

    public static enum AspectTier {
        COMMON,
        UNCOMMON,
        RARE;

    }
}

