/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.herblore.aspects;

import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.herblore.aspects.AspectRegistry;
import thebetweenlands.herblore.aspects.IAspectType;

public class Aspect
implements Comparable<Aspect> {
    public final IAspectType type;
    public final float amount;

    public Aspect(IAspectType aspect, float amount) {
        if (aspect == null) {
            throw new RuntimeException("Aspect can't be null");
        }
        this.type = aspect;
        this.amount = amount;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("aspect", this.type.getName());
        nbt.func_74776_a("amount", this.amount);
        return nbt;
    }

    public static Aspect readFromNBT(NBTTagCompound nbt) {
        String aspectName = nbt.func_74779_i("aspect");
        float amount = nbt.func_74760_g("amount");
        IAspectType aspectType = AspectRegistry.getAspectTypeFromName(aspectName);
        if (aspectType != null) {
            return new Aspect(aspectType, amount);
        }
        return null;
    }

    public float getAmount() {
        return this.amount;
    }

    public IAspectType getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.amount);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aspect other = (Aspect)obj;
        if (Float.floatToIntBits(this.amount) != Float.floatToIntBits(other.amount)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public int compareTo(Aspect other) {
        return this.type.getName().compareTo(other.type.getName());
    }
}

