/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.gemcircle;

import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.gemcircle.CircleGem;

public class EntityGem {
    private final CircleGem gem;
    private final Type type;

    public EntityGem(CircleGem gem, Type type) {
        this.gem = gem;
        this.type = type;
    }

    public CircleGem getGem() {
        return this.gem;
    }

    public Type getType() {
        return this.type;
    }

    public boolean matches(Type type) {
        return this.type == Type.BOTH || type == this.type;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("gem", this.gem.name);
        nbt.func_74768_a("type", this.type.ordinal());
        return nbt;
    }

    public static EntityGem readFromNBT(NBTTagCompound nbt) {
        CircleGem gem = CircleGem.fromName(nbt.func_74779_i("gem"));
        int typeOrdinal = nbt.func_74762_e("type");
        if (Type.values().length > typeOrdinal) {
            return new EntityGem(gem, Type.values()[typeOrdinal]);
        }
        return null;
    }

    public static enum Type {
        OFFENSIVE,
        DEFENSIVE,
        BOTH;

    }
}

