/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.gemcircle;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesCircleGem;
import thebetweenlands.gemcircle.EntityGem;
import thebetweenlands.network.packet.server.PacketGemProc;

public enum CircleGem {
    CRIMSON("crimson"),
    GREEN("green"),
    AQUA("aqua"),
    NONE("none");

    public final String name;
    public static final CircleGem[] TYPES;
    public static final float MAX_GEM_DAMAGE_VARIATION = 8.0f;
    public static final float GEM_PROC_CHANCE = 0.1f;

    private CircleGem(String name) {
        this.name = name;
    }

    public int getRelation(CircleGem gem) {
        switch (this) {
            case CRIMSON: {
                switch (gem) {
                    case GREEN: {
                        return 1;
                    }
                    case AQUA: {
                        return -1;
                    }
                }
                return 0;
            }
            case GREEN: {
                switch (gem) {
                    case AQUA: {
                        return 1;
                    }
                    case CRIMSON: {
                        return -1;
                    }
                }
                return 0;
            }
            case AQUA: {
                switch (gem) {
                    case CRIMSON: {
                        return 1;
                    }
                    case GREEN: {
                        return -1;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    public boolean applyProc(boolean isAttacker, Entity owner, Entity source, Entity attacker, Entity defender, float strength) {
        switch (this) {
            case CRIMSON: {
                if (!isAttacker || !(defender instanceof EntityLivingBase)) break;
                double knockbackStrength = Math.min(0.22000000000000003 * (double)strength, 2.2);
                double mx = attacker.field_70165_t - defender.field_70165_t;
                double mz = attacker.field_70161_v - defender.field_70161_v;
                while (mx * mx + mz * mz < 1.0E-4) {
                    mx = (Math.random() - Math.random()) * 0.01;
                    mz = (Math.random() - Math.random()) * 0.01;
                }
                double len = Math.sqrt(mx * mx + mz * mz);
                ((EntityLivingBase)defender).func_70653_a(attacker, strength, mx * 6.0, mz * 6.0);
                defender.field_70159_w /= 2.0;
                defender.field_70181_x /= 2.0;
                defender.field_70179_y /= 2.0;
                defender.field_70159_w -= mx / len * knockbackStrength;
                defender.field_70181_x += 0.4;
                defender.field_70179_y -= mz / len * knockbackStrength;
                if (defender.field_70181_x > 0.4) {
                    defender.field_70181_x = 0.4;
                }
                if (attacker instanceof EntityLivingBase) {
                    ((EntityLivingBase)attacker).func_70690_d(new PotionEffect(Potion.field_76420_g.func_76396_c(), 90, Math.min(MathHelper.func_76141_d((float)(strength * 0.2f)), 2)));
                }
                if (source != attacker && source instanceof EntityLivingBase) {
                    ((EntityLivingBase)source).func_70690_d(new PotionEffect(Potion.field_76420_g.func_76396_c(), 90, Math.min(MathHelper.func_76141_d((float)(strength * 0.2f)), 2)));
                }
                return true;
            }
            case GREEN: {
                if (!isAttacker) break;
                boolean healed = false;
                if (attacker instanceof EntityLivingBase) {
                    ((EntityLivingBase)attacker).func_70691_i(Math.min(Math.max(strength * 0.45f, 1.0f), 10.0f));
                    healed = true;
                }
                if (source != attacker && source instanceof EntityLivingBase) {
                    ((EntityLivingBase)source).func_70691_i(Math.min(Math.max(strength * 0.45f, 1.0f), 10.0f));
                    healed = true;
                }
                return healed;
            }
            case AQUA: {
                if (isAttacker || !(defender instanceof EntityLivingBase)) break;
                ((EntityLivingBase)defender).func_70690_d(new PotionEffect(Potion.field_76429_m.func_76396_c(), 90, Math.min(MathHelper.func_76141_d((float)(strength * 0.3f)), 2)));
                return true;
            }
        }
        return false;
    }

    public static CircleGem fromName(String name) {
        for (CircleGem gem : TYPES) {
            if (!gem.name.equals(name)) continue;
            return gem;
        }
        return NONE;
    }

    public static float handleAttack(DamageSource damageSource, EntityLivingBase attackedEntity, float damage) {
        if (!(attackedEntity.field_70737_aN != 0 || attackedEntity.field_70725_aQ != 0 || !(damageSource instanceof EntityDamageSource) || attackedEntity instanceof EntityPlayer && ((EntityPlayer)attackedEntity).field_71075_bZ.field_75102_a)) {
            Entity attacker = null;
            Entity source = null;
            if (damageSource instanceof EntityDamageSourceIndirect) {
                attacker = ((EntityDamageSourceIndirect)damageSource).func_76364_f();
                source = ((EntityDamageSource)damageSource).func_76346_g();
            } else {
                source = attacker = ((EntityDamageSource)damageSource).func_76346_g();
            }
            if (attacker != null && source != null) {
                float gemDamageVariation;
                EntityPlayer player;
                Object heldItem;
                ItemStack heldItem2;
                List<EntityGem> attackerGems = CircleGem.getGems(attacker);
                ArrayList<EntityGem> sourceGems = new ArrayList<EntityGem>();
                if (source != attacker) {
                    sourceGems.addAll(CircleGem.getGems(source));
                }
                CircleGem attackerItemGem = NONE;
                if (attacker instanceof EntityLivingBase && (heldItem2 = ((EntityLivingBase)attacker).func_70694_bm()) != null) {
                    attackerItemGem = CircleGem.getGem(heldItem2);
                }
                List<EntityGem> attackedGems = CircleGem.getGems((Entity)attackedEntity);
                CircleGem attackedBlockingItemGem = NONE;
                if (attacker instanceof EntityPlayer && (heldItem = (player = (EntityPlayer)attacker).func_70694_bm()) != null && player.func_70632_aY()) {
                    attackedBlockingItemGem = CircleGem.getGem((ItemStack)heldItem);
                }
                int gemRelation = 0;
                for (EntityGem gem : attackerGems) {
                    if (!gem.matches(EntityGem.Type.OFFENSIVE)) continue;
                    for (EntityGem gemAttacked : attackedGems) {
                        if (!gemAttacked.matches(EntityGem.Type.DEFENSIVE)) continue;
                        gemRelation += gem.getGem().getRelation(gemAttacked.getGem());
                    }
                    gemRelation += gem.getGem().getRelation(attackedBlockingItemGem);
                }
                for (EntityGem gemAttacked : attackedGems) {
                    if (!gemAttacked.matches(EntityGem.Type.DEFENSIVE)) continue;
                    gemRelation += attackerItemGem.getRelation(gemAttacked.getGem());
                }
                gemRelation += attackerItemGem.getRelation(attackedBlockingItemGem);
                for (EntityGem gem : sourceGems) {
                    if (!gem.matches(EntityGem.Type.OFFENSIVE)) continue;
                    for (EntityGem gemAttacked : attackedGems) {
                        if (!gemAttacked.matches(EntityGem.Type.DEFENSIVE)) continue;
                        gemRelation += gem.getGem().getRelation(gemAttacked.getGem());
                    }
                    gemRelation += gem.getGem().getRelation(attackedBlockingItemGem);
                }
                if (attackedEntity instanceof EntityLivingBase) {
                    ItemStack[] equipment = attackedEntity.func_70035_c();
                    for (int i = 0; i < equipment.length; ++i) {
                        ItemStack equipmentStack = equipment[i];
                        if (equipmentStack == null || equipmentStack.equals(attackedEntity.func_70694_bm()) || !(equipmentStack.func_77973_b() instanceof ItemArmor)) continue;
                        CircleGem armorGem = CircleGem.getGem(equipmentStack);
                        for (EntityGem gem : attackerGems) {
                            if (!gem.matches(EntityGem.Type.OFFENSIVE)) continue;
                            gemRelation += gem.getGem().getRelation(armorGem);
                        }
                        gemRelation += attackerItemGem.getRelation(armorGem);
                        for (EntityGem gem : sourceGems) {
                            if (!gem.matches(EntityGem.Type.OFFENSIVE)) continue;
                            gemRelation += gem.getGem().getRelation(armorGem);
                        }
                    }
                }
                if ((gemDamageVariation = Math.min(((gemRelation != 0 ? Math.signum(gemRelation) * 1.0f : 0.0f) + (float)gemRelation) / 6.0f * 8.0f, 8.0f)) != 0.0f) {
                    damage = Math.max(damage + gemDamageVariation, 1.0f);
                }
                boolean attackerProc = attacker.field_70170_p.field_73012_v.nextFloat() <= (source == attacker && !attacker.field_70122_E && attacker.field_70181_x < 0.0 ? 0.133f : 0.1f);
                boolean defenderProc = attacker.field_70170_p.field_73012_v.nextFloat() <= 0.1f;
                boolean attackerProcd = false;
                boolean defenderProcd = false;
                TObjectIntHashMap attackerGemCounts = new TObjectIntHashMap();
                for (Object gem : attackerGems) {
                    if (!gem.matches(EntityGem.Type.OFFENSIVE)) continue;
                    attackerGemCounts.adjustOrPutValue((Object)gem.getGem(), 1, 1);
                }
                attackerGemCounts.adjustOrPutValue((Object)attackerItemGem, 1, 1);
                for (Object gem : attackerGemCounts.keySet()) {
                    attackerProcd |= CircleGem.applyProc((CircleGem)((Object)gem), attacker, source, attacker, (Entity)attackedEntity, attackerProc, defenderProc, CircleGem.getMultipleProcStrength(attackerGemCounts.get(gem), damage));
                }
                TObjectIntHashMap defenderGemCounts = new TObjectIntHashMap();
                if (attackedEntity instanceof EntityLivingBase) {
                    ItemStack[] equipment = attackedEntity.func_70035_c();
                    for (int i = 0; i < equipment.length; ++i) {
                        CircleGem armorGem;
                        Object equipmentStack = equipment[i];
                        if (equipmentStack == null || equipmentStack.equals(attackedEntity.func_70694_bm()) || !(equipmentStack.func_77973_b() instanceof ItemArmor) || (armorGem = CircleGem.getGem((ItemStack)equipmentStack)) == NONE) continue;
                        defenderGemCounts.adjustOrPutValue((Object)armorGem, 1, 1);
                    }
                }
                for (EntityGem gem : attackedGems) {
                    if (!gem.matches(EntityGem.Type.DEFENSIVE)) continue;
                    defenderGemCounts.adjustOrPutValue((Object)gem.getGem(), 1, 1);
                }
                defenderGemCounts.adjustOrPutValue((Object)attackedBlockingItemGem, 1, 1);
                for (CircleGem gem : defenderGemCounts.keySet()) {
                    defenderProcd |= CircleGem.applyProc(gem, (Entity)attackedEntity, source, attacker, (Entity)attackedEntity, attackerProc, defenderProc, CircleGem.getMultipleProcStrength(defenderGemCounts.get((Object)gem), damage));
                }
                if (attackerProcd || defenderProcd) {
                    Random rnd = source.field_70170_p.field_73012_v;
                    World world = attackedEntity.field_70170_p;
                    int dim = 0;
                    if (world instanceof WorldServer) {
                        dim = ((WorldServer)world).field_73011_w.field_76574_g;
                    }
                    if (attackerProcd) {
                        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketGemProc(0, attackedEntity.func_145782_y())), new NetworkRegistry.TargetPoint(dim, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 64.0));
                    }
                    if (defenderProcd) {
                        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)TheBetweenlands.sidedPacketHandler.wrapPacket(new PacketGemProc(1, attackedEntity.func_145782_y())), new NetworkRegistry.TargetPoint(dim, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 64.0));
                    }
                    source.field_70170_p.func_72956_a(source, "random.successful_hit", 1.0f, 1.0f);
                    attackedEntity.field_70170_p.func_72956_a((Entity)attackedEntity, "random.successful_hit", 1.0f, 1.0f);
                }
            }
        }
        return damage;
    }

    private static float getMultipleProcStrength(int procs, float strength) {
        float ret = 0.0f;
        for (int i = 0; i < procs; ++i) {
            ret = (float)((double)ret + (double)strength / Math.pow(1.4f, i));
        }
        return ret;
    }

    private static boolean applyProc(CircleGem gem, Entity owner, Entity source, Entity attacker, Entity defender, boolean attackerProc, boolean defenderProc, float strength) {
        boolean isAttacker;
        boolean bl = isAttacker = owner == attacker;
        if (isAttacker && attackerProc || !isAttacker && defenderProc) {
            return gem.applyProc(isAttacker, owner, source, attacker, defender, strength);
        }
        return false;
    }

    public static boolean isApplicable(Object obj) {
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            Item item = stack.func_77973_b();
            return item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemBow;
        }
        return obj instanceof EntityLivingBase;
    }

    public static void setGem(ItemStack stack, CircleGem gem) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74778_a("blCircleGem", gem == null ? "none" : gem.name);
    }

    public static CircleGem getGem(ItemStack stack) {
        if (stack.field_77990_d != null) {
            return CircleGem.fromName(stack.field_77990_d.func_74779_i("blCircleGem"));
        }
        return NONE;
    }

    public static void addGem(Entity entity, CircleGem gem, EntityGem.Type type) {
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        if (property != null) {
            property.addGem(gem, type);
        }
    }

    public static List<EntityGem> getGems(Entity entity) {
        ArrayList<EntityGem> gems = new ArrayList<EntityGem>();
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        if (property != null) {
            gems.addAll(property.getGems());
        }
        return gems;
    }

    public static EntityGem getGem(Entity entity, int slot) {
        EntityPropertiesCircleGem property = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesCircleGem.class);
        if (property != null && property.getGems().size() > slot) {
            return property.getGems().get(slot);
        }
        return null;
    }

    static {
        TYPES = CircleGem.values();
    }
}

