/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.forgeevent;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.demo.DemoWorldManager;
import net.minecraftforge.common.MinecraftForge;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.forgeevent.entity.LivingSetRevengeTargetEvent;
import thebetweenlands.forgeevent.entity.player.PlayerEventGetHurtSound;
import thebetweenlands.utils.confighandler.ConfigHandler;

public final class BLForgeHooks {
    private BLForgeHooks() {
    }

    public static void onLivingSetRevengeTarget(EntityLivingBase entity, EntityLivingBase target) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingSetRevengeTargetEvent(entity, target));
    }

    public static String onPlayerGetHurtSound(EntityPlayer player) {
        PlayerEventGetHurtSound event = new PlayerEventGetHurtSound(player, "game.player.hurt");
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.hurtSound;
    }

    public static EntityPlayerMP createPlayerForUser(ServerConfigurationManager serverConfigurationManager, GameProfile gameProfile) {
        UUID uuid = EntityPlayer.func_146094_a((GameProfile)gameProfile);
        ArrayList sameUUIDPlayers = Lists.newArrayList();
        for (int i = 0; i < serverConfigurationManager.field_72404_b.size(); ++i) {
            EntityPlayerMP player = (EntityPlayerMP)serverConfigurationManager.field_72404_b.get(i);
            if (!player.func_110124_au().equals(uuid)) continue;
            sameUUIDPlayers.add(player);
        }
        for (EntityPlayerMP player : sameUUIDPlayers) {
            player.field_71135_a.func_147360_c("You logged in from another location");
        }
        int dimensionId = TheBetweenlands.proxy.getDebugHandler().isInDebugWorld() ? ConfigHandler.DIMENSION_ID : 0;
        MinecraftServer mcServer = serverConfigurationManager.func_72365_p();
        WorldServer world = mcServer.func_71218_a(dimensionId);
        Object itemInWorldManager = mcServer.func_71242_L() ? new DemoWorldManager((World)world) : new ItemInWorldManager((World)world);
        return new EntityPlayerMP(mcServer, world, gameProfile, (ItemInWorldManager)itemInWorldManager);
    }
}

