/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.world;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.biomes.base.BiomeGenBaseBetweenlands;

public class PopulationHandler {
    public static final PopulationHandler INSTANCE = new PopulationHandler();
    private List<Long> generatingChunks = new ArrayList<Long>();

    @SubscribeEvent
    public void onPopulateChunkPost(PopulateChunkEvent.Post event) {
        World world = event.world;
        if (world.field_73011_w.field_76574_g == ConfigHandler.DIMENSION_ID && !world.field_72995_K) {
            int recChunkGenLimit = 3;
            long chunkID = ChunkCoordIntPair.func_77272_a((int)event.chunkX, (int)event.chunkZ);
            for (Long lc : this.generatingChunks) {
                if (lc != chunkID) continue;
                return;
            }
            if (this.generatingChunks.size() >= recChunkGenLimit) {
                return;
            }
            this.generatingChunks.add(chunkID);
            BiomeGenBase biome = world.func_72807_a(event.chunkX * 16, event.chunkZ * 16);
            if (biome instanceof BiomeGenBaseBetweenlands) {
                BiomeGenBaseBetweenlands bgbb = (BiomeGenBaseBetweenlands)biome;
                bgbb.postChunkGen(world, world.field_73012_v, event.chunkX * 16, event.chunkZ * 16);
            }
            this.generatingChunks.remove(chunkID);
        }
    }
}

