/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.world;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.network.message.MessageSyncEnvironmentEvent;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEvent;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public class EnvironmentEventHandler {
    public static final EnvironmentEventHandler INSTANCE = new EnvironmentEventHandler();
    private int lastSync = 0;

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.world.field_73011_w instanceof WorldProviderBetweenlands && !event.world.field_72995_K) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.world.field_73011_w;
            provider.getWorldData();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_73011_w instanceof WorldProviderBetweenlands && !event.world.field_72995_K) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.world.field_73011_w;
            provider.getWorldData().func_76185_a();
            EnvironmentEventRegistry reg = provider.getWorldData().getEnvironmentEventRegistry();
            for (EnvironmentEvent eevent : reg.getEvents().values()) {
                if (!eevent.isLoaded()) continue;
                if (reg.isDisabled()) {
                    eevent.setActive(false, eevent.isActive());
                    eevent.setDefaults();
                } else {
                    eevent.update(event.world);
                }
                if (!eevent.isDirty()) continue;
                eevent.setDirty(false);
                TheBetweenlands.networkWrapper.sendToAll((IMessage)new MessageSyncEnvironmentEvent(eevent));
            }
            ++this.lastSync;
            if (this.lastSync >= 80) {
                this.lastSync = 0;
                for (EnvironmentEvent eevent : provider.getWorldData().getEnvironmentEventRegistry().getEvents().values()) {
                    TheBetweenlands.networkWrapper.sendToAll((IMessage)new MessageSyncEnvironmentEvent(eevent));
                }
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        World world = TheBetweenlands.proxy.getClientWorld();
        if (world != null && world.field_72995_K && world.field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
            EnvironmentEventRegistry reg = provider.getWorldData().getEnvironmentEventRegistry();
            for (EnvironmentEvent eevent : reg.getEvents().values()) {
                if (!eevent.isLoaded()) continue;
                eevent.update(world);
            }
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K && event.entity instanceof EntityPlayerMP && event.world.field_73011_w instanceof WorldProviderBetweenlands) {
            WorldProviderBetweenlands provider = (WorldProviderBetweenlands)event.world.field_73011_w;
            for (EnvironmentEvent eevent : provider.getWorldData().getEnvironmentEventRegistry().getEvents().values()) {
                TheBetweenlands.networkWrapper.sendToAll((IMessage)new MessageSyncEnvironmentEvent(eevent));
            }
        }
    }
}

