/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.event.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Map;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.terrain.BlockWisp;
import thebetweenlands.client.render.entity.RenderFirefly;
import thebetweenlands.client.render.shader.GeometryBuffer;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.MainShader;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.tileentity.TileEntityWispRenderer;
import thebetweenlands.entities.mobs.EntityFirefly;
import thebetweenlands.entities.particles.EntityWispFX;
import thebetweenlands.tileentities.TileEntityWisp;

public class WorldRenderHandler {
    public static final WorldRenderHandler INSTANCE = new WorldRenderHandler();
    public final ArrayList<Map.Entry<Map.Entry<TileEntityWispRenderer, TileEntityWisp>, Vector3d>> wispTileList = new ArrayList();
    public final ArrayList<Map.Entry<Map.Entry<RenderFirefly, EntityFirefly>, Vector3d>> fireflyList = new ArrayList();
    public final ArrayList<Map.Entry<Vector3d, Float>> repellerShields = new ArrayList();
    private int sphereDispList = -2;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        MainShader shader;
        Vector3d pos;
        GL11.glPushMatrix();
        for (Map.Entry<Map.Entry<TileEntityWispRenderer, TileEntityWisp>, Vector3d> entry : this.wispTileList) {
            pos = entry.getValue();
            entry.getKey().getKey().doRender(entry.getKey().getValue(), pos.x, pos.y, pos.z, event.partialTicks);
            double d = pos.x + RenderManager.field_78725_b + 0.5;
            double ry = pos.y + RenderManager.field_78726_c + 0.5;
            double rz = pos.z + RenderManager.field_78723_d + 0.5;
            float size = 3.0f;
            if (!BlockWisp.canSee(entry.getKey().getValue().func_145831_w())) {
                size = (1.0f - MathHelper.func_76126_a((float)(0.19634955f * MathHelper.func_76131_a((float)EntityWispFX.getDistanceToViewer(d, ry, rz, event.partialTicks), (float)10.0f, (float)20.0f)))) * 1.2f;
            }
            int wispMeta = entry.getKey().getValue().func_145832_p();
            for (int i = 0; i < 2; ++i) {
                int color = BLBlockRegistry.wisp.colors[wispMeta + i];
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                if (!ShaderHelper.INSTANCE.isWorldShaderActive()) continue;
                ShaderHelper.INSTANCE.addDynLight(new LightSource(d, ry, rz, i == 0 ? size : size * 0.5f, r * (i == 0 ? 3.5f : 1.0f), g * (i == 0 ? 3.5f : 1.0f), b * (i == 0 ? 3.5f : 1.0f)));
            }
        }
        GL11.glPopMatrix();
        this.wispTileList.clear();
        GL11.glPushMatrix();
        for (Map.Entry<Map.Entry<Object, Object>, Vector3d> entry : this.fireflyList) {
            pos = entry.getValue();
            RenderFirefly renderFirefly = (RenderFirefly)((Object)entry.getKey().getKey());
            EntityFirefly entity = (EntityFirefly)entry.getKey().getValue();
            renderFirefly.doRenderCallback((Entity)entity, pos.x, pos.y, pos.z, event.partialTicks);
            if (!ShaderHelper.INSTANCE.isWorldShaderActive()) continue;
            ShaderHelper.INSTANCE.addDynLight(new LightSource(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 7.0f, 3.7647061f + entity.field_70170_p.field_73012_v.nextFloat() * 0.4f, 2.8235295f + entity.field_70170_p.field_73012_v.nextFloat() * 0.1f, 1.8823531f));
        }
        GL11.glPopMatrix();
        this.fireflyList.clear();
        if (ShaderHelper.INSTANCE.isWorldShaderActive() && (shader = ShaderHelper.INSTANCE.getCurrentShader()) != null) {
            GeometryBuffer geometryBuffer = shader.getGeometryBuffer("repellerShield");
            geometryBuffer.bind();
            geometryBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f);
            GeometryBuffer gasParticlesBuffer = shader.getGeometryBuffer("gasParticles");
            gasParticlesBuffer.bind();
            gasParticlesBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
        if (this.sphereDispList == -2) {
            this.sphereDispList = GL11.glGenLists((int)1);
            GL11.glNewList((int)this.sphereDispList, (int)4864);
            new Sphere().draw(1.0f, 30, 30);
            GL11.glEndList();
        }
        if (ShaderHelper.INSTANCE.isWorldShaderActive() && this.sphereDispList >= 0) {
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glColor4f((float)0.0f, (float)(0.4f + (float)(Math.sin((float)System.nanoTime() / 5.0E8f) + 1.0) * 0.2f), (float)(0.8f - (float)(Math.cos((float)System.nanoTime() / 4.0E8f) + 1.0) * 0.2f), (float)1.0f);
            GL11.glDisable((int)2884);
            shader = ShaderHelper.INSTANCE.getCurrentShader();
            if (shader != null) {
                GeometryBuffer geometryBuffer = shader.getGeometryBuffer("repellerShield");
                geometryBuffer.bind();
                geometryBuffer.clear(0.0f, 0.0f, 0.0f, 0.0f);
                for (Map.Entry entry : this.repellerShields) {
                    Vector3d pos2 = (Vector3d)entry.getKey();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)pos2.x, (double)pos2.y, (double)pos2.z);
                    GL11.glScaled((double)((Float)entry.getValue()).floatValue(), (double)((Float)entry.getValue()).floatValue(), (double)((Float)entry.getValue()).floatValue());
                    GL11.glCallList((int)this.sphereDispList);
                    GL11.glPopMatrix();
                }
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2884);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        } else if (this.sphereDispList >= 0) {
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glCullFace((int)1029);
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glColor4f((float)0.0f, (float)((0.4f + (float)(Math.sin((float)System.nanoTime() / 5.0E8f) + 1.0) * 0.2f) / 3.0f), (float)((0.8f - (float)(Math.cos((float)System.nanoTime() / 4.0E8f) + 1.0) * 0.2f) / 3.0f), (float)0.3f);
            for (Map.Entry<Map.Entry<Object, Object>, Object> entry : this.repellerShields) {
                pos = (Vector3d)entry.getKey();
                GL11.glPushMatrix();
                GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
                GL11.glScaled((double)((Float)entry.getValue()).floatValue(), (double)((Float)entry.getValue()).floatValue(), (double)((Float)entry.getValue()).floatValue());
                GL11.glCallList((int)this.sphereDispList);
                GL11.glPopMatrix();
            }
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
        }
        this.repellerShields.clear();
    }
}

